/*
 * sed.c: has the old (broken) encryption stuff.
 *
 * Written By Michael Sandrof
 *
 * Copyright (c) 1990 Michael Sandrof.
 * Copyright (c) 1991, 1992 Troy Rollo.
 * Copyright (c) 1992-2001 Matthew R. Green.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * note this source file is designed to be #include'd by crypt.c.
 * this is why the rcsid below is an expansion of the IRCII_RCSID
 * macro, rather than using it.
 */

#ifndef lint
static	const char sed_rcsid[] __attribute__((unused)) = "@(#)$eterna: sed.c,v 2.10 2001/08/12 16:25:03 mrg Exp $";
#endif /* lint */

static	int	sed_encrypt_str _((crypt_key *, u_char **, int *));
static	int	sed_decrypt_str _((crypt_key *, u_char **, int *));

/*
 * these are the old, broken crypt functions.  "cast.c" includes
 */
static	int
sed_encrypt_str(key, str, len)
	crypt_key	*key;
	u_char	**str;
	int	*len;
{
	int	key_len,
		key_pos,
		i;
	u_char	mix,
		tmp;

	key_len = my_strlen(key->key);
	key_pos = 0;
	mix = 0;
	for (i = 0; i < *len; i++)
	{
		tmp = (*str)[i];
		(*str)[i] = mix ^ tmp ^ key->key[key_pos];
		mix ^= tmp;
		key_pos = (key_pos + 1) % key_len;
	}
	(*str)[i] = (u_char) 0;

	return (0);
}

static	int
sed_decrypt_str(key, str, len)
	crypt_key	*key;
	u_char	**str;
	int	*len;
{
	int	key_len,
		key_pos,
		i;
	u_char	mix,
		tmp;

	key_len = my_strlen(key->key);
	key_pos = 0;
	/*    mix = key->key[key_len-1]; */
	mix = 0;
	for (i = 0; i < *len; i++)
	{
		tmp = mix ^ (*str)[i] ^ key->key[key_pos];
		(*str)[i] = tmp;
		mix ^= tmp;
		key_pos = (key_pos + 1) % key_len;
	}
	(*str)[i] = (u_char) 0;

	return (0);
}
