<?php

# On récupère l'association : code Rne <-> url du portail SSO dan sle fichier etabs.ini
$ETABS = array();

// Utilisation d'un fichier json si disponible
$fichier_etabs_json = ROOT_DIR . "/utils/etabs.json";
if (file_exists($fichier_etabs_json)) {
    $ETABS=json_decode(file_get_contents($fichier_etabs_json),true);
}

// Fichier .ini
$fichier_etabs_ini = ROOT_DIR . "/utils/etabs.ini";
if (file_exists($fichier_etabs_ini) && (count($ETABS) == 0) ) {
    $ETABS = parse_ini_file($fichier_etabs_ini,true,INI_SCANNER_RAW );
    if (!$ETABS){
        echo "<div>".DisplayAppli("Fichier utils/etabs.ini invalide !", "", "ERREUR")."</div>";
    }
}





# ===============================================================================
# BAD_SESSION() : Affiché lorsqu'un personnel de L'Education National,
# se connecte avec son login Scribe
function BAD_SESSION()
{
    echo "
          <body>
            Vous êtes un personnel de l'Education Nationale,<br>
             veuillez donc utiliser vos identifiants académiques pour vous connecter.
            <br>
            <a href='logout.php?url=".$_SERVER[SCRIPT_NAME]."'>Cliquer ici pour vous reconnecter</a>
          </body>
    ";
    die();
}


/* On va vérifier que l'utilisateur est dans l'annuaire consolidé */
function GetRneEntryInScribeForAcadUser($mail)
{
    $ds=ldap_connect("localhost");
    $infos=array("dn");
    $sr=ldap_search($ds,"ou=education,o=gouv,c=fr", "FederationKey=".strtolower($mail),$infos);
    $infos = ldap_get_entries($ds, $sr);

    $rnes=array();

    $count= $infos['count'];
    for ($i=0;$i<$count;$i++)
    {
        if (ereg("(.*),ou=(.*),ou=.*,ou=education,o=gouv,c=fr",$infos[$i]['dn'],$regs))
        {
            $r=strtoupper($regs[2]);
            $rnes[]=strtoupper($r);
        }
    }

    return $rnes;
}


function GetRne()
{
    @$rnes=array_unique(GetInfoArray("rne"));
    return $rnes;
}

function http_file_exists($url)
{
    $f=@fopen($url,"r");
    if($f)
    {
        $output = stream_get_contents($f);
        fclose($f);
        if ( strpos($output,"username") !== False )
        {
            //die ($output);
            return true;
        }
    }
    return false;
}


//
// Construction de la liste des portails ENT
// la variable global _TEST_PORTAIL , permet de définir si on test avant de proposer la redirection
function BuildListOfENT($AutoRedirectIfOneEntry = False)
{
    $arr=GetRne();

    // On S'assure que c'est un tableau
    if (!$arr || !is_array($arr) || count($arr)==0) {
      $arr=array("");
    }

    // Compatibilité ascendante :: Cas des rnes séparés par un e,
    if (count($arr)==0) {
      $arr=explode(",",$arr[0]);
    }

    $portails=array();

    $errorlevel=error_reporting();
    //error_reporting(0);

    // On souhaite montrer le portail PIA a tout le personnel EN (cad: disposant d'une authentification académique (ie: IsAuthAcad()==true )
    if ( _FORCE_PIA && (IsAuthAcad() || IsEnseignant()))
    {
  		if(_RNE_PORTAIL_ACA!="") {
              if(!in_array(_RNE_PORTAIL_ACA,$arr)) {
      	    		array_push($arr,_RNE_PORTAIL_ACA);
      		    	array_unique($arr) ;
              }
  		}
    }

    $count=0;$url="";$AuMoinsUnEtabEnt=false;
    // Pour chaque Rne
    foreach ( $arr as $rne)
    {

        # Nom du portail pour l'afficher à l'utilisateur
        $portail=GetPortailFromRne($rne);

        # Pas de portail trouvé, on passe au suivant
        if ( $portail === False ) {
			       Arena_Appli("#1: [".$rne . "] aucun portail trouvé ", "","WARNING");
             $portails[]=array("rne"=>"$rne","url"=>"","label"=>"");
            continue;
        }
        elseif (  $portail == "" ) {
            // si pas d'ent installé (ie: url du portail est la chaine vide), on informe l'utilisteur
            Arena_Appli("#100: [".$rne . "] " .GetLibelleEtabFromRne($rne) . " ne dispose pas encore d'un ENT", "","WARNING");
            $portails[]=array("rne"=>"$rne","url"=>"","label"=>GetLibelleEtabFromRne($rne));
        }
        else
        {

            $AuMoinsUnEtabEnt=true;

            $test=0;
            $url="https://"._SERVEUR_SSO.":"._SERVEUR_SSO_PORT."/saml?sp_ident=".$rne."&RelayState="._PROTOCOLE_ENT."://".GetUrlPortailFromRne($rne);

			      // Test de l'accès au portail (si _TEST_PORTAIL)
            {
				        // OK, on propose le lien d'accès
                if ( !_TEST_PORTAIL || http_file_exists($portail))
                {
                    Arena_Appli(" [".$rne . "] " .GetLibelleEtabFromRne($rne),$url);
                    $portails[]=array("rne"=>"$rne","url"=>$url,"label"=>GetLibelleEtabFromRne($rne),"portal"=>GetUrlPortailFromRne($rne));
                    $count++;
                }
        				// ECHEC, on affiche de un message d'erreur
        				else
                        {
                            Arena_Appli("#200: [".$rne . "] " .GetLibelleEtabFromRne($rne). " semble indisponible pour le moment (Scribe injoignable)","","ERREUR");
                            Arena_Appli("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;=> Cliquez ici pour essayer l'accès à " .GetLibelleEtabFromRne($rne),$url);
                            $portails[]=array("rne"=>"$rne","url"=>$url,"label"=>GetLibelleEtabFromRne($rne),"portal"=>GetUrlPortailFromRne($rne),"error"=>true);
                        }
                    }
                }
    }

    // Si un seul établissement et autoredirect
    if ( ($AutoRedirectIfOneEntry) && ($count == 1) )
    {
        echo '<SCRIPT LANGUAGE="JavaScript">';
        echo ' document.location.href="' . $url .'"';
        echo '</SCRIPT>';
    }

    // Pas d'établissement trouvé
    if ( ( $count == 0 ) && ($AuMoinsUnEtabEnt))
    {
        $CODE="($rne)";
        if (  IsAuthAcad() ){
            $CODE="ACAD=[$rne] ENT=[". implode(",",$arr) ."]";
        }

        echo "<tr height='20px'></tr>";
        DisplayAppli("&nbsp;&nbsp;&nbsp; <b> >>#300: Aucun ENT n'est disponible pour vos affectations $CODE<< </b>", "");
        echo "<tr height='20px'></tr>";

        Arena_Appli("Accéder au site internet dédié à l'ENT", _URL_PORTAIL_DEFAUT);

    }

    // Aucun établissement ENT pour cet utilisateur, on redirige donc vers les services académiques
    if (  !$AuMoinsUnEtabEnt )
    {
        Arena_Appli("Si vous n'êtes pas redirigé automatiquement, cliquer ici pour accéder aux applications académiques", _URL_PORTAIL_ACA);
        echo '<SCRIPT LANGUAGE="JavaScript">';
        echo '// document.location.href="' . _URL_PORTAIL_ACA .'"';
        echo '</SCRIPT>';

    }

    error_reporting($errorlevel);
    return $portails;

}


/* =========================================================*/

function input_validation ($data, $charset = 'UTF-8') {
    if (is_array ($data)) {
        foreach ($data as $key => $value) {
            $data[$key] = input_validation ($value);
        }
    }
    else {
        $data = htmlentities (trim ($data), ENT_QUOTES, $charset);
    }
    return $data;
}


/* ref: #7376: */
/* ----------------------------------------------------------------------*/
/* Exemple: https://portail.ac-academie.fr/arena (dans utils/etabs.ini)  */
/* ----------------------------------------------------------------------*/
/* GetUrlPortailFromRne : return portail.ac-academie.fr/arena            */
/* GetPortailFromRne    : return portail.ac-academie.fr                  */
/* GetRealPortailFromRne: return https://portail.ac-academie.fr/arena    */
function GetUrlPortailFromRne($rne)
{
    $portail=GetRealPortailFromRne($rne);
    if ($portail==false) return false;
    $c=parse_url($portail);
    return $c["host"].$c["path"].$c["query"];
}

function GetPortailFromRne($rne)
{
   $portail=GetRealPortailFromRne($rne);
   if ($portail==false) return false;
   return parse_url($portail, PHP_URL_HOST);
}


function GetRealPortailFromRne($rne)
{
    global $ETABS;
    $pos = strpos($rne,",");
    if ( $pos !== false )
    {
        return "Plusieurs établissements : $rne";
    }


    if (isset($ETABS[$rne])) {
        if (isset($ETABS[$rne]["portail"])) {
            return $ETABS[$rne]["portail"];
        }
    }

    return false;
}
/* -----------------------------------------------------------------------*/

function GetRneFromPortail($portail)
{
    global $ETABS;

    while ($rne = current($ETABS)) {
		if($rne["portail"]==$portail) {
			return key($ETABS);
		}
		next($ETABS);
	}

    return false;
}

# ===========================================================================
# GetLibelleEtabFromRne($rne)
# Récurépartion du libelle de l'établissement en fonction de son RNE
function GetLibelleEtabFromRne($rne)
{
    global $ETABS;
    $pos = strpos($rne,",");
    if ( $pos !== false )
    {
        return "Plusieurs établissements : $rne";
    }

    if (!isset($ETABS[$rne])) {
        return "$rne";
    }

    if (!isset($ETABS[$rne]["libelle"])) {
        return "$rne";
    }

    return $ETABS[$rne]["libelle"];
}

function GetLibelleEtab()
{
    return GetLibelleEtabFromRne(GetRne());
}


# ----------------------------------------------------------------------------
# Nomenclature nationale des profils utilisateurs
#    National_1 : Élève
#    National_2 : Responsable d'un élève (parent, tuteur légal)
#    National_3 : Enseignant
#    National_4 : Personnel de direction de l'établissement
#    National_5 : Personnel de vie scolaire travaillant dans l'établissement
#    National_6 : Personnel administratif, technique ou d'encadrement
#                  travaillant dans l'établissement
#    National_7 : Personnel de rectorat, de DRAF, de collectivité locale,
#                 d'inspection académique
function GetProfil()        {return GetInfo("profils");}
function GetProfilLibelle()
{
    switch (GetProfil())
    {
        case "National_1":return "Élève";
        case "National_2":return "Responsable";
        case "National_3":return "Enseignant" . GetLibelleOTP();
        case "National_4":return "Direction" . GetLibelleOTP();
        case "National_5":return "Vie scolaire" . GetLibelleOTP() ;
        case "National_6":return "Administratif" . GetLibelleOTP() ;
        case "National_7":return "Académique" . GetLibelleOTP();
    }
    return GetProfil();
}

# ----------------------------------------------------------------------------
# ip_in_network($ip, $net_addr, $net_mask)
# -----------------------------------------------------------------------------
# permet de determiner si $ip est dans le réseau $net_addr/$net_mask
function ip_in_network($ip, $net_addr, $net_mask){
    if($net_mask <= 0){ return false; }
        $ip_binary_string = sprintf("%032b",ip2long($ip));
        $net_binary_string = sprintf("%032b",ip2long($net_addr));
        return (substr_compare($ip_binary_string,$net_binary_string,0,$net_mask) === 0);
}


# ==============================================================================
# GetInfo($key) : Récupère un attribut CAS, identifié par $key
function GetInfo($key)
{
    return $_SESSION["CASATTRIBUTE"][$key][0];
}

function GetInfoArray($key)
{
    return $_SESSION["CASATTRIBUTE"][$key];
}

# Quelques raccourcis pour récupérer des attributs CAS
function IsEnseignant() {return GetProfil()=="National_3";}
function IsEleve()  	{return GetProfil()=="National_1";}
function IsParent() 	{return GetProfil()=="National_2";}
function IsRectorat()   {return GetProfil()=="RECTORAT";}
function IsInspecteur() {return GetProfil()=="INSPECTEUR";}

function IsOTP()    	{return GetInfo("auth") == "OTP";}

function GetUid()       	{return GetInfo("user");}
function GetInId()      	{return GetInfo("uid");}
function IsAuthAcad()       	{return GetInfo("source")=="ACADEMIQUE";}
function GetFederationKey()     {return GetInfo("FederationKey");}
function GetDisplayName()   	{return GetInfo("displayName");}
function GetTicket()        	{return $_SESSION["id"];}
function GetPortail()
{
    return GetPortailFromRne(GetRne());
}
function HasFederationKey()     { return isset($_SESSION["CASATTRIBUTE"]["FederationKey"]);}


function GetLibelleOTP()
{
    if (IsOTP()) return " OTP";
    else "";
}
# ==========================================================
#


?>
