<?php

define( 'REDBEAN_MODEL_PREFIX', '' );


// Cache Arena ====================================================
class Arenacache extends RedBean_SimpleModel {

  public function dispense() {
      $this->created=new DateTime();
      $this->setCache(null);
  }

  public function update() {
      $cache=$this->getCache();
      $this->content=serialize($cache);
  }

  public function open() {
    $cache=unserialize($this->content);
    $this->bean->setMeta("cache",$cache);
  }

  public function getCache() {
    return $this->bean->getMeta("cache");
  }

  public function setCache($cache) {
    $this->updated=new DateTime();
    $this->locked=false;
    $this->bean->setMeta("cache",$cache);
  }

  public function access() {
    $this->acceded=new DateTime();
  }

  public function isRecent() {
    if ($this->getCache()==null) return false;

    $t1=new DateTime($this->updated);
    $interval=$t1->diff(new DateTime());
    return $interval->days/24 < __CACHE_DURATION;
  }
}

// Favoris =================================================================

class Favoris extends RedBean_SimpleModel {
  public function dispense() {
      $this->created=new DateTime();
  }

  public function update() {
      $this->updated=new DateTime();
  }

  public function toArray() {
    $a=array("url"=>$this->url);
    if ($this->nom)     $a["nom"]     = $this->nom;
    if ($this->libelle) $a["libelle"] = $this->libelle;
    if ($this->icon)    $a["icon"]    = $this->icon;

    return $a;

  }

}
