<?php

namespace Edispatcher\Controllers;
use \Psr\Http\Message\ServerRequestInterface as Request;
use \Psr\Http\Message\ResponseInterface as Response;
use Slim\Container;
use Slim\Slim;

define("ICON_URL_PATH"       , "public/icons");
define("ICON_CACHE_DIRECTORY", ROOT_DIR . "/ng/" . ICON_URL_PATH);

use Edispatcher\Entity\Application;
use Edispatcher\Entity\Param;

class ApiController extends BaseController {

  // ICONE mise en filesystem ===================================================
  public static function checkCacheIconDirectory() {
     if (!file_exists(ICON_CACHE_DIRECTORY)) {
        mkdir(ICON_CACHE_DIRECTORY, 0755, true);
    }
  }

  public static function getIconPath($type,$id) {
      return ICON_CACHE_DIRECTORY . "/" .$type ."_" . $id . ".png";
  }
  // ============================================================================

  public function hasIconPath($type,$id) {
      return self::_hasIconPath($type,$id,$this->ci["router"]);
  }

  public static function _hasIconPath($type,$id,$router) {
      $filename= self::getIconPath($type,$id);
      if (file_exists($filename)) {return $router->pathFor('home')  . ICON_URL_PATH."/$type" ."_" . $id . ".png";}
      return false;
  }

  public function gdTransparentAction(Request $request, Response $response, $args) {
    $im = imagecreatefrompng("https://hubole.ac-reunion.fr/edispatcher/local/icones/contact-list.png");
    $img_w = imagesx($picture);
    $img_h = imagesy($picture);

    $black = imagecolorallocate($im, 255, 255, 255);
    $bg_color = imagecolorat($im,1,1);
    imagecolortransparent($im, $bg_color);
    header('Content-Type: image/png');
    imagepng($im);
    imagedestroy($im);
    die();
  }

  public function grafanaImageAction(Request $request, Response $response, $args) {
    $img = $args["id"];
    if (!file_exists("/tmp/".$img)) {
      header("HTTP/1.0 404 Not Found");
      die();
    }

    header('Content-Type: image/png');
    echo(file_get_contents("/tmp/".$img));

    die();

  }

  public function rocketchatHookAction(Request $request, Response $response, $args) {
    global $__METRICS;

    if (!is_array($__METRICS)) die();
    if (!isset($__METRICS["rocketchat"])) die();
    if (!isset($__METRICS["rocketchat"]["hook_url"])) die();

    $data=$request->getParsedBody();
     /*$data = '{
    "evalMatches":[
    {
    "value":52.974461788355,
    "metric":"hubole-master",
    "tags":null
    }
    ],
    "imageUrl":"https://magmatic.ac-reunion.fr/owncloud/remote.php/webdav/grafana/hHGTpUlOq3P1ru28ErNy.png",
    "message":"Veuillez vérifier les filesystem de hubole-master et hubole-slave",
    "ruleId":4,
    "ruleName":"Filesystem hubole",
    "ruleUrl":"http://localhost:3000/dashboard/db/metice-metrics?fullscreen&edit&tab=alert&panelId=14",
    "state":"alerting",
    "title":"[Alerting] Filesystem hubole"
    }';
    $data = json_decode($data, true); */

    $img = "";$path="";
    if (isset($data["imageUrl"])) {
      $f = $data["imageUrl"];
      $img  = basename($f);
      $path = dirname($f)."/";
    }

    if ($path && isset($__METRICS["grafana"]) ) {
      $settings = array(
      'baseUri' => $path,
      'userName' => $__METRICS["grafana"]["storage_usernane"],
      'password' => $__METRICS["grafana"]["storage_password"],
      );
      if (__PROXY) $settings["proxy"] = __PROXY;
      $dav = new \Sabre\DAV\Client($settings);
      $response = $dav->request('GET',$img);

      if ($response) {
        file_put_contents("/tmp/grafana-".$img,$response);
      } else {
        echo("GET $path".$img);
        echo("NO RESPONSE");
        $img = "";
      }
    }

    // Couleur en fonction de l'état
    $state = $data["state"];
    $COLOR = ["alerting" =>"#F00","pending" => "#FF0", "ok" => "#0F0" ];
    $color = isset($COLOR[$state])?$COLOR[$state]:"#929292";

    // Initialisation du client
    $client=new \Edispatcher\Bot\RocketchatClient($__METRICS["rocketchat"]["hook_url"],$__METRICS["rocketchat"]["bot_token"]);
    if (__PROXY) $client->setHttpOptions(["proxy"=>['https' => __PROXY, 'http' => __PROXY ]]);

    // construction de l'attachment
    $attachment=["title"=>$data["title"],"text"=>$data["message"],"color"=>$color];

    if ($img) {
        $attachment["image_url"] = _URL_DISPATCHER  . $this->ci->get('router')->pathFor('grafana_image',["id"=>"grafana-".$img]);
    }

    if (is_array($data["evalMatches"])) {
      $attachment['fields']=[];
      foreach ($data["evalMatches"] as $fields) {
        $attachment['fields'][] =  [ "title" => $fields["metric"], "value" => $fields["value"]];
      }
    }

    // Envoie du message
    $response = $client->payload([
      'text' => $data["title"],
      'attachments' => [$attachment]
    ]);

    $code = $response->getStatusCode(); // 200
    $reason = $response->getReasonPhrase(); // OK

    die("$code $reason");


  }

  public function grafanaHookAction(Request $request, Response $response, $args) {
    global $__METRICS;

    if (!is_array($__METRICS)) die();
    if (!isset($__METRICS["slack"])) die();
    if (!isset($__METRICS["slack"]["hook_url"])) die();

    $data=$request->getParsedBody();
    /* $data = '{
    "evalMatches":[
    {
    "value":52.974461788355,
    "metric":"hubole-master",
    "tags":null
    }
    ],
    "imageUrl":"https://magmatic.ac-reunion.fr/owncloud/remote.php/webdav/grafana/hHGTpUlOq3P1ru28ErNy.png",
    "message":"Veuillez vérifier les filesystem de hubole-master et hubole-slave",
    "ruleId":4,
    "ruleName":"Filesystem hubole",
    "ruleUrl":"http://localhost:3000/dashboard/db/metice-metrics?fullscreen&edit&tab=alert&panelId=14",
    "state":"alerting",
    "title":"[Alerting] Filesystem hubole"
    }';
    $data = json_decode($data, true); */

    file_put_contents("/tmp/hook.json",json_encode($data));
    $this->rocketchatHookAction($request, $response, $args);

    $img = "";$path="";
    if (isset($data["imageUrl"])) {
      $f = $data["imageUrl"];
      $img  = basename($f);
      $path = dirname($f)."/";
    }

    if ($path && isset($__METRICS["grafana"]) ) {
      $settings = array(
      'baseUri' => $path,
      'userName' => $__METRICS["grafana"]["storage_usernane"],
      'password' => $__METRICS["grafana"]["storage_password"],
      );
      if (__PROXY) $settings["proxy"] = __PROXY;
      $dav = new \Sabre\DAV\Client($settings);
      $response = $dav->request('GET',$img);

      if ($response) {
        file_put_contents("/tmp/grafana-".$img,$response);
      } else {
        echo("GET $path".$img);
        echo("NO RESPONSE");
        $img = "";
      }
    }


    $state = $data["state"];
    $COLOR = ["alerting" =>"danger","pending" => "warning", "ok" => "good" ];

    $settings = null;
    if (__PROXY) $settings = ["proxy"=>['https' => __PROXY, 'http' => __PROXY ]];
    $http =  new \GuzzleHttp\Client($settings);
    $client = new \Maknz\Slack\Client($__METRICS["slack"]["hook_url"],[],$http);

    $attach = [
      'fallback'=> $data["message"],
      'text'=> $data["message"],
      'pretext'=> "",

      'color'       => isset($COLOR[$state])?$COLOR[$state]:"#929292",
      'title'       => $data["title"],
      'title_link'  => str_replace("localhost:3000","apps.in.ac-reunion.fr:3000",$data["ruleUrl"]),
      'ts'          => time(),

      'fields'  => [],

      'author_name' => "Hubole Grafana Hook",
      'author_icon' => "http://grafana.org/assets/img/fav32.png",
      'footer'      => "Alert from Grafana",
    ];

    if ($img) {
      $attach["image_url"] = _URL_DISPATCHER  . $this->ci->get('router')->pathFor('grafana_image',["id"=>"grafana-".$img]);
      echo $attach["image_url"];
    }

    if ($state=="alerting") {
      $attach["text"] = $data["message"];
    }

    if ($state=="ok") {
      $attach["text"] = "";
      $attach["pretext"] = "";
    }

    if (is_array($data["evalMatches"])) {
      foreach ($data["evalMatches"] as $fields) {
        $attach['fields'][] =  [ "title" => $fields["metric"], "value" => $fields["value"]];
      }
    }

    $client->attach($attach)->send($data["title"]);

    die("");
  }

  public function viewIconAction(Request $request, Response $response, $args) {
    // Regarde si il y a une icon sur le FileSystem
    if ($path = $this->hasIconPath("icon",$args["id"])) {return $response->withRedirect($path);}

    $icon=\R::findOne( 'icon', 'id = ?', array($args["id"]));
    if (!$icon) {
        $icon = \R::dispense('icon');
        $icon->icon = file_get_contents("public/images/unknown-icon.png");
        // DEBUT Modif CS - NICE (Prise en compte des SVG)
        if(!$icon->icon) {$icon->icon = file_get_contents("public/images/unknown-icon.svg");}
        // FIN Modif CS - NICE
        $icon->md5icon = md5($icon->icon);
    }
    $response->getBody()->write($icon->icon);
    $response=$this->ci['cache']->withExpires($response, gmdate(DATE_RFC1123,time()+60*60*24*2));
    $response=$this->ci['cache']->withEtag($response, $icon->md5icon);
    header_remove("Cache-Control");
    header_remove("Pragma");
    header_remove("Expires");

    
   

    // DEBUT Modif CS - Nice (Prise en compte des SVG)
    if (substr($icon->icon,0,4) == "<svg" || $icon->svg) {$contentType = 'image/svg+xml';}
    else {$contentType = 'image/png' ;}

    return $response->withHeader('Content-Type', $contentType)
          ->withHeader('Cache-Control', 'max-age='.(60*60*24*2))
          ->withHeader("Pragma",'cache')
          ->withHeader("Content-Length" , strlen($icon->icon));
    // FIN Modif CS - Nice


  }


  public function urlIconAction(Request $request, Response $response, $args) {

    // Regarde si il y a une icon sur le FileSystem
    if ($path = $this->hasIconPath("url",$args["id"])) {return $response->withRedirect($path);}

    $url=\R::findOne( 'url', 'id = ?', array($args["id"]));
    if (!$url) {
      return "";
    }
    $icon = $url->icon;
    $response->getBody()->write($icon->icon);

    $response=$this->ci['cache']->withExpires($response, gmdate(DATE_RFC1123,time()+60*60*24*2));
    $response=$this->ci['cache']->withEtag($response, $icon->md5icon);

    header_remove("Cache-Control");
    header_remove("Pragma");
    header_remove("Expires");

    // DEBUT Modif CS - NICE (Prise en compte des SVG)
    if(substr($icon->icon,0,4) == "<svg" || $icon->svg ) {$contentType = 'image/svg+xml';}
    else {$contentType = 'image/png' ;}
    return $response->withHeader('Content-Type', $contentType)
          ->withHeader('Cache-Control', 'max-age='.(60*60*24*2))
          ->withHeader("Pragma",'cache')
          ->withHeader("Content-Length" , strlen($icon->icon));
    // FIN Modif CS - NICE (Prise en compte des SVG)


  }

  public function catIconAction(Request $request, Response $response, $args) {

    // Regarde si il y a une icon sur le FileSystem
    if ($path = $this->hasIconPath("cat",$args["id"])) {return $response->withRedirect($path);}

    $cat=\R::findOne( 'category', 'id = ?', array($args["id"]));
    if (!$cat) {
      return $args["id"];
    }

    if ($cat->icon) {
      //die("hhh");
      $icon = $cat->icon;
      $response->getBody()->write($icon->icon);

      $response=$this->ci['cache']->withExpires($response, gmdate(DATE_RFC1123,time()+60*60*24*2));
      $response=$this->ci['cache']->withEtag($response, $icon->md5icon);

      header_remove("Cache-Control");
      header_remove("Pragma");
      header_remove("Expires");

      // DEBUT Modif CS - NICE (Prise en compte des SVG)
      if(substr($icon->icon,0,4) == "<svg") {$contentType = 'image/svg+xml';}
      else {$contentType = 'image/png' ;}
      return $response->withHeader('Content-Type', $contentType)
            ->withHeader('Cache-Control', 'max-age='.(60*60*24*2))
            ->withHeader("Pragma",'cache')
            ->withHeader("Content-Length" , strlen($icon->icon));
      // FIN Modif CS - NICE (Prise en compte des SVG)
    }
    
    return $cat->icon;
   }


  public function appIconAction(Request $request, Response $response, $args) {

    // Regarde si il y a une icon sur le FileSystem
    if ($path = $this->hasIconPath("app",$args["id"])) {return $response->withRedirect($path);}

    $app=\R::findOne( 'app', 'id = ?', array($args["id"]));
    if (!$app) {
      return "";
    }
    $icone = $app->icon;
    if ($icone) {
        $icon = $icone->icon;
    }
    else {
        $icon = file_get_contents("public/images/unknown-icon.png");
        // DEBUT Modif CS - NICE (Prise en compte des SVG)
        if(!$icon) $icon = file_get_contents("public/images/unknown-icon.svg");
        // FIN Modif CS - NICE
    }
    $response->getBody()->write($icon);

    $response=$this->ci['cache']->withExpires($response, gmdate(DATE_RFC1123,time()+60*60*24*2));
    $response=$this->ci['cache']->withEtag($response, $app->iconUpdatedAt);

    header_remove("Cache-Control");
    header_remove("Pragma");
    header_remove("Expires");

    // DEBUT Modif CS - NICE (Prise en compte des SVG)
    if(substr($icon->icon,0,4) == "<svg") {$contentType = 'image/svg+xml';}
    else {$contentType = 'image/png' ;}
    return $response->withHeader('Content-Type', $contentType)
          ->withHeader('Cache-Control', 'max-age='.(60*60*24*2))
          ->withHeader("Pragma",'cache')
          ->withHeader("Content-Length" , strlen($icon));
    // FIN Modif CS - NICE


  }


  public function AppsTopAction(Request $request, Response $response, $args) {
      if (!$this->hasMetrics())  {
          return $response->withJson(["success"=>false]);
      }

      $proil = $this->ci["profil"];
      $token= $profil->getHubToken();
      if (!$token) {
          return $response->withJson(["success"=>false]);
      }

      @$rnes=array_unique(GetInfoArray("rne"));
      $this->getMetrics()->appTop($rnes,$profil->getProfil());

  }

  public function incMetricsAction(Request $request, Response $response, $args) {
      if (!$this->hasMetrics())  {
          return $response->withJson(["success"=>false]);
      }

      $name     =   $args["name"];

      $labels=$request->getParsedBody();

      $this->getMetrics()->incMetrics($name,array_values($labels));

      return $response->withJson(["success"=>true]);

  }

  // Vérification si un token existe pour un has de user
  // hash = md5(intid)
  public function tokenHubAction(Request $request, Response $response, $args) {

    $response = $response->withHeader('Access-Control-Allow-Origin', "*");

    $token=\R::findOne( 'hubtoken','hash = ? or hashuser = ? order by timestamp DESC',[$args["hash"],$args["hash"]]);
    if (!$token) return $response->withJson(["success"=>false]);

    $now=new \DateTime("now");
    $diff = $now->getTimestamp() - (new \DateTime($token->timestamp))->getTimestamp() ;


    if ($diff > 60*2|| $token->logout == 1) {
      return $response->withJson(["success"=>false,"obsolete"=>$diff > 300,"logout"=>$token->logout]);
    }


    return $response->withJson(["success"=>true]);
  }

  public function configGetAction(Request $request, Response $response, $args) {

  }

  public function configSetAction(Request $request, Response $response, $args) {
    $token= $this->ci["profil"]->getHubToken();
    if (!$token) {
        return $response->withJson(["success"=>false]);
    }

    $data=$request->getParsedBody();

    $config = json_decode($token->config?$token->config:[],true);

    if (!isset($data["tmpl"])) {return $response->withJson(["success"=>false]);}
    if (!file_exists(DIR_VIEW.'/hub/'.$data["tmpl"].'.html.twig')) {return $response->withJson(["success"=>false]);}


    if (!isset($config[$data["tmpl"]])) {
      $config[$data["tmpl"]] = [];
    }
    $key   = $data["key"];
    $value = json_decode($data["value"]);
    $config[$data["tmpl"]][$key] = $value;

    $token->config = json_encode($config);
    \R::store($token);

    return $response->withJson(["success"=>true]);


  }

  // Gestion d'un cache des ressources ============================================================

  public function cacheSetAction(Request $request, Response $response, $args) {

    $token= $this->ci["profil"]->getHubToken();
    if (!$token) die();
    $key = $args["key"];

    $data=$request->getParsedBody();
    if (!array_key_exists("value", $data)) die("NO CACHE VALUE");
    if (!array_key_exists("version", $data)) die("NO CACHE VERSION");

    $now=new \DateTime("now");
    $cache=\R::findOne( 'cache', 'hubtoken_id = ? and uid = ?', array($token->id,$key));
    if (!$cache) {
      $cache=\R::dispense("cache");
      $cache->hubtoken = $token;
      $cache->uid = $key;
      $cache->createdAt=$now;
    }

    $cache->modifiedAt=$now;
    $cache->value=base64_encode($data["value"]);
    $cache->version=$data["version"];

    \R::store($cache);

    return  $response->withJson(["success"=>true]);

  }

  public function cacheGetAction(Request $request, Response $response, $args) {
    $token= $this->ci["profil"]->getHubToken();
    if (!$token) die();

    $caches=\R::find( 'cache', 'hubtoken_id = ?', array($token->id));
    $params["CACHES"] = $caches;

    $response=$response->withHeader('Content-Type', 'application/javascript');
    return $this->ci["view"]->render($response, 'cache.js.twig',$params);

  }

  public function cacheDelAction(Request $request, Response $response, $args) {
    $token= $this->ci["profil"]->getHubToken();
    if (!$token) die();

    $key = $args["key"];

    $cache=\R::findOne( 'cache', 'hubtoken_id = ?  and uid = ?', array($token->id,$key));
    if ($cache) {
        \R::trash($cache);
    }

    return $response->withJson(["success"=>true]);

  }


  // ===============================================================================================
  public function ressourcesSaveAction(Request $request, Response $response, $args) {
    $data=$request->getParsedBody();
    if (!array_key_exists("apps", $data)) die("NO APPS");

    $token= $this->ci["profil"]->getHubToken();
    if (!$token) die();

    $now=new \DateTime("now");
    $cache=\R::findOne( 'cache', 'hubtoken_id = ? and version = ?', array($token->id,"BACKUP"));
    if (!$cache) {
      $cache=\R::dispense("cache");
      $cache->hubtoken = $token;
      $cache->uid = $key;
      $cache->createdAt=$now;
      $cache->version="BACKUP";
    }

    $cache->modifiedAt=$now;
    $cache->value=$data["apps"];

    \R::store($cache);

    return  $response->withJson(["success"=>true]);

  }

  // ===============================================================================================
  public function ressourcesRestoreAction(Request $request, Response $response, $args) {
    $token= $this->ci["profil"]->getHubToken();
    if (!$token) die();
    $cache=\R::findOne( 'cache', 'hubtoken_id = ? and version = ?', array($token->id,"BACKUP"));
    $params["data"]=false;
    if ($cache) {
      $params["data"]=$cache->value;
    }
    $response=$response->withHeader('Content-Type', 'application/javascript');
    return $this->ci["view"]->render($response, 'ressources.js.twig',$params);
  }


  public function ressourcesAction(Request $request, Response $response, $args) {
    $data=$request->getParsedBody();
    if ($_SERVER['REQUEST_METHOD']=="JSON") {
        header($_SERVER['SERVER_PROTOCOL'] . ' 500 Internal Server Error', true, 500);
        /*print_r($_POST);
        print_r($_GET);
        $post = file_get_contents('php://input');
        print_r($post);*/
        die();
    }


    if (count($data)==0 && !isset($data["XMLHttpRequest"])) die("NO DATA");
    if (!array_key_exists("apps", $data) && ! isset($data["XMLHttpRequest"])) die("NO APPS");


    // récupération du profil ==============================================
    $profilName="";$profil=null;
    if (array_key_exists("profils", $_SESSION["CASATTRIBUTE"])) {
      $profilName=$_SESSION["CASATTRIBUTE"]["profils"][0];
    }


    if ($profilName) {
      $profil=\R::findOne( 'profil', 'name = ?', array($profilName));
      if (!$profil) {
        $profil=\R::dispense("profil");
        $profil->name=$profilName;
        \R::store($profil);
      }
    }
    // =====================================================================

    $metrics = $this->getMetrics();
    // fixes #20988 Decodage en base64 pour eviter  max_input_vars
    $apps=json_decode(urldecode(base64_decode($data["apps"])),true);
    $retour=[];

    $user= $this->ci["profil"]->getUser();
    

    // Cas d'une XMLHttpRequest / Content-Disposition: form-data
    /*if (isset($data["XMLHttpRequest"])) {
      $apps=json_decode($apps,true);
    }*/

    // ref #23635 et # 24325 | Flag pour gérer la version 
    $isDbVersion2 = intval($this->getParamValue(Param::DB_VERSION,"1")) >= intval(Param::DB_VERSION_2);

    foreach ($apps as $entry) {
      $url=$entry['url'];
      $orign="";


      $a=explode("/",$url);
      if (count($a)<3) continue;

      // Explode host and path
      $path=implode("/",array_slice($a,3));
      $host=$a[2];


      // Récupération des informations
      $bNewUrl = false;
      if ($isDbVersion2) {
        $eUrl=\R::findOne( 'url', 'md5url = ?', array(md5($url)));
      } else {
        $eUrl=\R::findOne( 'url', 'url = ?', array($url));
      }

    

      // TRAITEMENT DES APPS ARENA   ==============================================================================================
      //Si on a défini l'alime auto à true, on traite les urls ARENA et on les enregistre, sinon on skippe les urls ARENA
      if ((!($entry['resarena'])) || (__APP_MANAGER_ALIM_AUTO == true)) {

        // Url non trouvée, on va rechercher par 'resarena'
        if (!$eUrl && isset($entry['resarena']) && $entry['resarena']) {
            $eUrl=\R::findOne( 'url', 'resarena = ?', array($entry['resarena']));
        }

        // Url doit être identique, sinon c'est pas la même ressource
        if ($eUrl->url!=$url) {
          $eUrl=null;
        }

        if (!$eUrl) {
          $eUrl=\R::dispense("url");
          $eUrl->url       = $url;
          $eUrl->md5url    = md5($url);         //AJOUT NICE (MD5 URL)
          $eUrl->host      = $host;
          $eUrl->libelle   = $entry['libelle'];
          $bNewUrl         = true;

          // SI resarena est passé on va le positionner
          if ( isset($entry['resarena']) && $entry['resarena'] ) {
              $eUrl->resarena = $entry['resarena'];
          }

          $icon=file_get_contents($entry['icon'],False, $STREAM_CONTEXT);
          $key=md5($icon);

          //CODE POUR CONTINUER A GERER AVEC ICONES EN TABLE SEP
          // JE COMMENTE POUR QU'ON COMPRENNE BIEN CE QUI SE PASSE
          // On cherche d'abord une icone identique
          $i = \R::findOne( 'icon' , 'md5icon = ?' , array($key) );
          //Si on la trouve pas on la crée
          if (!$i) {
            $i = \R::dispense("icon");
            $i->icon = $icon;
            $i->md5icon = $key;
            $i->updated_at = new \DateTime();
            \R::store($i);
          }

          //L'objet icone existe, maintenant on cherche si une app existante a cette icone
          $a=\R::findOne( 'app' , 'icon_id = ?' , array($i->id) );
          // Si elle existe pas on la crée
          if (!$a) {
            $a=\R::dispense("app");
            //on lui assigne comme uid le md5 de l'icone
            $a->uid = $key;
            //et comme icone la relation à l'icone créée précedemment
            $a->icon = $i;
          }

          // resarena est passé => C'est une app arena
          if ( isset($entry['resarena']) && $entry['resarena'] ) {
              $app->origin = "Arena";
          }

          try {
            // Nouvelle URL, on va essayer de la sauvegarder
            // Si  la sauvegarde echoue 
            // (ie: url existante car accès concurent (unicité du md5url) on passe à l'url suivante  )
            if ($bNewUrl) {\R::store($eUrl);}
          
            $a->ownUrlList[] = $eUrl;
            \R::store($a);

            $eUrl->app = $a;
            \R::store($eUrl);

          } catch ( \Exception $e ) {
            // Récup url existante
            $eUrl=\R::findOne( 'url', 'md5url = ?', array(md5($url)));
          }
        } // fin de !$eUrl 

        // resarena est passé mais pas présent sur url => on va ajouter
        if ( isset($entry['resarena']) && $entry['resarena'] && $eUrl && !$eUrl->resarena  ) {
              $eUrl->resarena = $entry['resarena'];
              \R::store($eUrl);
        }
      } // fin de APP_ARENA && __APP_MANAGER_ALIM_AUTO ============================================================================


      if ($eUrl && $eUrl->getApp()) {
        $eApp=$eUrl->getApp();

        $favurl = 0;

        $desc    = "";
        $libelle = "";
        $icon    = "";
        $cat     = "";
        $zone    = "";

        // L'application a été décrite
        if ($eApp->description != 'n/a' && $eApp->description) {
            $desc = $eApp->description;
        }
        elseif ($eUrl->resarena && !$desc && !__APP_MANAGER_ALIM_AUTO) {
            $desc =  "Ressource ARENA";
        }

        if ($eApp->used)
        {
          // Icon de l'appli
          if ($eApp->libelle && $eApp->libelle != "_COMMUN_") {
            $libelle = "<span class='app-libelle'>" . $eApp->libelle . "</span>";
            // Si l'établissement a précisé que l'icone est locale sur le lien de l'application
            // on ne va pas utiliser l'icone défini sur appManager
            if ( (strpos($eUrl->url,"icone=local") === FALSE ) ) {
              // Regarde si il y a une icon sur le FileSystem
              // Icone local sur FS, on la return
              // TODO : modification en icon/id/view : vérifier la nouvelle syntaxe (pour l'instant je laisse en comment l'ancienne version)
              // if ($path = $this->hasIconPath("app",$eApp->id)) {$icon=_URL_DISPATCHER . $path;} else {
              if ($path = $this->hasIconPath("icon",$eApp->icon_id)) {$icon=_URL_DISPATCHER . $path;} 
              else {
                // $icon =  _URL_DISPATCHER . $this->ci["router"]->pathFor('app_icon',['id'=>$eApp->id]);
                $icon =  _URL_DISPATCHER . $this->ci["router"]->pathFor('icon_view',['id'=>$eApp->icon_id]);
              }

              //if ($eUrl->icon && (!is_null($eUrl->icon)) && $eUrl->icon != '') {    //Pour compatibilité avec icones en table séparée (l'icone devient un objet RB)
              if ($eUrl->icon) {
                // Icone local sur FS, on la return
                //  if ($path = $this->hasIconPath("url",$eUrl->id)) {$icon=_URL_DISPATCHER . $path;} else {
                if ($path = $this->hasIconPath("url",$eUrl->icon_id)) {$icon=_URL_DISPATCHER . $path;} 
                else {
                  //$icon =  _URL_DISPATCHER . $this->ci["router"]->pathFor('url_icon',['id'=>$eUrl->id]);
                  $icon =  _URL_DISPATCHER . $this->ci["router"]->pathFor('icon_view',['id'=>$eUrl->icon_id]);
                }
              }
            }
          } // Fin Icone de l'appli

          // Le libelle de l'url est redefini
          if ($eUrl->libelle && $eUrl->libelle != $eApp->libelle) {

            if ($eApp->libelle == "_COMMUN_") {
              $desc    =  $eUrl->libelle;
              $libelle =  $eUrl->libelle;
            } else {
              $desc    =  $desc . "<br>" . $eUrl->description;
              $libelle =  "<span class='app-libelle'>" . $eApp->libelle . "</span><span class='url-libelle'>" . $eUrl->libelle . "</span>";
            }
          }

          // la catégorie est différente on la change
          if ($eApp->category && ($entry['categorie'] !=  preg_replace("%[^a-zA-Z0-9 ]%","",$eApp->category->libelle))) {
              $cat = preg_replace("%[^a-zA-Z0-9 ]%","",$eApp->category->libelle);
          }

          // L'url a une categorie
          if ( $eUrl->category && ( $eUrl->category->libelle  != $eApp->category->libelle ) ) {
            $cat = preg_replace("%[^a-zA-Z0-9 ]%","",$eUrl->category->libelle);
          }

          // La zone si definie
          if ($eApp->zone) $zone =  $eApp->zone;
          if ($eUrl->zone && $eApp->zone != $eUrl->zone) {
              $zone =  $eUrl->zone;
          }

          // Enregistre si app/url dans favoris
          if (isset($_SESSION["INTID"]) && $metrics) {
            $metrics->manageFavoris($eApp->id,$eUrl->id,$_SESSION["INTID"],$profilName,$entry['favoris']=="yes");
          }

          $retour[]=["id"    => $entry['id'],"desc"   => $desc,   "libelle" =>$libelle, "icon" => $icon,
                    "cat"   => $cat,        "favurl" => $favurl, "zone" => $zone, "tags" => $eApp->tags(),
                    "refid" => $eApp->uid  ,"urlid"  => $eUrl->id];
      
        } // Fin $eApp->used
      }

    } // Fin foreach ($apps as $entry)

    if ( $metrics) {
        $metrics->saveFavoris();
    }

    return  $response->withJson($retour);

  }

  public function healthcheckAction(Request $request, Response $response, $args) {
    $data = [];
    $data["elements_version" ]   = VERSION_ELEMENTS ;
    $data["db_vserion"]          = $this->getParamValue(Param::DB_VERSION,"1");

    $user           =  $this->ci["profil"]->getUser();
    $data["user"]   =  $user ;
    $data["md5_session_id"]     =  md5(session_id());

    return  $response->withJson($data);
  }

  public function versionAction(Request $request, Response $response, $args) {
    return  $response->withJson(["version"=>VERSION_ELEMENTS]);
  }

}
