String.prototype.removeAccents = function(){
 return this
         .replace(/[áàãâä]/gi,"a")
         .replace(/[éè¨ê]/gi,"e")
         .replace(/[íìïî]/gi,"i")
         .replace(/[óòöôõ]/gi,"o")
         .replace(/[úùüû]/gi, "u")
         .replace(/[ç]/gi, "c")
         .replace(/[ñ]/gi, "n")
         .replace(/[^a-zA-Z0-9]/g," ");
}

function loadScript(url, symbol, callback) {
    var script, expire;

    // Already there?
    /*if (window[symbol]) {
        setTimeout(function() {
            callback('already loaded');
        }, 0);
    }*/

    // Determine when to give up
    expire = new Date().getTime() + 20000; // 20 seconds

    // Load the script
    script = document.createElement('script');
    script.type = 'text/javascript';
    script.src = url;
    document.body.appendChild(script);

    // Start looking for the symbol to appear, yielding as
    // briefly as the browser will let us.
    setTimeout(lookForSymbol, 0);

    // Our symbol-checking function
    function lookForSymbol() {
        if (window[symbol]) {
            // There's the symbol, we're done
            console.log(window[symbol])
            callback('success');
        }
        else if (new Date().getTime() > expire) {
            // Timed out, tell the callback
            callback('timeout');
        }
        else {
            // Schedule the next check
            setTimeout(lookForSymbol, 100);
        }
    }
}

function safeJSONStringify (input, maxDepth)
{

    var output,
        refs = [],
        refsPaths = [];

    maxDepth = maxDepth || 5;

    function recursion (input, path, depth)
    {
        var output = {},
            pPath,
            refIdx;

        path  = path  || "";
        depth = depth || 0;
        depth++;

        if (maxDepth && depth > maxDepth)
        {
            return "{depth over " + maxDepth + "}";
        }

        for (var p in input)
        {
            pPath = (path ? (path+".") : "") + p;
            if (typeof input[p] === "function")
            {
                output[p] = "{function}";
            }
            else if (typeof input[p] === "object")
            {
                refIdx = refs.indexOf(input[p]);

                if (-1 !== refIdx)
                {
                    output[p] = "{reference to " + refsPaths[refIdx]  + "}";
                }
                else
                {
                    refs.push(input[p]);
                    refsPaths.push(pPath);
                    output[p] = recursion(input[p], pPath, depth);
                }
            }
            else
            {
                output[p] = input[p];
            }
        }

        return output;
    }

    if (typeof input === "object")
    {
        output = recursion(input);
    }
    else
    {
        output = input;
    }

    return JSON.stringify(output);
}

function toHex(x) { return ("0" + parseInt(x).toString(16)).slice(-2); } // another way to convert a decimal to hex


function hslToRgb(h, s, l){
    var r, g, b;

    if(s == 0){
        r = g = b = l; // achromatic
    }else{
        var hue2rgb = function hue2rgb(p, q, t){
            if(t < 0) t += 1;
            if(t > 1) t -= 1;
            if(t < 1/6) return p + (q - p) * 6 * t;
            if(t < 1/2) return q;
            if(t < 2/3) return p + (q - p) * (2/3 - t) * 6;
            return p;
        }

        var q = l < 0.5 ? l * (1 + s) : l + s - l * s;
        var p = 2 * l - q;
        r = hue2rgb(p, q, h + 1/3);
        g = hue2rgb(p, q, h);
        b = hue2rgb(p, q, h - 1/3);
    }

    return "#"+toHex(Math.round(r * 255)) +  toHex(Math.round(g * 255)) +  toHex(Math.round(b * 255));
}

var stringToColour = function(str) {
  var hash = 0;
  for (var i = 0; i < str.length; i++) {
    hash = str.charCodeAt(i) + ((hash << 5) - hash);
  }
  var colour = '#';
  for (var i = 0; i < 3; i++) {
    var value = (hash >> (i * 8)) & 0xFF;
    colour += ('00' + value.toString(16)).substr(-2);
  }
  return colour;
}


function colorful_language(string){
    string= string || ""
    string=string.toUpperCase();

    //return stringToColour(string)

	//alert(string.length);


	if(!string || string.length === 0){
		return "hsl(0, 0%, 0%)";
	}else{
		var sanitized = string.replace(/[^A-Za-z]/, '');
		var letters = sanitized.split('');
    if (letters.length==0) return "hsl(0, 0%, 0%)";

		//Determine the hue
			var hue = Math.floor((letters[0].toLowerCase().charCodeAt()-96)/26*360);
			var ord = '';
			for(var i in letters){
				ord = letters[i].charCodeAt();
				if((ord >= 65 && ord <= 90) || (ord >= 97 && ord <= 122)){
					hue += ord-64;
				}
			}

			hue = hue%360;

		//Determine the saturation
			var vowels = ['A', 'a', 'E', 'e', 'I', 'i', 'O', 'o', 'U', 'u'];
			var count_cons = 0;

			//Count the consonants
			for(i in letters){
				if(vowels.indexOf(letters[i]) == -1){
					count_cons++;
				}
			}

			//Determine what percentage of the string is consonants and weight to 95% being fully saturated.
			var saturation = count_cons/letters.length/0.95*100;
			if(saturation > 100) saturation = 100;

		//Determine the luminosity
			var ascenders = ['t','d','b','l','f','h','k'];
			var descenders = ['q','y','p','g','j'];
			var luminosity = 50;
			var increment = 1/letters.length*50;

			for(i in letters){
				if(ascenders.indexOf(letters[i]) != -1){
					luminosity += increment;
				}else if(descenders.indexOf(letters[i]) != -1){
					luminosity -= increment*2;
				}
			}
			if(luminosity > 100) luminosity = 100;

      return _COLORIZE(hslToRgb(hue/360,saturation/100,luminosity/100),1);
		 //return "hsl("+hue+", "+saturation+"%, "+luminosity+"%)";
	}
}


function _COLORIZE(color,weight) {
  return mix(_COLORS[_PROFIL],color,weight);
}

function _COLOR_PROFIL() {
    return _COLORS[_PROFIL];
}

function HexToRgba(hex,opacity){
    opacity = opacity || 100
    hex = hex || "#000"
    hex = hex.replace('#','');
    r = parseInt(hex.substring(0,2), 16);
    g = parseInt(hex.substring(2,4), 16);
    b = parseInt(hex.substring(4,6), 16);

    result = 'rgba('+r+','+g+','+b+','+opacity/100+')';
    return result;
}


var mix = function(color_1, color_2, weight) {
  function d2h(d) { return d.toString(16); }  // convert a decimal value to hex
  function h2d(h) { return parseInt(h, 16); } // convert a hex value to decimal

  color_1=color_1.replace("#","")
  color_2=color_2.replace("#","")

  //console.log(`mix('${color_1}','${color_2}')`)

  weight = (typeof(weight) !== 'undefined') ? weight : 50; // set the weight to 50%, if that argument is omitted

  var color = "#";

  for(var i = 0; i <= 5; i += 2) { // loop through each of the 3 hex pairs—red, green, and blue
    var v1 = h2d(color_1.substr(i, 2)), // extract the current pairs
        v2 = h2d(color_2.substr(i, 2)),

        // combine the current pairs from each source color, according to the specified weight
        val = d2h(Math.floor(v2 + (v1 - v2) * (weight / 100.0)));

    while(val.length < 2) { val = '0' + val; } // prepend a '0' if val results in a single digit

    color += val; // concatenate val to our new color string
  }
  if (color.indexOf("NaN")!=-1) {
      return "#000";
  }

  return color; // PROFIT!
};


(function($){
  $.fn.overlayMask = function (action) {
    var mask = this.find('.overlay-mask');

    // Create the required mask

    if (!mask.length) {
      this.css({
        position: 'relative'
      });
      mask = $('<div class="overlay-mask"></div>');
      mask.css({
        position: 'absolute',
        width: '100%',
        height: '100%',
        top: '0px',
        left: '0px',
        zIndex: 50
      }).appendTo(this);
    }

    // Act based on params

    if (!action || action === 'show') {
      mask.show();
    } else if (action === 'hide') {
      mask.hide();
    }

    return this;
  };
})(jQuery)


function isFirefox() {
    var browser = getBrowser();
    retun (typeof browser  == "string" && browser.indexOf("firefox") != -1)
}

function isChrome() {
    var browser = getBrowser();
    return (typeof browser  == "string" && browser.indexOf("chrome") != -1)
}

function getBrowser() {
    var ua=navigator.userAgent,tem,M=ua.match(/(opera|chrome|safari|firefox|msie|trident(?=\/))\/?\s*(\d+)/i) || [];
    if(/trident/i.test(M[1])){
        tem=/\brv[ :]+(\d+)/g.exec(ua) || [];
        return {name:'IE',version:(tem[1]||'')};
        }
    if(M[1]==='Chrome'){
        tem=ua.match(/\bOPR|Edge\/(\d+)/)
        if(tem!=null)   {return {name:'Opera', version:tem[1]};}
        }
    M=M[2]? [M[1], M[2]]: [navigator.appName, navigator.appVersion, '-?'];
    if((tem=ua.match(/version\/(\d+)/i))!=null) {M.splice(1,1,tem[1]);}
    return M[0].toLowerCase()+":"+M[1];
 }
