#!/bin/bash

BASE="/var/www/html/edispatcher/ng"
CACHE="${BASE}/cache"
ELEMENTS="$BASE/public/elements"

VERSION=$(cat ${BASE}/apps-inc.php | grep "VERSION_ELEMENTS" | cut -d\" -f4)

CACHE="${CACHE}/${VERSION}"

[ -e $CACHE ] && rm $CACHE;


cat "$ELEMENTS/elements.html" | sed "/link.*html/d" | sed "/link.*css/d" > $CACHE
cat "$ELEMENTS/behaviors/AppsBehavior.html"| sed "s/__VERSION__/$VERSION/" | sed "/link.*html/d" >> $CACHE


find "$ELEMENTS" -name '*.html' | while read D; do
  [ "$D" = "$ELEMENTS/elements.html" ] && continue
  [ "$D" = "$ELEMENTS/behaviors/AppsBehavior.html" ] && continue
  cat $D | sed "s/__VERSION__/$VERSION/" | sed "/link.*html/d" | sed "/link.*css/d"  >>$CACHE
done
