<?php
/**
 * Plugins d'authentification Envole
 * 
 * @licence   GPL 2 (http://www.gnu.org/licenses/gpl.html)
 * @author    Equipe Envole
 * @version   0.0.1
 */


// Chargement du cas eole
require_once('CAS-1.3.1/eoleCAS.php');
require_once('configCAS/cas.inc.php');

/**
 * Cet objet d'authentification CAS est hérité de DokuWiki_Auth_Plugin
 */
class auth_plugin_authcasenvole extends DokuWiki_Auth_Plugin 
{
	/**
 	 * Constructeur
	 */
 	public function __construct() 
	{
		// Appel du constructeur parent
   	 	parent::__construct();
		// Ouverture de session
		@session_start();
		// Gestion des logs	
		if (__CAS_DEBUG) 
		{
    			EolephpCAS::setDebug('/var/log/phpcas/phpcas-dokuwiki.log');
		}
		// Charger le client CAS	
		eolephpCAS::client(__CAS_VERSION, __CAS_SERVER, __CAS_PORT, __CAS_FOLDER, false);
		// no SSL validation for the CAS server
		eolephpCAS::setNoCasServerValidation();
		// Handle single signout requests from CAS server
		eolephpCAS::EoleLogoutRequests(false);
		// Ensembles de fonctions gérées par ce plugin dans dokuwiki
		$this->cando['addUser']    	= false;
		$this->cando['delUser']      	= false;
		$this->cando['modLogin']     	= false;
		$this->cando['modPass']      	= false;
		$this->cando['modName']      	= false;
		$this->cando['modMail']      	= false;
		$this->cando['modGroups']    	= false;
		$this->cando['getUsers']     	= false;
		$this->cando['getUserCount'] 	= false;
		$this->cando['login'] 		= false;
		$this->cando['external'] 	= true;		// L'authentification est externalisé (appel de la méthode trustExternal() de cet objet)
		$this->cando['logoff'] 		= true;		// Gestion de la déconnexion par le bouton
		$this->cando['logout'] 		= true;		//	de déconnexion (appel méthode logOff() de cet objet)
	}

	/**
 	 * Méthode appelée par docuwiki afin de gérer l'authentification
	 */
    	public function trustExternal($user, $pass, $sticky = false) 
	{
		// On traite le cas ou l'on est déconnecté par une autre application, on détruit la session
		if(!eolephpCAS::checkAuthentication()) 
		{
			// Destruction de l'ancienne session
			session_destroy();	
		}
		// Si authentification échouée, on stoppe ici
        if (!eolephpCAS::forceAuthentication()) return (false);
        
		// Récupérer les infos dur l'utilisateur
        $user_details = eolephpCAS::getDetails();
		if(!isset($resultCAS["infos"])&&isset($resultCAS["attributes"])) {
			$resultCAS["infos"]=$resultCAS["attributes"];
        }   

		// Passage des infos à Dokuwiki 
		global $USERINFO;
		$USERINFO['name'] = $user_details['infos']['displayName'][0];
		$USERINFO['mail'] = $user_details['infos']['mail'][0];
		$USERINFO['grps'] = $user_details['utilisateur']['user_groups'];
        $_SERVER['REMOTE_USER'] = eolephpCAS::getUser();			// Important car c'est comme ça que Dokuwiki reçoit le nom d'utilisateur
		$_SESSION[DOKU_COOKIE]['auth']['user'] = eolephpCAS::getUser();
		$_SESSION[DOKU_COOKIE]['auth']['pass'] = "";
		$_SESSION[DOKU_COOKIE]['auth']['info'] = $USERINFO;
		// Retourne true si l'authentification s'est bien passée
		return (true);
	}

	/**
 	 * Méthode appelé par Dokuwiki lorsque l'on clique sur le bouton déconnexion dans le wiki
	 */
	public function logOff() 
	{
		// Détruire la session
		session_destroy();
		//procédure de déconnexion du serveur CAS en revoyant à la mire SSO
   		global $QUERY;
		$url = (isset($_SERVER['HTTPS']) && !empty($_SERVER['HTTPS'])) ? "https://" : "http://";
		if(empty($_SERVER['SERVER_NAME'])) $url .= $_SERVER['HTTP_HOST']; else $url .= $_SERVER['SERVER_NAME'];
        $url .= "/dokuwiki/doku.php?id=" . $QUERY; 
        eolephpCAS::logout(array("service"=>$url));
	}
    
}
?>
