// Generated by CoffeeScript 1.4.0
var OptionParser, argv, coffeecup, compile, fs, handle_error, log, options, path, switches, usage, watch, write;

coffeecup = require('./coffeecup');

fs = require('fs');

path = require('path');

log = console.log;

OptionParser = require('coffee-script/lib/coffee-script/optparse').OptionParser;

argv = process.argv.slice(2);

options = null;

handle_error = function(err) {
  if (err) {
    return console.log(err.stack);
  }
};

watch = function(files, fn) {
  var file, _i, _j, _len, _len1, _results, _results1;
  if (false) {
    _results = [];
    for (_i = 0, _len = files.length; _i < _len; _i++) {
      file = files[_i];
      _results.push((function() {
        var currentFile;
        currentFile = file;
        return fs.watch(currentFile, function(event) {
          if (event === 'change') {
            return fn(currentFile);
          }
        });
      })());
    }
    return _results;
  } else {
    _results1 = [];
    for (_j = 0, _len1 = files.length; _j < _len1; _j++) {
      file = files[_j];
      _results1.push((function() {
        var currentFile;
        currentFile = file;
        return fs.watchFile(currentFile, {
          persistent: true,
          interval: 500
        }, function(curr, prev) {
          if (!(curr.size === prev.size && curr.mtime.getTime() === prev.mtime.getTime())) {
            return fn(currentFile);
          }
        });
      })());
    }
    return _results1;
  }
};

compile = function(input_path, output_directory, js, namespace) {
  var appendTemplate, body, i;
  if (namespace == null) {
    namespace = 'templates';
  }
  if (Array.isArray(input_path)) {
    i = 0;
    body = '';
    appendTemplate = function() {
      var output;
      if (i >= input_path.length || !options["package"]) {
        output = "(function(){ \n  this." + namespace + " || (this." + namespace + " = {});\n  " + body + "\n}).call(this);";
        return write(input_path[0], namespace, output, output_directory, '.js');
      } else {
        return fs.readFile(input_path[i], 'utf-8', function(err, contents) {
          var func, name;
          handle_error(err);
          name = path.basename(input_path[i], path.extname(input_path[i]));
          func = coffeecup.compile(contents, options);
          body += "this." + namespace + "[" + (JSON.stringify(name)) + "] = " + func + ";\n";
          i += 1;
          return appendTemplate();
        });
      }
    };
    return appendTemplate();
  }
  return fs.readFile(input_path, 'utf-8', function(err, contents) {
    var ext, func, name, output;
    handle_error(err);
    name = path.basename(input_path, path.extname(input_path));
    if (!js) {
      output = coffeecup.render(contents, options);
      ext = '.html';
    } else {
      func = coffeecup.compile(contents, options);
      output = "(function(){ \n  this." + namespace + " || (this." + namespace + " = {});\n  this." + namespace + "[" + (JSON.stringify(name)) + "] = " + func + ";\n}).call(this);";
      ext = '.js';
    }
    return write(input_path, name, output, output_directory, ext);
  });
};

write = function(input_path, name, contents, output_directory, ext) {
  var dir, exists, filename;
  filename = name + ext;
  dir = output_directory || path.dirname(input_path);
  exists = fs.exists || path.exists;
  return exists(dir, function(exists) {
    var output_path;
    if (!exists) {
      fs.mkdirSync(dir);
    }
    output_path = path.join(dir, filename);
    if (contents.length <= 0) {
      contents = ' ';
    }
    return fs.writeFile(output_path, contents, function(err) {
      handle_error(err);
      if (options.print) {
        log(contents);
      }
      if (options.watch) {
        return log("Compiled " + input_path);
      }
    });
  });
};

usage = 'Usage:\n  coffeecup [options] path/to/template.coffee';

switches = [['-j', '--js', 'compile template to js function (template + embedded renderer)'], ['-b', '--bare', 'use with -j to compile template to js (template only)'], ['-c', '--core', 'use with -j to compile renderer to js (renderer only)'], ['-n', '--namespace [name]', 'global object holding the templates (default: "templates")'], ['-w', '--watch', 'watch templates for changes, and recompile'], ['-o', '--output [dir]', 'set the directory for compiled html'], ['-p', '--print', 'print the compiled html to stdout'], ['-f', '--format', 'apply line breaks and indentation to html output'], ['-u', '--utils', 'add helper locals (currently only "render")'], ['-z', '--optimize', 'optimize resulting JS'], ['-v', '--version', 'display coffeecup version'], ['-h', '--help', 'display this help message'], ['-k', '--package', 'use with -j to include all templates in a single [namespace].js']];

this.run = function() {
  var args, file, files, parser, _i, _len, _ref, _results;
  parser = new OptionParser(switches, usage);
  options = parser.parse(argv);
  args = options["arguments"];
  delete options["arguments"];
  if (options.help || argv.length === 0) {
    log(parser.help());
  }
  if (options.version) {
    log(coffeecup.version);
  }
  if (options.utils) {
    if ((_ref = options.locals) == null) {
      options.locals = {};
    }
    options.locals.render = function(file) {
      var contents;
      contents = fs.readFileSync(file, 'utf-8');
      return coffeecup.render(contents, options);
    };
  }
  if (args.length > 0) {
    files = args.slice(0);
    if (options.watch) {
      watch(files, function(file) {
        if (options["package"] && options.js) {
          return compile(files, options.output, options.js, options.namespace);
        } else {
          return compile(file, options.output, options.js, options.namespace);
        }
      });
    }
    if (options.js && options["package"]) {
      return compile(files, options.output, options.js, options.namespace);
    } else {
      _results = [];
      for (_i = 0, _len = files.length; _i < _len; _i++) {
        file = files[_i];
        _results.push(compile(file, options.output, options.js, options.namespace));
      }
      return _results;
    }
  }
};
