'use strict'

var HAS_OWN       = Object.prototype.hasOwnProperty
var STR_OBJECT    = 'object'

/**
 * Copies all properties from source to destination
 *
 *      copy({name: 'jon',age:5}, this);
 *      // => this will have the 'name' and 'age' properties set to 'jon' and 5 respectively
 *
 * @param {Object} source
 * @param {Object} destination
 *
 * @return {Object} destination
 */
module.exports = function(source, destination){

    destination = destination || {}

    if (source != null && typeof source === STR_OBJECT ){

        for (var i in source) if ( HAS_OWN.call(source, i) ) {
            destination[i] = source[i]
        }

    }

    return destination
}