// Generated by LiveScript 1.5.0
var lexer, parser, ast, SourceNode, path, toString$ = {}.toString;
lexer = require('./lexer');
parser = require('./parser').parser;
ast = require('./ast');
SourceNode = require('source-map').SourceNode;
path = require('path');
parser.yy = ast;
parser.lexer = {
  lex: function(){
    var ref$, tag, first_line, first_column, last_line, last_column;
    ref$ = this.tokens[++this.pos] || [''], tag = ref$[0], this.yytext = ref$[1], first_line = ref$[2], first_column = ref$[3];
    ref$ = this.tokens[this.pos + 1] || [''], last_line = ref$[2], last_column = ref$[3];
    this.yylineno = first_line;
    this.yylloc = {
      first_line: first_line,
      first_column: first_column,
      last_line: last_line,
      last_column: last_column
    };
    return tag;
  },
  setInput: function(it){
    this.pos = -1;
    return this.tokens = it;
  },
  upcomingInput: function(){
    return '';
  }
};
exports.VERSION = '1.5.0';
exports.compile = function(code, options){
  var result, ast, output, filename, outputFilename, ref$, mapPath, e, that;
  options == null && (options = {});
  options.header == null && (options.header = true);
  try {
    if (options.json) {
      result = Function(exports.compile(code, {
        bare: true,
        run: true,
        print: true
      }))();
      return JSON.stringify(result, null, 2) + "\n";
    } else {
      ast = parser.parse(lexer.lex(code));
      if (options.run && options.print) {
        ast.makeReturn();
      }
      output = ast.compileRoot(options);
      if (options.header) {
        output = new SourceNode(null, null, null, ["// Generated by LiveScript " + exports.VERSION + "\n", output]);
      }
      if (options.map && options.map !== 'none') {
        filename = options.filename, outputFilename = options.outputFilename;
        if (!filename) {
          filename = "unnamed-" + Math.floor(Math.random() * 4294967296).toString(16) + ".ls";
        }
        output.setFile(filename);
        result = output.toStringWithSourceMap();
        if (options.map === 'embedded') {
          result.map.setSourceContent(filename, code);
        }
        if ((ref$ = options.map) === 'linked' || ref$ === 'debug') {
          mapPath = outputFilename + ".map";
          result.code += "\n//# sourceMappingURL=" + mapPath + "\n";
        } else {
          result.code += "\n//# sourceMappingURL=data:application/json;base64," + new Buffer(result.map.toString()).toString('base64') + "\n";
        }
        return result;
      } else {
        return output.toString();
      }
    }
  } catch (e$) {
    e = e$;
    if (that = options.filename) {
      e.message += "\nat " + that;
    }
    throw e;
  }
};
exports.ast = function(it){
  return parser.parse(typeof it === 'string' ? lexer.lex(it) : it);
};
exports.tokens = lexer.lex;
exports.lex = function(it){
  return lexer.lex(it, {
    raw: true
  });
};
exports.run = function(code, options){
  var output, ref$;
  output = exports.compile(code, (ref$ = {}, import$(ref$, options), ref$.bare = true, ref$));
  return Function(toString$.call(output).slice(8, -1) === 'String'
    ? output
    : output.code)();
};
exports.tokens.rewrite = lexer.rewrite;
importAll$(exports.ast, parser.yy);
if (require.extensions) {
  require('./node')(exports);
} else {
  exports.require = require;
}
function import$(obj, src){
  var own = {}.hasOwnProperty;
  for (var key in src) if (own.call(src, key)) obj[key] = src[key];
  return obj;
}
function importAll$(obj, src){
  for (var key in src) obj[key] = src[key];
  return obj;
}