<?php
//client CAS utilis� par index.php pour la connexion et logout.php pour la d�connexion
$envole_cas = null;

//pr�sent dans l'include_path du php.ini (/usr/share/php)
include_once("CAS-1.3.1/eoleCAS.php");
include_once("configCAS/cas.inc.php");

//instanciation du client CAS
function envole_cas_instance()  {
    global $envole_cas;
    if(empty($envole_cas)) {
        if (__CAS_DEBUG){
             EolephpCAS::setDebug('/var/log/phpcas/phpcas-grr.log');
        }

        $envole_cas = new eolephpCAS();
        //dernier argument � "true" provoque une probl�me de session dans Grr qui utilise sa propre session au nom de "GRR"
        $envole_cas->client(__CAS_VERSION,__CAS_SERVER,__CAS_PORT,__CAS_FOLDER,false);
        $envole_cas->setNoClearTicketsFromUrl();  // Maj pour phpCAS 1.3.1
        // Maj pour phpCAS 1.3.1
        if (__CAS_VALIDER_CA) {
            $envole_cas->setCasServerCACert(__CAS_CA_LOCATION); // v�rification par rapport � la CA
        } else {
            if (method_exists($envole_cas, 'setNoCasServerValidation')){
                $envole_cas->setNoCasServerValidation();
            }
        }
        
        if (__CAS_LOGOUT){
			if(method_exists($envole_cas,'EoleLogoutRequests')){
				$envole_cas->EoleLogoutRequests(false);
			}
		 }
	}
}

//v�rifier l'authentification
function envole_cas_check()
    {
    global $envole_cas;

    //instanciation
    envole_cas_instance();

    return $envole_cas->isAuthenticated();
    }

//est-ce bien $login qui est authentifi� ?
function envole_cas_user($login)
    {
    global $envole_cas;

    return ($login==$envole_cas->getUser());
    }

function envole_cas_loginsonde() {
    global $envole_cas;
    return $envole_cas->getUser();
}

function envole_cas_profilsonde() {
    global $envole_cas;
    $profilsonde="visiteur";
    if($envole_cas->checkAuthentication()) {
        $details=$envole_cas->getDetails();
        if (isset($details['attributes']['ENTPersonProfils'][0])) $profilsonde=$details['attributes']['ENTPersonProfils'][0];
        if (isset($details['utilisateur']['ENTPersonProfils'][0])) $profilsonde=$details['utilisateur']['ENTPersonProfils'][0];    
    }
    return $profilsonde;
}


//authentification et récupération des informations sur l'utilisateur
function envole_cas_auth()
    {
    global $envole_cas;

    //instanciation
    envole_cas_instance();

    //forcer � redemander les infos auprès du serveur CAS (au lieu de les lire en session alors que ce serait les infos d'une autre appli...)
    if(isset($_SESSION["phpCAS"])) unset($_SESSION["phpCAS"]);

    //authentification
    $envole_cas->forceAuthentication();

    //récupération des informations de l'utilisateur
    $details=$envole_cas->getDetails();
    if(!isset($details['utilisateur'])&&isset($details['attributes'])) $details['utilisateur']=$details['attributes'];

    return $envole_cas->getDetails();
    }

//déconnexion
function envole_cas_logout()
    {
    global $envole_cas;

    //instanciation
    envole_cas_instance();

    //proc�dure de d�connexion du serveur CAS
    $domaine = (isset($_SERVER['HTTPS']) && !empty($_SERVER['HTTPS'])) ? "https://" : "http://";
    if(empty($_SERVER['SERVER_NAME'])) $domaine .= $_SERVER['HTTP_HOST'];
    else $domaine .= $_SERVER['SERVER_NAME'];
    $url = $domaine."/grr/logout.php?auto=0&envole_logout"; //variable "envole_logout" pour identifier la redirection
    $service = $domaine."/grr/index.php";
    $envole_cas->logout(array("service"=>$service));
    }
?>
