<?php
namespace App\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use FOS\CKEditorBundle\Form\Type\CKEditorType;
use Tetranz\Select2EntityBundle\Form\Type\Select2EntityType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;

class WordcloudType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        if($options["mode"]!="view") {
            $builder
            ->add('submit', SubmitType::class, [
                    'label'                 => 'Valider',
                    'attr'                  => ['class' => 'btn btn-success']
            ]);

            $builder
            ->add('title', TextType::class, [
                    'label'                 => 'Titre',
                    'attr'                  => ['class' => 'form-control']
            ]);

            $builder
            ->add('groups', Select2EntityType::class, [
                    'label'                 => 'Les membres de ces groupes',
                    'class'                 => 'App:Group',
                    'multiple'              => true,
                    'remote_route'          => 'app_group_select',
                    'primary_key'           => 'id',
                    'text_property'         => 'name',
                    'minimum_input_length'  => 0,
                    'page_limit'            => 100,
                    'allow_clear'           => true,
                    'delay'                 => 250,
                    'cache'                 => false,
                    'cache_timeout'         => 60000,
                    'language'              => 'fr',
                    'placeholder'           => 'Sélectionner des groupes',                        
            ]);            

            $builder
            ->add('groupwriters', Select2EntityType::class, [
                    'label'                 => 'Les membres de ces groupes',
                    'class'                 => 'App:Group',
                    'multiple'              => true,
                    'remote_route'          => 'app_group_select',
                    'primary_key'           => 'id',
                    'text_property'         => 'name',
                    'minimum_input_length'  => 0,
                    'page_limit'            => 100,
                    'allow_clear'           => true,
                    'delay'                 => 250,
                    'cache'                 => false,
                    'cache_timeout'         => 60000,
                    'language'              => 'fr',
                    'placeholder'           => 'Sélectionner des groupes',                        
            ]); 

            $builder
            ->add('groupreaders', Select2EntityType::class, [
                    'label'                 => 'Les membres de ces groupess',
                    'class'                 => 'App:Group',
                    'multiple'              => true,
                    'remote_route'          => 'app_group_select',
                    'primary_key'           => 'id',
                    'text_property'         => 'name',
                    'minimum_input_length'  => 0,
                    'page_limit'            => 100,
                    'allow_clear'           => true,
                    'delay'                 => 250,
                    'cache'                 => false,
                    'cache_timeout'         => 60000,
                    'language'              => 'fr',
                    'placeholder'           => 'Sélectionner des groupes',                        
            ]);  

            $builder
            ->add('users', Select2EntityType::class, [
                    'label'                 => 'Ces utilisateurs',
                    'class'                 => 'App:User',
                    'multiple'              => true,
                    'remote_route'          => 'app_user_select',
                    'primary_key'           => 'id',
                    'text_property'         => 'displayname',
                    'minimum_input_length'  => 0,
                    'page_limit'            => 100,
                    'allow_clear'           => true,
                    'delay'                 => 250,
                    'cache'                 => false,
                    'cache_timeout'         => 60000,
                    'language'              => 'fr',
                    'placeholder'           => 'Sélectionner des utilisateurs',                        
            ]);            

            $builder
            ->add('userwriters', Select2EntityType::class, [
                    'label'                 => 'Ces utilisateurs',
                    'class'                 => 'App:User',
                    'multiple'              => true,
                    'remote_route'          => 'app_user_select',
                    'primary_key'           => 'id',
                    'text_property'         => 'displayname',
                    'minimum_input_length'  => 0,
                    'page_limit'            => 100,
                    'allow_clear'           => true,
                    'delay'                 => 250,
                    'cache'                 => false,
                    'cache_timeout'         => 60000,
                    'language'              => 'fr',
                    'placeholder'           => 'Sélectionner des utilisateurs',                        
            ]); 

            $builder
            ->add('userreaders', Select2EntityType::class, [
                    'label'                 => 'Ces utilisateurs',
                    'class'                 => 'App:User',
                    'multiple'              => true,
                    'remote_route'          => 'app_user_select',
                    'primary_key'           => 'id',
                    'text_property'         => 'displayname',
                    'minimum_input_length'  => 0,
                    'page_limit'            => 100,
                    'allow_clear'           => true,
                    'delay'                 => 250,
                    'cache'                 => false,
                    'cache_timeout'         => 60000,
                    'language'              => 'fr',
                    'placeholder'           => 'Sélectionner des utilisateurs',                        
            ]); 

            if($options["access"]=="admin") {
                $builder
                ->add('user', Select2EntityType::class, [
                        'label'                 => 'Propriétaire',
                        'class'                 => 'App:User',
                        'multiple'              => false,
                        'required'              => true,
                        'remote_route'          => 'app_user_select',
                        'primary_key'           => 'id',
                        'text_property'         => 'displayname',
                        'minimum_input_length'  => 0,
                        'page_limit'            => 100,
                        'allow_clear'           => true,
                        'delay'                 => 250,
                        'cache'                 => false,
                        'cache_timeout'         => 60000,
                        'language'              => 'fr',
                        'placeholder'           => 'Sélectionner un utilisateurs',                        
                ]);                 
            }

            $builder
            ->add('backgroundcolor', TextType::class, [
                    'label'                 => 'Couleur de fond',
                    'required'              => false,
                    'attr'                  => ['class' => 'pick-a-color form-control']
            ]);
            
            $builder->add('backgroundimage',HiddenType::class);  

            $choices=["cover" => "cover","repeat" => "repeat"];
            $builder
            ->add('backgroundmode', ChoiceType::class,[
                'label'                     => "Mode d'affichage de l'image de fond",
                'attr'                      => ["class" => "form-control"],
                'required'                  => true,
                'choices'                   => $choices
            ]);                        
        }
        else {
            $builder
            ->add('word', TextType::class, [
                    'label'                 => 'Mot',
                    'attr'                  => ['class' => 'form-control'],
                    'mapped'                => false,
                    
            ]);

            $builder
            ->add('color', TextType::class, [
                    'label'                 => 'Couleur du Mot',
                    'required'              => false,
                    'attr'                  => ['class' => 'pick-a-color form-control'],
                    'mapped'                => false,
                    'label_attr' => [ 'id' => 'color-label']
            ]);          
        }        
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'App\Entity\Wordcloud',
            'mode' => "string",
            'access' => "string",
            'id' => "string"
        ));
    }
}
