<?php

namespace App\Service;

use App\Entity\User;

class wordcloudService
{
    protected function getWordCloudPermission($entity, User $currentUser): string {
        $perm="none";

        if($entity->getUser()==$currentUser) $perm="write";
        if($currentUser->hasRole("ROLE_ADMIN")) $perm="write";
        if($currentUser->hasRole("ROLE_MODO")) $perm="write";

        // Récupération des groupes de l'utilisateur
        $groups=$currentUser->getGroups();

        // Ses groupes ont-ils la permission 
        foreach($groups as $group) {
            if($entity->getGroups()->contains($group)) $perm="write";
        }

        // Son compte a-til la permission
        if($entity->getUsers()->contains($currentUser)) $perm="write";

        // Si pas de permission on regarde s'il a les permissions en écriture limitée
        if(!$perm) {
            // Ses groupes ont-ils la permission 
            foreach($groups as $group) {
                if($entity->getGroupwriters()->contains($group)) $perm="writeuser";
            }

            // Son compte a-til la permission
            if($entity->getUserwriters()->contains($currentUser)) $perm="writeuser";
        }

        // Si pas de permission on regarde s'il a les permissions en lecture
        if(!$perm) {
            // Ses groupes ont-ils la permission 
            foreach($groups as $group) {
                if($entity->getGroupreaders()->contains($group)) $perm="read";
            }

            // Son compte a-til la permission
            if($entity->getUserreaders()->contains($currentUser)) $perm="read";
        }

        // Erreur si non permis
        if(!$perm) $perm="unauthorized";

        return $perm;
    }


}
