<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Document
 *
 * @ORM\Table(name="document")
 * @ORM\Entity(repositoryClass="App\Repository\DocumentRepository")
 */
class Document
{
    /**
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\Column(name="name", type="string")
     *
     */
    private $name;

    /**
     * @ORM\Column(name="filename", type="string")
     *
     */
    private $filename;

    /**
     * @ORM\Column(type="text", nullable=true)
     */
    private $description;

    /**
     * @ORM\Column(name="entity", type="string")
     */
    private $entity;

    /**
     * @ORM\Column(type="integer")
     */
    private $roworder;

    /**
     * @ORM\Column(name="extention", type="string")
     */
    private $extention;

    /**
     * @ORM\Column(name="minetype", type="string")
     */
    private $minetype;

    /**
     * @ORM\Column(name="havethumb", type="boolean")
     */
    private $havethumb;

    /**
     * @ORM\ManyToOne(targetEntity="Scrumwidget", inversedBy="scrumwidgetdocuments")
     * @ORM\JoinColumn(nullable=true)
     */
    private $scrumwidget;

    /**
     * @ORM\ManyToOne(targetEntity="Whiteboardwidget", inversedBy="whiteboardwidgetdocuments")
     * @ORM\JoinColumn(nullable=true)
     */
    private $whiteboardwidget;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function setId(int $id): self
    {
        $this->id = $id;

        return $this;
    }
    
    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getFilename(): ?string
    {
        return $this->filename;
    }

    public function setFilename(string $filename): self
    {
        $this->filename = $filename;

        return $this;
    }

    public function getDescription(): ?string
    {
        return $this->description;
    }

    public function setDescription(?string $description): self
    {
        $this->description = $description;

        return $this;
    }

    public function getEntity(): ?string
    {
        return $this->entity;
    }

    public function setEntity(string $entity): self
    {
        $this->entity = $entity;

        return $this;
    }

    public function getRoworder(): ?int
    {
        return $this->roworder;
    }

    public function setRoworder(int $roworder): self
    {
        $this->roworder = $roworder;

        return $this;
    }

    public function getExtention(): ?string
    {
        return $this->extention;
    }

    public function setExtention(string $extention): self
    {
        $this->extention = $extention;

        return $this;
    }

    public function getMinetype(): ?string
    {
        return $this->minetype;
    }

    public function setMinetype(string $minetype): self
    {
        $this->minetype = $minetype;

        return $this;
    }

    public function getHavethumb(): ?bool
    {
        return $this->havethumb;
    }

    public function setHavethumb(bool $havethumb): self
    {
        $this->havethumb = $havethumb;

        return $this;
    }

    public function getScrumwidget(): ?Scrumwidget
    {
        return $this->scrumwidget;
    }

    public function setScrumwidget(?Scrumwidget $scrumwidget): self
    {
        $this->scrumwidget = $scrumwidget;

        return $this;
    }

    public function getWhiteboardwidget(): ?Whiteboardwidget
    {
        return $this->whiteboardwidget;
    }

    public function setWhiteboardwidget(?Whiteboardwidget $whiteboardwidget): self
    {
        $this->whiteboardwidget = $whiteboardwidget;

        return $this;
    }
}