<?php

namespace App\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\OptionsResolver\OptionsResolver;

use Doctrine\ORM\EntityRepository;

class BlogShareType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $user=$options['user'];

        $builder
            ->add('submit', SubmitType::class, [
                "label"         => ($options["mode"]=="delete"?"Confirmer la Suppression":"Valider"),
                "attr"          => ($options["mode"]=="delete"?array("class" => "btn btn-danger"):array("class" => "btn btn-success"))
            ])

            ->add('groups', EntityType::class, [
                'label'         => 'Partager avec les Groupes',
                'class'         => 'App\Entity\Group',
                'query_builder' => function(EntityRepository $er) use ($user) {
                    return $er->createQueryBuilder('g')
                              ->select('g')
                              ->From('App\Entity\UserGroup','ug')
                              ->where('g.fgcanshare=:fgcanshare')
                              ->andWhere('g=ug.group')
                              ->andWhere('ug.user=:user')
                              ->andWhere('ug.rolegroup>=:role')
                              ->setParameter('fgcanshare',true)
                              ->setParameter('role',90)
                              ->setParameter('user',$user);
                },
                'choice_label'  => 'label',
                'multiple'      => true,
                'expanded'      => true
            ]);
            
            ;   

    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => 'App\Entity\Blog',
            'mode' => 'string',
            'access' => 'string',
            'user' => 'App\Entity\User'
        ]);
    }
}
