# 
# NE PAS EDITER CE FICHIER
#
# Utiliser <appli>.mk à inclure à la fin de Makefile

# Le variables suivantes sont a votre disposition : 
#
# SRC_APPS        : Répertoire des sources de l'application
# SRC_APPS_PLUGIN : Répertoires des plugins pour l'application
# SRC_APPS_LANG   : Répértoires des traductions
#
#########################
# Variables definitions #
#########################

INSTALL                 := install
INSTALL_DATA            := install -m 644
INSTALL_PROGRAM         := install -m 755
INSTALL_DIRECTORY       := install -m 755 -d
INSTALL_RECURSIVE       := cp -dr --no-preserve=ownership

define fc_install_file
	if [ -d $2 ]; then					\
		for file in `ls -1 $2/`; do			\
		   $1 $2/$$file $3 || true;			\
	    done;						\
	fi
endef

##########################
# Application web envole #
##########################
SRC_APPS		:= src/$(SOURCE)
SRC_APPS_PLUGIN		:= src/plugins
SRC_APPS_LANG		:= src/lang

APPS_DEST		:= $(DESTDIR)/var/www/html/$(SOURCE)
LANG_DEST		:= $(APPS_DEST)/lang
PLUGIN_DEST		:= $(APPS_DEST)/plugin

ifeq (, $(strip $(wildcard $(SRC_APPS))))
$(error $$(PKGAPPS) is enable but $$(SRC_APPS)='$(SRC_APPS)' does not exist)
endif

################
# Common rules #
################
ifneq (, $(filter oui web, $(PKGAPPS)))

install-apps-dirs::
	test ! -d $(SRC_APPS)           || $(INSTALL_DIRECTORY) $(APPS_DEST)
	test ! -d $(SRC_APPS_LANG)      || $(INSTALL_DIRECTORY) $(LANG_DEST)
	test ! -d $(SRC_APPS_PLUGIN)    || $(INSTALL_DIRECTORY) $(PLUGIN_DEST)

install-apps:: install-apps-dirs
	# Installation de l'application
	$(call fc_install_file,$(INSTALL_RECURSIVE),$(SRC_APPS),$(APPS_DEST))

	# Installation des répertoires de plugins
	$(call fc_install_file,$(INSTALL_RECURSIVE),$(SRC_APPS_PLUGIN),$(PLUGIN_DEST))

	# Installation des répertoires de traductions (lang)
	$(call fc_install_file,$(INSTALL_RECURSIVE),$(SRC_APPS_LANG),$(LANG_DEST))

## Add install-apps
install:: install-apps
endif

.PHONY: install-apps install-apps-dirs
