Ext.namespace("ARV");

ARV.viewcred = (function() {

    var selid_node = null;
    var vcstore = new Ext.data.Store({
        reader: new Ext.data.JsonReader({
            root :'data',
            successProperty: 'success',
        },[
            {name: 'node'},
            {name: 'id'},
            {name: 'id_zephir'},
            {name: 'eole_version'},
            {name: 'state'},
            {name: 'uai'},
            {name: 'mimetype'},
        ]),
        url: 'arv/get_nodes_state',
    });
    vcstore.on('load', function() {
        if (selid_node != null) {
            index = this_store.findExact('id', selid_node);
            if (index != -1) {
                vcgrid.getSelectionModel().selectRow(index)
            }
        };
        selid_node = null
    }, this);
    var columns = [{id: 'uai', header: Ext.i18n.uai, sortable: true, dataIndex: 'uai', width: 30},
        {id: 'node', header: Ext.i18n.node, sortable: true, dataIndex: 'node', width: 100},
        {header: 'id_zephir', header: Ext.i18n.id_zephir, sortable: true, dataIndex: 'id_zephir'},
        {header: 'eole_version', header: Ext.i18n.eole_version, sortable: true, dataIndex: 'eole_version', width: 30},
        {header: 'mimetype', header: Ext.i18n.tmpl_node_mimetype, sortable: true, dataIndex: 'mimetype', width: 30},
        {header: 'state', header: Ext.i18n.certif_state, sortable: true, dataIndex: 'state', width: 150},
        {header: 'id', sortable: true, dataIndex: 'id', hidden: true},
    ];
    var vcgrid = new ARV.GridPanel({
        layout: 'fit',
        region: 'center',
        store: vcstore,
        columns: columns,
        deleteUrl: 'arv/del_node',
        btnAddEvent: 'nodeadd',
        btnDelEvent: 'nodedel',
        btnModEvent: 'nodemod',
        plugins:  new Ext.ux.grid.GridFilters({
            // encode and local configuration options defined previously for easier reuse
            // encode: encode, // json encode the filter query
            local: true,   // defaults to false (remote filtering)
            filters: [{
                type: 'string',
                dataIndex: 'uai',
                },
                {
                 type: 'string',
                 dataIndex: 'node',
                },
                {
                 type: 'string',
                 dataIndex: 'eole_version',
                },
                {
                 type: 'string',
                 dataIndex: 'mimetype',
                }
            ]
        }),
    });
    bbar = vcgrid.getBottomToolbar();
    bbar.add({
        //modify credential
        text: Ext.i18n.credential,
        iconCls: 'arv-modify',
        handler: function(btn, ev) {
            ARV.observable.fireEvent('modifycred');
        },
        scope: this
    });
    bbar.add({
        //modify external IP
        text: Ext.i18n.external_ip,
        iconCls: 'arv-modify',
        handler: function(btn, ev) {
            ARV.observable.fireEvent('modifyextrip');
        },
        scope: this
    });
    bbar.add({
        //Send VPN archive to Zéphir
        text: Ext.i18n.send_db,
        iconCls: 'arv-modify',
        id: 'send_db',
        handler: function(btn, ev) {
            ARV.observable.fireEvent('send_db');
        },
        scope: this
    });
    bbar.add({
        //Synchro node (uai, name, id, eole version) with Zéphir
        text: Ext.i18n.sync_zephir,
        iconCls: 'arv-modify',
        id: 'sync_zephir',
        handler: function(btn, ev) {
            ARV.observable.fireEvent('sync_zephir');
        },
        scope: this
    });
    vcgrid.getSelectionModel().on('rowselect', function() {ARV.observable.fireEvent('treenodecertchanged')}, this);
    return {
        get: function() {
            return vcgrid;
        },
        load: function() {
            selid_node = ARV.viewcred.getSelectedId();
            vcstore.removeAll();
            vcstore.load();
            if (Ext.util.Cookies.get('usezephir') == 'false') {
                Ext.getCmp('send_db').disable()
                Ext.getCmp('sync_zephir').disable()
            } else {
                Ext.getCmp('send_db').enable()
                Ext.getCmp('sync_zephir').enable()
            }
            // If not usezephir hide id_zephir and eole_version columns
            col_mod = vcgrid.getColumnModel();
            if (Ext.util.Cookies.get('usezephir') == 'false') {
                col_mod.setHidden(2, true);
                col_mod.setHidden(3, true);
            } else {
                col_mod.setHidden(2, false);
                col_mod.setHidden(3, false);
                col_mod.setColumnWidth(2, 100);
                col_mod.setColumnWidth(3, 100);
            }
        },
        getSelectedId: function() {
            if (vcgrid.getSelectionModel().hasSelection()) {
                return vcgrid.getSelectionModel().getSelected().get('id');
            } else {
                return null
            }
        },
        getSelectedName: function() {
            if (vcgrid.getSelectionModel().hasSelection()) {
                return vcgrid.getSelectionModel().getSelected().get('node');
            } else {
                return null
            }
        },
        getSelectedUAI: function() {
            if (vcgrid.getSelectionModel().hasSelection()) {
                return vcgrid.getSelectionModel().getSelected().get('uai');
            } else {
                return null
            }
        },
        getSelectedMimetype: function() {
            if (vcgrid.getSelectionModel().hasSelection()) {
                return vcgrid.getSelectionModel().getSelected().get('mimetype');
            } else {
                return null
            }
        },
    }
})();
