from sqlalchemy import func
from arv.db.strongswandb import *
#from arv.lib.util import binary_encrypt
from arv.config import (ChildConfig_lifetime, ChildConfig_rekeytime, ChildConfig_jitter, ChildConfig_hostaccess, ChildConfig_mode,
                        ChildConfig_close_action, ChildConfig_ipcomp, IkeConfig_certreq, IkeConfig_force_encap, PeerConfig_ike_version,
                        PeerConfig_cert_policy, PeerConfig_uniqueid, PeerConfig_auth_method, PeerConfig_eap_type, PeerConfig_eap_vendor,
                        PeerConfig_keyingtries, PeerConfig_rekeytime, PeerConfig_reauthtime, PeerConfig_jitter, PeerConfig_overtime,
                        PeerConfig_mobike, PeerConfig_dpd_delay, PeerConfig_mediation, PeerConfig_mediated_by, PeerConfig_peer_id,
                        CertificateDistributionPoints_uri)

global session

def sw_initialize_database(name):
    global session
    session = initialise(name)

def sw_purge_database(name):
    global session
    session = purge_database(name)

def sw_create_identity(identityid, data, nodetype=9):
    """
    nodetype:
    0   ID_ANY      matches any id      right=%any
    1   ID_IPV4_ADDR    IPv4 address    right=192.168.0.1
    2   ID_FQDN     fully qualified domain name     right=@moon.strongswan.org
    3   ID_RFC822_ADDR  RFC822 email address    right=carol@strongswan.org
    5   ID_IPV6_ADDR    IPv6 address    right=fec0::1
    9   ID_DER_ASN1_DN  ASN.1 distinguished name    right=C=CH, O=Linux strongSwan, CN=moon.strongswan.org
    11  ID_KEY_ID   opaque octet string     right=@#e5e410876c2ac4bead854942a6de7658303a9fc1
    """
    identity = Identity(id=identityid, type=nodetype, data=data)
    session.add(identity)
#    commit_database(session)

def sw_create_proposals(propid, proposal):
    prop = Proposals(id=propid, proposal=proposal)
    session.add(prop)
#    commit_database(session)

def sw_create_ike_configs(ikecfgid, local, remote):
    ike_cfg = IkeConfigs(id=ikecfgid, local=local, remote=remote, certreq=IkeConfig_certreq, force_encap=IkeConfig_force_encap)
    session.add(ike_cfg)
#    commit_database(session)

def sw_create_ike_config_proposal(ike_cfg, prio, prop):
    ike_cfgprop = IkeConfigProposal(ike_cfg=ike_cfg, prio=prio, prop=prop)
    session.add(ike_cfgprop)
#    commit_database(session)

def sw_create_child_config_proposal(child_cfg, prio, prop):
    child_cfgprop = ChildConfigProposal(child_cfg=child_cfg, prio=prio, prop=prop)
    session.add(child_cfgprop)
#    commit_database(session)

def sw_get_identity(identityid):
    return session.query(Identity).filter_by(id=identityid).first()

def sw_create_certificate(certid, data, certtype=1, keytype=1):
    """
    1   CERT_X509   X.509 certificate
    2   CERT_X509_CRL   X.509 certificate revocation list
    5   CERT_X509_AC    X.509 attribute certificate
    6   CERT_TRUSTED_PUBKEY     trusted public key
    """
    certificate = Certificates(id=certid, type=certtype, keytype=keytype, data=data)
    session.add(certificate)
#    commit_database(session)

def sw_create_certificate_authorities(authid, certificate):
    certauth = CertificateAuthorities(id=authid, certificate=certificate)
    session.add(certauth)
#    commit_database(session)

def sw_create_certificate_distribution_points(ca, distribtype, uri):
    certpoints = CertificateDistributionPoints(ca=ca, type=distribtype, uri=uri)
    session.add(certpoints)
#    commit_database(session)

def sw_create_private_key(certid, data, pkeytype=1):
    """
    1   KEY_RSA     RSA key in PKCS!#1 format
    2   KEY_ECDSA   ECDSA key in ANSI X9.62 format
    """
    certificate = PrivateKey(id=certid, type=pkeytype, data=data)
    session.add(certificate)
#    commit_database(session)

def sw_join_certificate_identity(certid, identityid):
    cert_id = CertificateIdentity(certificate=certid, identity=identityid)
    session.add(cert_id)
#    commit_database(session)

def sw_join_privatekey_identity(keyid, identityid):
    cert_id = PrivateKeyIdentity(private_key=keyid, identity=identityid)
    session.add(cert_id)
#    commit_database(session)

#def sw_create_ikeconfig(ikeid, local, remote):
#    obj = IkeConfigs(id=ikeid, local=local, remote=remote)
#    session.add(obj)
#    commit_database(session)

def sw_create_peer_configs(name, id, local_id, remote_id, ike_cfg, virtual, pool, ike_version=PeerConfig_ike_version, peer_id=PeerConfig_peer_id,
        cert_policy=PeerConfig_cert_policy, uniqueid=PeerConfig_uniqueid, auth_method=PeerConfig_auth_method, eap_type=PeerConfig_eap_type,
        eap_vendor=PeerConfig_eap_vendor, keyingtries=PeerConfig_keyingtries, rekeytime=PeerConfig_rekeytime, reauthtime=PeerConfig_reauthtime,
        jitter=PeerConfig_jitter, overtime=PeerConfig_overtime, mobike=PeerConfig_mobike, dpd_delay=PeerConfig_dpd_delay, mediation=PeerConfig_mediation,
        mediated_by=PeerConfig_mediated_by
        ):
    obj = PeerConfigs(id=id, name=name, local_id=local_id, remote_id=remote_id, ike_cfg=ike_cfg, virtual=virtual, pool=pool, ike_version=ike_version,
            peer_id=peer_id, cert_policy=cert_policy, uniqueid=uniqueid, auth_method=auth_method, eap_type=eap_type, eap_vendor=eap_vendor,
            keyingtries=keyingtries, rekeytime=rekeytime, reauthtime=reauthtime, jitter=jitter, overtime=overtime, mobike=mobike,
            dpd_delay=dpd_delay, mediation=mediation, mediated_by=mediated_by)
    session.add(obj)
#    commit_database(session)

def sw_create_child_config(childid, name, updown, dpd_action, start_action, lifetime=ChildConfig_lifetime,
    rekeytime=ChildConfig_rekeytime, jitter=ChildConfig_jitter, hostaccess=ChildConfig_hostaccess,
    mode=ChildConfig_mode, close_action=ChildConfig_close_action, ipcomp=ChildConfig_ipcomp, reqid=0):
    obj = ChildConfig(id=childid, name=name, updown=updown, dpd_action=dpd_action, start_action=start_action, lifetime=lifetime,
                      rekeytime=rekeytime, jitter=jitter, hostaccess=hostaccess, mode=mode,
                      close_action=close_action, ipcomp=ipcomp, reqid=reqid)
    session.add(obj)
#    commit_database(session)

def sw_get_child_config_max_id():
    """
    get max id from ChilConfig table
    """
    qry =  session.query(func.max(ChildConfig.id))
    for _res in qry.all():
        if _res[0] is not None:
            return _res[0]
        else:
            return 0

def sw_join_child_peer(peer_id, childid):
    obj = PeerConfigChildConfig(peer_cfg=peer_id, child_cfg=childid)
    session.add(obj)
#    commit_database(session)

def sw_create_traffic_selector(trafficid, start_addr, end_addr, traffictype=7):
    """
    7   TS_IPV4_ADDR_RANGE
    8   TS_IPV6_ADDR_RANGE
    """
    obj = TrafficSelectors(id=trafficid, start_addr=start_addr, end_addr=end_addr, type=traffictype)
    session.add(obj)
#    commit_database(session)

def sw_get_traffic_selector(vertexid):
    return session.query(TrafficSelectors).filter_by(id=vertexid).first()

def sw_join_config_traffic(childid, trafficid, kind):
    """
    kind:
    0   TS_LOCAL
    1   TS_REMOTE
    2   TS_LOCAL_DYNAMIC
    3   TS_REMOTE_DYNAMIC
    TS_LOCAL/TS_REMOTE are used with predefined left/rightsubnets and
    TS_LOCAL_DYNAMIC/TS_REMOTE_DYNAMIC are used in host mode and might include
    the assignment of a virtual IP as shown in this roadwarrior example
    """
    obj = ChildConfigTrafficSelector(child_cfg=childid, traffic_selector=trafficid, kind=kind)
    session.add(obj)
#    commit_database(session)

def commit_database():
    session.commit()
    session.flush()

#def insert():
#    identity1 = Identity(type=2, data="sdfsdf")
#    childconfig1 = ChildConfig(id=1, name='toto')
#    private_key_identity1 = PrivateKeyidentity(private_key=1, identity=2)
#    logs1 = Logs(id=1, local_spi='xxxxxxxxxx', signal=2, level=4, msg='test')
#    session.add(identity1)
#    session.add(childconfig1)
#def insert():
#    identity1 = Identity(type=2, data="sdfsdf")
#    childconfig1 = ChildConfig(id=1, name='toto')
#    private_key_identity1 = PrivateKeyidentity(private_key=1, identity=2)
#    logs1 = Logs(id=1, local_spi='xxxxxxxxxx', signal=2, level=4, msg='test')
#    session.add(identity1)
#    session.add(childconfig1)
#    session.add(private_key_identity1)
#    session.add(logs1)
#    session.commit()
#
#def load():
#    print session.query(Identity).first()
#
#insert()
##load()
#
#our_identity = session.query(Identity).first()
##print our_identity.data
##print type(our_identity.data)
#
#child_config1 = session.query(ChildConfig).first()
##print child_config1.updown
#
#private_key_identity1 = session.query(PrivateKeyidentity).first()
##print private_key_identity1.identity
#
#logs1 = session.query(Logs).first()
##print logs1.time
#
