import logging
from arv.config import log_level, log_file

#logging.basicConfig()
#alch_logger = logging.getLogger('sqlalchemy.engine')
#alch_logger.setLevel(logging.DEBUG)
#handler = logging.FileHandler(log_file)
#alch_logger.addHandler(handler)


def get_logger(loggername):
    """logging facilites
    """
    LEVELS = {'debug': logging.DEBUG,
              'info': logging.INFO,
              'warning': logging.WARNING,
              'error': logging.ERROR,
              'critical': logging.CRITICAL}

    if not log_level in LEVELS:
        print("%s is not a valid log_level"%log_level)
        exit(1)
    #logger = logging.basicConfig(filename=log_file, level=LEVELS[log_level])
    arv_logger = logging.getLogger(loggername)
    arv_logger.setLevel(LEVELS[log_level])
    handler = logging.FileHandler(log_file)
    arv_logger.addHandler(handler)
    return arv_logger # logging.getLogger(loggername)


logger = get_logger('ARV')

