# -*- coding:utf-8 -*-
from IPy import IP
from os import mkdir, system, sep, remove, stat, \
               open as osopen, fdopen, O_WRONLY, O_CREAT
import os.path
from os.path import isfile, isdir, basename, dirname, join
from shutil import copy
import re
from arv.lib.util import trace, bin_encoding, ipsec_running, ipsec_restart, \
                         md5, gen_archive_name, normalize_unicode, \
                         remove_special_characters, extract_CN_from_certifstring

from arv.lib.logger import logger
from arv.db import initialize as arvdb
from arv.db.edge import get_credentials_auth, Crl, get_connects
from arv.db.node import get_vertex_by_node_tmplvertex, get_tmpl_nodes, get_nodes

from arv.db.strongswan import (sw_create_identity, sw_create_certificate,
    sw_create_private_key, sw_join_certificate_identity,
    sw_join_privatekey_identity, sw_create_peer_configs,
    sw_create_child_config, sw_join_child_peer, sw_create_traffic_selector,
    sw_join_config_traffic, sw_initialize_database, sw_get_identity,
    sw_get_traffic_selector, sw_create_proposals,
    sw_create_ike_config_proposal, sw_create_child_config_proposal,
    sw_create_certificate_authorities,
    sw_create_certificate_distribution_points, sw_create_ike_configs,
    sw_purge_database, commit_database, sw_get_child_config_max_id)

from arv.config import (ipsec_conf_file, ipsec_include_conf_files, ipsec_secrets_file,
    strongswan_database, strongswan_tmpconfigs_directory, tmpconfigs_directory_cacerts,
    tmpconfigs_directory_certs, tmpconfigs_directory_private,
    tmpconfigs_ipsec_conf_filename,tmpconfigs_ipsec_secrets_filename,
    IkeConfig_force_encap, PeerConfig_mobike, proposals, ike_cfg_proposal,
    PeerConfig_dpd_delay, child_cfg_proposal, test_rvp, vpn_path, start_action,
    dpd_action, remote_node_dpd_action, ip_sep, ipsec_conf_setup, ipsec_conf_ca,
    ipsec_conf_default, ipsec_conf_connection, ipsec_secrets,
    ipsec_conf_rw_connection_rw, ipsec_conf_rw_connection_gw)

global cache_bin
cache_bin = {}

def _make_cred_id(cred, typ):
    return int(str(cred.id) + typ)

@trace()
def get_encoding_credential(clear):
    global cache_bin
    clear = str(clear)
    if clear in cache_bin:
        data = cache_bin[clear]
    else:
        data = bin_encoding(clear)
        cache_bin[clear] = data
    return data

@trace()
def add_certificates_and_identities(nodea, creda, nodeb, credb):
    #Add cred for current in database
    #creds_a = nodea.get_credentials()
    ##test if node already in database
    #if creds_a == []:
    #    logger.debug('No creds for current node: {0}'.format(nodea.name))
    #    return
    ##Add Node in database
    #creds_b = nodeb.get_credentials()
    ##test if node already in database
    #if creds_b == []:
    #    logger.debug('No creds for remote node: {0}'.format(nodeb.name))
    #    return
    #add cred/identities only for current_node
    logger.debug("# iterate over creds for current node: {0}".format(nodea.name))
    type_nine = _make_cred_id(creda, '9')
    type_eleven_key_id = _make_cred_id(creda, '111')
    type_eleven_subjkey = _make_cred_id(creda, '112')
    if sw_get_identity(identityid=type_nine) == None:
        sw_create_identity(identityid=type_nine, data=creda.subject, nodetype=9)
        sw_create_identity(identityid=type_eleven_key_id, data=creda.keyid_cred, nodetype=11)
        sw_create_identity(identityid=type_eleven_subjkey, data=creda.subjkey, nodetype=11)
        sw_create_certificate(certid=creda.id,
                data=get_encoding_credential(creda.credential))
        sw_join_certificate_identity(identityid=type_eleven_key_id, certid=creda.id)
        sw_join_certificate_identity(identityid=type_eleven_subjkey, certid=creda.id)
        sw_join_certificate_identity(identityid=type_nine, certid=creda.id)
        sw_create_private_key(certid=creda.id,
                data=get_encoding_credential(creda.private_key))
        sw_join_privatekey_identity(keyid=creda.id, identityid=type_nine)
        sw_join_privatekey_identity(keyid=creda.id, identityid=type_eleven_key_id)
        sw_join_privatekey_identity(keyid=creda.id, identityid=type_eleven_subjkey)
    else:
        logger.debug('no certificates found for current node {0}'.format(nodea.name))

    #add cred/identities only for other node
    logger.debug("# iterate over creds for remote node: {0}".format(nodeb.name))
    type_nine = _make_cred_id(credb, '9')
    if sw_get_identity(identityid=type_nine) == None:
        sw_create_identity(identityid=type_nine, data=credb.subject, nodetype=9)
    else:
        logger.debug('no certificates found for remote node: {0}'.format(nodeb.name))

@trace()
def fill_database(current_node, arv_node=False):
    cache_vertex_id = []

    @trace()
    def create_vertex_id (vid, index):
        if index < 10:
            index = '0{0}'.format(index)
        elif index > 99:
            raise ValueError('Too many subvertices')
        return int('{0}{1}'.format(vid, index))

    @trace()
    def create_traffic_selector (vertex):
        vid = vertex.id
        if vid not in cache_vertex_id:
            vip1 = vertex.ip1.split(ip_sep)
            if vertex.tmpl_vertex.mimetype != 'ip':
                vip2 = vertex.ip2.split(ip_sep)
            for i in range(0, len(vip1)):

                tvid = create_vertex_id(vid, i)
                if vertex.tmpl_vertex.mimetype == 'ip':
                    start_ip = vip1[i]
                    end_ip = vip1[i]
                elif vertex.tmpl_vertex.mimetype == 'range':
                    start_ip = vip1[i]
                    end_ip = vip2[i]
                elif vertex.tmpl_vertex.mimetype == 'network':
                    ip = IP('%s/%s'%(vip1[i], vip2[i]))
                    last = len(ip)-1
                    start_ip = str(ip[0])
                    end_ip = str(ip[last])
                else:
                    raise Exception('vertex has unknown mimetype %s'%vertex.mimetype)
                sw_create_traffic_selector(trafficid=tvid,
                        start_addr=get_encoding_credential(start_ip),
                        end_addr=get_encoding_credential(end_ip))
            cache_vertex_id.append(vid)

    @trace()
    def create_child_join_edge_vertices(ikeid, edgeid, edge_name, vertex_a,
                                        vertex_b, updown, dpd_action):
        for i_a in range(0, len(vertex_a.ip1.split(ip_sep))):
            tvid_a = create_vertex_id(vertex_a.id, i_a)
            for i_b in range(0, len(vertex_b.ip1.split(ip_sep))):
                tvid_b = create_vertex_id(vertex_b.id, i_b)
                tedgeid = sw_get_child_config_max_id() + 1
                name_childcfg = '{0}_{1}'.format(edge_name, tedgeid)
                sw_create_child_config(childid=tedgeid, name=name_childcfg,
                                     updown=updown, dpd_action=dpd_action,
                                     start_action=start_action)
                for prop_priorities in child_cfg_proposal.values():
                    for prop in prop_priorities:
                        sw_create_child_config_proposal(tedgeid, prop[0], prop[1])
                sw_join_child_peer(peer_id=ikeid, childid=tedgeid)
                sw_join_config_traffic(childid=tedgeid, trafficid=tvid_a, kind=0)
                sw_join_config_traffic(childid=tedgeid, trafficid=tvid_b, kind=1)


    logger.debug('current_node : {0}'.format(current_node.name))

    # create tables from default values
    for propid, prop in proposals.items():
        sw_create_proposals(propid=propid, proposal=prop)

    #Add CA in database
    for cred in get_credentials_auth():
        logger.debug("# iterate over get_credentials_auth()")
        type_nine = _make_cred_id(cred, '9')
        type_eleven_key_id = _make_cred_id(cred, '111')
        sw_create_identity(type_eleven_key_id, cred.keyid_cred, nodetype=11)
        sw_create_identity(type_nine, cred.subject, nodetype=9)
        sw_create_certificate(certid=cred.id,
                data=get_encoding_credential(cred.credential))
        sw_create_certificate_authorities(authid=type_nine, certificate=cred.id)
        #add crls for the CA
        crls = Crl.query.filter_by(ca=cred).all()
        logger.debug("Crls {0}".format(crls))
        for crl in crls:
            sw_create_certificate_distribution_points(ca=type_nine, distribtype=1, uri=crl.uri)

        sw_join_certificate_identity(identityid=type_eleven_key_id, certid=cred.id)
        sw_join_certificate_identity(identityid=type_nine, certid=cred.id)
    dict_peername_suffix = {}
    for connect in get_connects(nodea=current_node):
        logger.debug("# iterate over get_connects() {0}".format(connect.tmpl_connect.name))
        if connect.tail_node == current_node or connect.head_node == current_node:
            logger.debug("#has current_node")
            ikeid = connect.id
            # FIXME : Unused variable 'ca'
            #ca = connect.tmpl_connect.cred_auth

            #search local node
            #search remote node
            if connect.tail_node == current_node:
                nodea = connect.tail_node
                creda = connect.tail_cred
                nodeb = connect.head_node
                credb = connect.head_cred
                local = connect.tail_extr.priv_ip
                remote = connect.head_extr.pub_ip
                name_peercfg = '%s-%s_' % (nodea.name, nodeb.name)
            else:
                nodea = connect.head_node
                creda = connect.head_cred
                nodeb = connect.tail_node
                credb = connect.tail_cred
                local = connect.head_extr.priv_ip
                remote = connect.tail_extr.pub_ip
                name_peercfg = '%s-%s_' % (nodeb.name, nodea.name)
            if name_peercfg in dict_peername_suffix:
                dict_peername_suffix[name_peercfg] += 1
            else:
                dict_peername_suffix[name_peercfg] = 1
            name_peercfg += str(dict_peername_suffix[name_peercfg])

            if creda == None:
                logger.debug("No credential for {0} in connect {1}".format(nodea.name, connect.tmpl_connect.name))
                continue
            if credb == None:
                logger.debug("No credential for {0} in connect {1}".format(nodeb.name, connect.tmpl_connect.name))
                continue
            ret = add_certificates_and_identities(nodea, creda, nodeb, credb)

            sw_create_ike_configs(ikeid, local, remote)
            for prop_priorities in ike_cfg_proposal.values():
                for prop in prop_priorities:
                    sw_create_ike_config_proposal(ikeid, prop[0], prop[1])

            local_id = _make_cred_id(creda, '9')
            remote_id = _make_cred_id(credb, '9')
            #peer_id = local_id
            sw_create_peer_configs(name=name_peercfg, id=ikeid, ike_cfg=ikeid,
                                   local_id=local_id, remote_id=remote_id, virtual=None, pool=None)
            #get all edges for this connect
            logger.debug('edges : {0}'.format(str(connect.edges)))
            for edge in connect.edges:
                name_childcfg = edge.tmpl_edge.name
                logger.debug("# iterate over edges {0}".format(name_childcfg))
                if current_node.tmpl_node.mimetype == 'sphynx':
                    updown = ''
                else:
                    updown = '/etc/ipsec.d/ipsec_updown'

                tmplvertex_a = edge.tmpl_edge.tmpl_vertex_a
                tmplvertex_b = edge.tmpl_edge.tmpl_vertex_b

                if nodea.tmpl_node == tmplvertex_a.tmpl_node:
                    if  nodeb.tmpl_node != tmplvertex_b.tmpl_node:
                        logger.error('no relation between nodeb et tmplvertex_b')
                        raise Exception('no relation between nodeb et tmplvertex_b')
                    vertex_a = get_vertex_by_node_tmplvertex(node=nodea, tmpl_vertex=tmplvertex_a)
                    vertex_b = get_vertex_by_node_tmplvertex(node=nodeb, tmpl_vertex=tmplvertex_b)
                    tmplvertex_name_a = tmplvertex_a.name
                    tmplvertex_name_b = tmplvertex_b.name
                elif nodea.tmpl_node == tmplvertex_b.tmpl_node:
                    if  nodeb.tmpl_node != tmplvertex_a.tmpl_node:
                        logger.error('no relation between nodeb et tmplvertex_a')
                        raise Exception('no relation between nodeb et tmplvertex_a')
                    vertex_a = get_vertex_by_node_tmplvertex(node=nodea, tmpl_vertex=tmplvertex_b)
                    vertex_b = get_vertex_by_node_tmplvertex(node=nodeb, tmpl_vertex=tmplvertex_a)
                    tmplvertex_name_a = tmplvertex_b.name
                    tmplvertex_name_b = tmplvertex_a.name
                else:
                    logger.error('no relation between nodea et tmplvertex')
                    raise Exception('no relation between nodea et tmplvertex')

                if vertex_a == None:
                    logger.debug("No vertex for node %s and tmpl_vertex %s"%(nodea.name, tmplvertex_name_a))
                    continue
                if vertex_b == None:
                    logger.debug("No vertex for node %s and tmpl_vertex %s"%(nodeb.name, tmplvertex_name_b))
                    continue

                ##
                create_traffic_selector(vertex_a)
                create_traffic_selector(vertex_b)
                node_dpd_action = dpd_action if arv_node == True else remote_node_dpd_action
                create_child_join_edge_vertices(ikeid=ikeid, edgeid=edge.id,
                                                edge_name=name_childcfg,
                                                vertex_a=vertex_a,
                                                vertex_b=vertex_b,
                                                updown=updown,
                                                dpd_action=node_dpd_action)
        else:
            logger.debug("no %s node for %s" % (current_node.name, connect.tmpl_connect.name))

@trace()
def db_apply(zephir):
    arvdb.initialize_database()
    ipsec_conf_content = ipsec_conf_setup\
                       + "\n#configuration is read from SQLite database\n"
    tmpl_nodes = get_tmpl_nodes('sphynx')
    if len(tmpl_nodes) == 0:
        raise Exception('No available connect')
    if tmpl_nodes == []:
        raise Exception("No template for sphynx")
    if len(tmpl_nodes) != 1:
        raise Exception('More than one tmpl sphynx in database !')
    if tmpl_nodes[0].nodes == []:
        raise Exception("No sphynx in template")
    current_node = tmpl_nodes[0].nodes[0]
    if isfile(strongswan_database) and stat(strongswan_database).st_size != 0:
        sw_purge_database('sqlite:///%s'%strongswan_database)
    else:
        sw_initialize_database('sqlite:///%s'%strongswan_database)
    fill_database(current_node, arv_node=True)
    commit_database()
    ipsec_conf_handler = open(ipsec_conf_file, "wb")
    ipsec_conf_handler.write(ipsec_conf_content)
    ipsec_conf_handler.close()

    if not ipsec_running():
        ipsec_restart()

    if not isdir(strongswan_tmpconfigs_directory):
        raise Exception('Directory %s not found' % strongswan_tmpconfigs_directory)
    for node in get_nodes():
        if node == current_node:
            continue
        database = '%s%s.db'% (strongswan_tmpconfigs_directory, node.name)
        if isfile(database):
            remove(database)
        sw_initialize_database('sqlite:///%s'%database)
        fill_database(node)
        commit_database()
        uai = node.uai
        name = node.name
        id_zephir = node.id_zephir
        if uai != None:
            logger.debug("Creating archive database : {0} and uai : {1}".format(database, uai))
            # database archive
            if not isdir(dirname(vpn_path)):
                mkdir(dirname(vpn_path))
            if not isdir(vpn_path):
                mkdir(vpn_path)
            amonpath, archivename = gen_archive_name(uai, name)
            if not isdir(amonpath):
                mkdir(amonpath)
            database_md5sum_file = str(uai) + "-" + name + ".md5sum"
            database_md5sum_file = join(amonpath, database_md5sum_file)
            database_md5sum = []
            database_md5sum.append(md5(database))
            ipsec_conf_handler = open(join(amonpath, "ipsec.conf"), "wb")
            ipsec_conf_handler.write(ipsec_conf_content)
            ipsec_conf_handler.close()
            copy(database, join(amonpath, "ipsec.db"))
            name_test_rvp = join(amonpath, "test-rvp")
            ftest_rvp = open(name_test_rvp,"wb")
            ftest_rvp.write(test_rvp)
            ftest_rvp.close()
            system("chmod 755 {0}".format(name_test_rvp))
            database_md5sum.append(md5(name_test_rvp, sw_database_mode='False'))
            try:
                fd = open(database_md5sum_file, "r")
                prec_database_md5sum = fd.read().split('\n')
                fd.close()
            except:
                prec_database_md5sum = "first"
            if database_md5sum != prec_database_md5sum:
                fd = open(database_md5sum_file, "wb")
                fd.write('\n'.join(database_md5sum))
                fd.close()
                system("""cd "{0}" ; tar -czf "{2}" {1}""".format(amonpath, "ipsec.conf ipsec.db test-rvp", archivename))
                remove(join(amonpath, "ipsec.db"))
                remove(name_test_rvp)
                remove(join(amonpath, "ipsec.conf"))
                archive = join(amonpath, archivename)
                if zephir != None:
                    logger.debug("Send rvp archive to Zéphir")
                    zephir.send_db(archive, uai, name, id_zephir)
            remove(database)

@trace()
def ipsec_conf_build(zephir, current_node, arv_node=False):
    """
    """
    logger.debug('current_node : {0}'.format(current_node.name))
    uai = current_node.uai.decode() if isinstance(current_node.uai, bytes) else current_node.uai
    name = current_node.name.decode() if isinstance(current_node.name, bytes) else current_node.name
    id_zephir = current_node.id_zephir
    local_node_mimetype = current_node.tmpl_node.mimetype

    if uai != None:
        # ipsec configuration archive
        if not isdir(dirname(vpn_path)):
            mkdir(dirname(vpn_path))
        if not isdir(vpn_path):
            mkdir(vpn_path)
        node_path, archivename = gen_archive_name(uai, name)

        ipsec_secrets_content = []
        ipsec_conf_content = []
        ipsec_conf_content.append("#configuration is in ipsec.conf file")
        ipsec_conf_content.append(ipsec_conf_setup)

        config_md5sum_file = uai + "-" + name + ".md5sum"
        config_md5sum_file = join(node_path, config_md5sum_file)
        config_md5sum = []

        for cred in get_credentials_auth():
            logger.debug("# iterate over get_credentials_auth()")
            #Add CA in ipsec.conf file (optional, only if crl)
            crls = Crl.query.filter_by(ca=cred).all()
            cred_filename = re.sub('(.*)/(.*)', r'\1_\2', cred.name) + ".pem"
            if crls:
                uri_number = 0
                crluri = ''
                crluri1 = ''
                for crl in crls:
                    if uri_number == 0:
                        crluri = crl.uri
                    if uri_number == 1:
                        crluri1 = crl.uri
                    uri_number +=  1

                ipsec_conf_content.append(ipsec_conf_ca.format(cred.name+"_CA", \
                                                               cred_filename, \
                                                               crluri, \
                                                               crluri1))
            # write ca file
            ca_filename = join(tmpconfigs_directory_cacerts, cred_filename)
            ca_handler = open (ca_filename, "wb")
            ca_handler.write(cred.credential)
            ca_handler.close()
            config_md5sum.append(md5(ca_filename, sw_database_mode='False'))

        # generate proposal config for ike and esp
        ike_proposals = []
        for prop_priorities in ike_cfg_proposal.values():
            for prop_prioritie in prop_priorities:
                ike_proposals.append(proposals[prop_prioritie[1]])
        ike_proposals = ','.join(ike_proposals)

        esp_proposals = []
        for prop_priorities in child_cfg_proposal.values():
            for prop_prioritie in prop_priorities:
                esp_proposals.append(proposals[prop_prioritie[1]])
        esp_proposals = ','.join(esp_proposals)

        # Generate default connection
        if IkeConfig_force_encap == "0":
            sw_forceencap = "no"
        else:
            sw_forceencap = "yes"
        if local_node_mimetype == "roadwarrior":
            sw_mobike = "yes"
        elif PeerConfig_mobike == "0":
            sw_mobike = "no"
        else:
            sw_mobike = "yes"
        if arv_node == True:
            node_dpd_action = "clear" if dpd_action == "0" else "hold" if dpd_action == "1" else "restart" if dpd_action == "2" else "none"
        else:
            node_dpd_action = "clear" if remote_node_dpd_action == "0" else "hold" if remote_node_dpd_action == "1" else "restart" if remote_node_dpd_action == "2" else "none"
        ipsec_conf_content.append(ipsec_conf_default.format(node_dpd_action, \
                                  PeerConfig_dpd_delay, \
                                  ike_proposals, \
                                  esp_proposals, \
                                  sw_forceencap, \
                                  sw_mobike, \
                                  ipsec_include_conf_files))

        # Generate connections
        dict_peername_suffix = {}
        secrets = []
        for connect in get_connects(nodea=current_node):
            logger.debug("# iterate over get_connects() {0}".format(connect.tmpl_connect.name))
            # Flag for the ordering network into a tunnel
            if connect.head_node == current_node or connect.tail_node == current_node:
                logger.debug("#has current_node")
                current_is_head = True if connect.head_node == current_node else False
                local_node = connect.head_node if current_is_head else connect.tail_node
                remote_node = connect.tail_node if current_is_head else connect.head_node
                remote_node_mimetype = remote_node.tmpl_node.mimetype
                local_cred = connect.head_cred if current_is_head else connect.tail_cred
                remote_cred = connect.tail_cred if current_is_head else connect.head_cred
                if local_node_mimetype == "roadwarrior":
                    local = None
                else:
                    if current_is_head:
                        local = connect.head_extr.priv_ip
                    else:
                        local = connect.tail_extr.priv_ip
                if remote_node_mimetype == "roadwarrior":
                    remote = "%any"
                else:
                    if current_is_head:
                        remote = connect.tail_extr.pub_ip
                    else:
                        remote = connect.head_extr.pub_ip
                local_node_name = local_node.name.decode() if isinstance(local_node.name, bytes) else local_node.name
                remote_node_name = remote_node.name.decode() if isinstance(remote_node.name, bytes) else remote_node.name
                logger.debug("Current/local node {0} is {1} node".format(current_node.name, "HEAD" if current_is_head else "TAIL"))
                logger.debug("remote node {0} is {1} node".format(remote_node_name, "TAIL" if current_is_head else "HEAD"))
                name_peercfg = '%s-%s_' % (remove_special_characters(str(local_node_name)), remove_special_characters(str(remote_node_name)))
                if name_peercfg in dict_peername_suffix:
                    dict_peername_suffix[name_peercfg] += 1
                else:
                    dict_peername_suffix[name_peercfg] = 1
                name_peercfg += str(dict_peername_suffix[name_peercfg])

                if local_cred == None:
                    logger.debug("No credential for {0} in connect {1}".format(local_node_name, connect.tmpl_connect.name))
                    continue
                if remote_cred == None:
                    logger.debug("No credential for {0} in connect {1}".format(remote_node_name, connect.tmpl_connect.name))
                    continue

                # generate certificate and private key files
                local_cred_filename = re.sub('(.*)/(.*)', r'\1_\2', local_cred.name) + ".pem"
                cred_filename = join(tmpconfigs_directory_certs, local_cred_filename)
                logger.debug("local_cred_filename %s" % local_cred_filename)
                local_CN = extract_CN_from_certifstring(local_cred.credential)
                remote_CN = extract_CN_from_certifstring(remote_cred.credential)
                cred_handler = open(cred_filename, 'wb')
                cred_handler.write(local_cred.credential)
                cred_handler.close()
                config_md5sum.append(md5(cred_filename, sw_database_mode='False'))
                privkey_filename = join(tmpconfigs_directory_private, "priv" + local_cred_filename)
                privkey_handler = fdopen(osopen(privkey_filename, O_WRONLY|O_CREAT, 0o400), 'wb')
                privkey_handler.write(local_cred.private_key)
                privkey_handler.close()
                config_md5sum.append(md5(privkey_filename, sw_database_mode='False'))
                if connect.leftsendcert == b'never':
                    remote_cred_filename = re.sub('(.*)/(.*)', r'\1_\2', remote_cred.name) + ".pem"
                    cred_filename = join(tmpconfigs_directory_certs, remote_cred_filename)
                    cred_handler = open(cred_filename, 'wb')
                    cred_handler.write(remote_cred.credential)
                    cred_handler.close()
                    config_md5sum.append(md5(cred_filename, sw_database_mode='False'))
                else:
                    remote_cred_filename = ""

                # No duplicate line in ipsec.secrets file
                if local_cred.name not in secrets:
                    if local_node_mimetype == "roadwarrior":
                        prompt = " %prompt"
                    else:
                        prompt = ""
                    secrets.append(local_cred.name)
                    ipsec_secrets_content.append(ipsec_secrets.format(local_cred.suffix_cred+"/CN="+local_CN, \
                                                                  "priv"+local_cred_filename, \
                                                                  prompt))
                #get all edges for this connect
                logger.debug('edges : {0}'.format(str(connect.edges)))
                for edge in connect.edges:
                    connection_name = name_peercfg + "-" + edge.tmpl_edge.name
                    logger.debug("# iterate over edges {0}".format(edge.tmpl_edge.name))
                    if current_node.tmpl_node.mimetype == 'sphynx':
                        updown = ''
                    else:
                        updown = '/etc/ipsec.d/ipsec_updown'
                    if local_node.tmpl_node == remote_node.tmpl_node:
                        # Connect between same type nodes
                        logger.debug("Same tmpl_node")
                        local_tmplvertex = edge.tmpl_edge.tmpl_vertex_a if current_is_head else edge.tmpl_edge.tmpl_vertex_b
                        remote_tmplvertex = edge.tmpl_edge.tmpl_vertex_b if current_is_head else edge.tmpl_edge.tmpl_vertex_a
                    else:
                        # Connect between different type nodes
                        logger.debug("different tmpl_node")
                        if edge.tmpl_edge.tmpl_vertex_a.tmpl_node == local_node.tmpl_node:
                            local_tmplvertex = edge.tmpl_edge.tmpl_vertex_a
                            remote_tmplvertex = edge.tmpl_edge.tmpl_vertex_b
                        else:
                            local_tmplvertex = edge.tmpl_edge.tmpl_vertex_b
                            remote_tmplvertex = edge.tmpl_edge.tmpl_vertex_a
                    logger.debug("local tmplvertex {0}".format(local_tmplvertex.name))
                    logger.debug("remote tmplvertex {0}".format(remote_tmplvertex.name))
                    local_vertex = get_vertex_by_node_tmplvertex(node=local_node, tmpl_vertex=local_tmplvertex)
                    remote_vertex = get_vertex_by_node_tmplvertex(node=remote_node, tmpl_vertex=remote_tmplvertex)
                    if local_vertex == None:
                        logger.debug("No vertex for node %s and tmpl_vertex %s"%(local_node.name, local_tmplvertex.name))
                        continue
                    if remote_vertex == None:
                        logger.debug("No vertex for node %s and tmpl_vertex %s"%(remote_node.name, remote_tmplvertex.name))
                        continue

                    # generate connection
                    leftid = re.sub(r'/', ', ', re.sub(r'^/', '', local_cred.suffix_cred)) + ", CN=" + local_CN
                    rightid = re.sub(r'/', ', ', re.sub(r'^/', '', remote_cred.suffix_cred)) + ", CN=" + remote_CN
                    if local_vertex.tmpl_vertex.mimetype == 'ip':
                        leftsubnet = str(IP(local_vertex.ip1))+"/32"
                        logger.debug("LeftSubnet IP : {0}".format(leftsubnet))
                    elif local_vertex.tmpl_vertex.mimetype == 'network':
                        if ip_sep in local_vertex.ip1:
                            vip1 = local_vertex.ip1.split(ip_sep)
                            vip2 = local_vertex.ip2.split(ip_sep)
                            leftsubnet = []
                            for i in range(0, len(vip1)):
                                leftsubnet.append(str(IP('%s/%s'%(vip1[i], vip2[i]))))
                            leftsubnet = ','.join(leftsubnet)
                        else:
                            leftsubnet = str(IP(local_vertex.ip1+"/"+local_vertex.ip2))
                    elif local_vertex.tmpl_vertex.mimetype == 'range':
                        raise Exception("Range network not supported")
                    if remote_vertex.tmpl_vertex.mimetype == 'ip':
                        if remote_node_mimetype == "roadwarrior":
                            rightsubnet = str(IP(remote_vertex.ip1))
                        else:
                            rightsubnet = str(IP(remote_vertex.ip1))+"/32"
                        logger.debug("RightSubnet IP : {0}".format(rightsubnet))
                    elif remote_vertex.tmpl_vertex.mimetype == 'network':
                        if ip_sep in remote_vertex.ip1:
                            vip1 = remote_vertex.ip1.split(ip_sep)
                            vip2 = remote_vertex.ip2.split(ip_sep)
                            rightsubnet = []
                            for i in range(0, len(vip1)):
                                rightsubnet.append(str(IP('%s/%s'%(vip1[i], vip2[i]))))
                            rightsubnet = ','.join(rightsubnet)
                        else:
                            rightsubnet = str(IP(remote_vertex.ip1+"/"+remote_vertex.ip2))
                    elif remote_vertex.tmpl_vertex.mimetype == 'range':
                        raise Exception("Range network not supported")
                    connect_leftsendcert = connect.leftsendcert.decode() if isinstance(connect.leftsendcert, bytes) else connect.leftsendcert
                    connect_fragmentation = connect.fragmentation.decode() if isinstance(connect.fragmentation, bytes) else connect.fragmentation
                    if local_node_mimetype == "roadwarrior":
                        ipsec_conn = ipsec_conf_rw_connection_rw.format(\
                            connection_name, \
                            leftid, \
                            local_cred_filename, \
                            connect_leftsendcert, \
                            rightid, \
                            remote_cred_filename, \
                            remote, \
                            rightsubnet, \
                            connect_fragmentation)
                    elif remote_node_mimetype == "roadwarrior":
                        ipsec_conn = ipsec_conf_rw_connection_gw.format(\
                            connection_name, \
                            leftid, \
                            local_cred_filename, \
                            connect_leftsendcert, \
                            local, \
                            leftsubnet, \
                            updown, \
                            rightid, \
                            remote_cred_filename, \
                            rightsubnet, \
                            connect.rw_dns, \
                            connect_fragmentation)
                    else:
                        ipsec_conn = ipsec_conf_connection.format(\
                            connection_name, \
                            leftid, \
                            local_cred_filename, \
                            connect_leftsendcert, \
                            local, \
                            leftsubnet, \
                            updown, \
                            rightid, \
                            remote_cred_filename, \
                            remote, \
                            rightsubnet, \
                            connect_fragmentation)
                    if connect.leftsendcert == b'always':
                        # Suppress unnecessary config lines
                        ipsec_conn = re.sub(r'.*leftsendcert = .*\n', r'', ipsec_conn)
                        ipsec_conn = re.sub(r'.*rightcert = .*\n', r'', ipsec_conn)
                    ipsec_conf_content.append(ipsec_conn)
            else:
                logger.debug("no %s node for %s" % (current_node.name, connect.tmpl_connect.name))
        # END generate connections

        # write ipsec.conf file with ipsec_conf_content
        ipsec_conf_content = '\n'.join(ipsec_conf_content)
        ipsec_conf_handler = open(tmpconfigs_ipsec_conf_filename, "w")
        ipsec_conf_handler.write(ipsec_conf_content)
        ipsec_conf_handler.close()
        config_md5sum.append(md5(tmpconfigs_ipsec_conf_filename, sw_database_mode='False'))

        # write ipsec.secrets file with ipsec_secrets_content
        ipsec_secrets_content = '\n'.join(ipsec_secrets_content)
        ipsec_secrets_handler = open(tmpconfigs_ipsec_secrets_filename, "w")
        ipsec_secrets_handler.write(ipsec_secrets_content)
        ipsec_secrets_handler.close()
        config_md5sum.append(md5(tmpconfigs_ipsec_secrets_filename, sw_database_mode='False'))

        logger.debug("Creating VPN archive for {0} {1} server.".format(uai, name))
        # write test-rvp file
        if local_node_mimetype != "roadwarrior":
            test_rvp_filename = join(strongswan_tmpconfigs_directory, "test-rvp")
            ftest_rvp = open(test_rvp_filename, "w")
            ftest_rvp.write(test_rvp)
            ftest_rvp.close()
            system("chmod 755 {0}".format(test_rvp_filename))
            config_md5sum.append(md5(test_rvp_filename, sw_database_mode='False'))
        try:
            fd = open(config_md5sum_file, "r")
            prec_config_md5sum = fd.read().split('\n')
            fd.close()
        except:
            prec_config_md5sum = "first"
        if config_md5sum != prec_config_md5sum:
            if not isdir(node_path):
                mkdir(node_path)
            fd = open(config_md5sum_file, "w")
            fd.write('\n'.join(config_md5sum))
            fd.close()

        # creating archive file
        system("""cd {0}
                  tar czf "{1}" *
                  mv "{0}{1}" "{2}/" """.format(strongswan_tmpconfigs_directory, \
                                       archivename, \
                                       node_path))
        # remove temporaries files
        for root, dirs, files in os.walk(strongswan_tmpconfigs_directory):
            for f in files:
                remove(join(root, f))

        # if local Sphynx, update ipsec configuration
        if arv_node == True:
            logger.debug("Local server : updating ipsec configuration")
            system("""tar zxf "{0}/{1}" -C /etc/
                      /usr/share/eole/sbin/active_rvp generate_passthrough
                      ipsec rereadall
                      ipsec update""".format(node_path, \
                                             archivename))
        else:
            if config_md5sum != prec_config_md5sum:
                # send archive to Zéphir if allowed
                archive = join(node_path, archivename)
                if zephir != None:
                    logger.debug("Send rvp archive to Zéphir")
                    zephir.send_db(archive, uai, name, id_zephir)

@trace()
def ipsec_conf_apply(zephir):
    arvdb.initialize_database()
    tmpl_nodes = get_tmpl_nodes('sphynx')
    if len(tmpl_nodes) == 0:
        raise Exception('No available connect')
    if tmpl_nodes == []:
        raise Exception("No template for sphynx")
    if len(tmpl_nodes) != 1:
        raise Exception('More than one tmpl sphynx in database !')
    if tmpl_nodes[0].nodes == []:
        raise Exception("No sphynx in template")

    if not isdir(strongswan_tmpconfigs_directory):
        raise Exception('Directory %s not found' % strongswan_tmpconfigs_directory)

    current_node = tmpl_nodes[0].nodes[0]

    # Constructs ipsec configuration for local node
    ipsec_conf_build(zephir, current_node, arv_node=True)

    if not ipsec_running():
        ipsec_restart()

    # Constructs ipsec configuration for all other nodes
    for node in get_nodes():
        if node == current_node:
            continue
        ipsec_conf_build(zephir, node)
