# -*- coding: UTF-8 -*-
"""website add pages
"""
import ast
from os.path import isfile, join
from subprocess import getstatusoutput
from datetime import datetime
from datetime import timedelta
from creole import cert
from arv.web.page import Page, usezephir, IPreferences
from arv.db.edge import *
from arv.db.node import *
from arv.lib.factory import get_object_by_id
from arv.lib.util import trace, get_req_archive, gen_archive_name, valid, \
                         split_pkcs12, split_pkcs7
from arv.lib.logger import logger
from arv.config import nearly_expired_cred, amon_module_list, \
                       sphynx_module_list, suffix_dns

#from zephir.monitor.agents.rvp import parse_ipsec_statusall

# ____________________________________________________________
# save pages root
class SavePage(Page):
    """save pages root page
    """
    save_database = True

# ____________________________________________________________
# add pages
class AddTmplConnect(SavePage):
    def render_page(self, request):
        name = self.get_data_from_request(request=request, arg='name')
        tmpl_node1 = self.get_data_from_request(request=request,
                arg='tmplnode1', object_type='tmpl_node')
        tmpl_node2 = self.get_data_from_request(request=request,
                arg='tmplnode2', object_type='tmpl_node')
        credauth = self.get_data_from_request(request=request,
                arg='credauth', object_type='credential')
        leftsendcert = self.get_data_from_request(request=request,
                arg='leftsendcert')
        fragmentation = self.get_data_from_request(request=request,
                arg='fragmentation')
        if not credauth.ca:
            raise Exception('Credential need to be authority')
        add_tmpl_connect(name, tmpl_node1, tmpl_node2, credauth, leftsendcert, fragmentation)
        return "TmplConnect added"

class AddTmplNode(SavePage):
    def render_page(self, request):
        name = self.get_data_from_request(request=request, arg='name')
        add_tmpl_node(name)
        return 'TmplNode added'

class AddTmplEdge(SavePage):
    def render_page(self, request):
        name = self.get_data_from_request(request=request, arg='name')
        tmpl_vertex1 = self.get_data_from_request(request=request,
                arg='tmplvertex1', object_type='tmpl_vertex')
        tmpl_vertex2 = self.get_data_from_request(request=request,
                arg='tmplvertex2', object_type='tmpl_vertex')
        tmpl_connect = self.get_data_from_request(request=request,
                arg='id', object_type='tmpl_connect')

        tmpl_connect.add_tmpl_edge(name, tmpl_vertex1, tmpl_vertex2)
        return 'TmplEdge added'

class AddTmplVertex(SavePage):
    def render_page(self, request):
        name = self.get_data_from_request(request=request, arg='name')
        tmpl_node = self.get_data_from_request(request=request,
                arg='id', object_type='tmpl_node')
        mimetype = self.get_data_from_request(request=request,
                arg='mimetype')
        zephir_module = self.get_data_from_request(request=request,
                arg='moduleid')
        zephir_var_ip1 = self.get_data_from_request(request=request, arg='ip1')
        zephir_var_ip2 = self.get_data_from_request(request=request,
                arg='ip2', required = False)

        tmpl_vertex1 = tmpl_node.add_tmpl_vertex(name=name,
                mimetype=mimetype,
                zephir_module=zephir_module,
                zephir_var_ip1=zephir_var_ip1,
                zephir_var_ip2=zephir_var_ip2)
        return 'TmplVertex added'


class AddNode(SavePage):
    @trace()
    def render_page(self, request):
        name =  self.get_data_from_request(request=request, arg='name')
        uai =  self.get_data_from_request(request=request, arg='uai')
        try:
            id_zephir =  int(self.get_data_from_request(request=request, arg='id_zephir'))
        except:
            # In manual mode --> no id_zephir
            id_zephir = None
        try:
            eole_version =  self.get_data_from_request(request=request, arg='eole_version')
        except:
            # In manual mode --> no eole_version
            eole_version = None
        tmpl_node = self.get_data_from_request(request=request, arg='id', object_type='tmpl_node', required=False)
        mimetype  = self.get_data_from_request(request=request, arg='mimetype', required=False)
        logger.debug('#-> add_node param :name: ' + name.decode())
        if tmpl_node == None:
            if not mimetype:
                mimetype = 'etablissement'
            tmpl_node = get_tmpl_nodes(mimetype=mimetype)[0]
        vertices = self.get_data_from_request(request=request, arg='vertices', load_json=True)

        node = tmpl_node.add_node(name=name, uai=uai, id_zephir=id_zephir, eole_version=eole_version)
        for tvid, ip in vertices.items():
            logger.debug('#ip : %s'%ip)
            ip1 = ip[0]
            ip2 = ip[1]
            if not ip1 in ["", None]:
                logger.debug('add this ip')
                tmpl_vertex = get_object_by_id(int(tvid), 'tmpl_vertex')
                if ip2 == "":
                    ip2 = None
                tmpl_vertex.add_vertex(ip1=ip1, ip2=ip2, node=node)
        return 'Node added'

class AddConnect(SavePage):
    def render_page(self, request):
        tail_node = self.get_data_from_request(request=request, arg='node1', object_type='node')
        head_node = self.get_data_from_request(request=request, arg='node2', object_type='node')
        tail_cred = self.get_data_from_request(request=request, arg='cred1', object_type='credential')
        head_cred = self.get_data_from_request(request=request, arg='cred2', object_type='credential')
        leftsendcert = self.get_data_from_request(request=request, arg='leftsendcert')
        fragmentation = self.get_data_from_request(request=request, arg='fragmentation')
        if tail_node.tmpl_node.mimetype == 'roadwarrior':
            tail_extr = None
        else:
            tail_extr = self.get_data_from_request(request=request, arg='extr1', object_type='extremity')
        if head_node.tmpl_node.mimetype == 'roadwarrior':
            head_extr = None
        else:
            head_extr = self.get_data_from_request(request=request, arg='extr2', object_type='extremity')
        if tail_node.tmpl_node.mimetype == 'roadwarrior' or head_node.tmpl_node.mimetype == 'roadwarrior':
            rw_dns = self.get_data_from_request(request=request, arg='rw_dns')
        else:
            rw_dns = None
        tmpl_connect = self.get_data_from_request(request=request, arg='tmpl_connect', object_type='tmpl_connect')
        edges = self.get_data_from_request(request=request, arg='edges', load_json=True)
        connect = tmpl_connect.add_connect(tail_node, head_node,
                                           tail_extr, head_extr, tail_cred, head_cred, leftsendcert,
                                           fragmentation, rw_dns)
        for tmpledgeid, activated in edges.items():
            if activated:
                tmpl_edge = get_object_by_id(tmpledgeid, 'tmpl_edge')
                tmpl_edge.add_edge(connect)
        return 'Connect added'

class AddImportedCred(SavePage):
    def render_page(self, request):
        private_key = self.get_data_from_request(request=request, arg='private_key')
        public_key = self.get_data_from_request(request=request, arg='public_key')
        password = self.get_data_from_request(request=request, arg='password', required=True)
        node = self.get_data_from_request(request=request, arg='node', object_type='node')
        connect_id = self.get_data_from_request(request=request, arg='tmplconnect_id', required=False)
        if valid(connect_id, 'integer'):
            # Adding a certificate for a node to be used with a specific connection
            tmpl_connect = self.get_data_from_request(request=request, arg='tmplconnect_id', object_type='tmpl_connect', required=False)
            cred_auth = tmpl_connect.cred_auth
        else:
            cred_auth = None
        node.import_credential(private_key=private_key, credential=public_key, passwd=password, old_ca=cred_auth)
        return 'Credential imported'

class AddImportedPKCS12(SavePage):
    def render_page(self, request):
        pkcs12_certificate = self.get_data_from_request(request=request, arg='pkcs12_file')
        pkcs12_password = self.get_data_from_request(request=request, arg='pkcs12_password', required=True)
        key_passphrase = self.get_data_from_request(request=request, arg='key_passphrase', required=True)
        node = self.get_data_from_request(request=request, arg='node', object_type='node')
        connect_id = self.get_data_from_request(request=request, arg='tmplconnect_id', required=False)
        if valid(connect_id, 'integer'):
            # Adding a certificate for a node to be used with a specific connection
            tmpl_connect = self.get_data_from_request(request=request, arg='tmplconnect_id', object_type='tmpl_connect', required=False)
            cred_auth = tmpl_connect.cred_auth
        else:
            cred_auth = None
        private_key , pkcs7_certificate = split_pkcs12(pkcs12_certificate, pkcs12_password, key_passphrase)
        node.import_credential(private_key=private_key, credential=pkcs7_certificate, passwd=key_passphrase, old_ca=cred_auth)
        return 'Credential imported'

class AddGeneratedCred(SavePage):
    def render_page(self, request):
        name = self.get_data_from_request(request=request, arg='name').decode()
        if suffix_dns != "":
            splitted_name = name.split(suffix_dns)
            if len(splitted_name) == 1 or len(splitted_name) == 2 and splitted_name[-1] != "":
                name = name + suffix_dns
        passwd = self.get_data_from_request(request=request, arg='passwd')
        node = self.get_data_from_request(request=request, arg='node', object_type='node')
        #cred_priv_type = self.get_data_from_request(request=request, arg='cred_priv_type')
        cred_priv_type = request.args[b'cred_priv_type'][0].decode()
        logger.debug("#-> cred_priv_type" + cred_priv_type)
        credential = add_credential(name, passwd, node, cred_priv_type)
        if credential != True:
            return ("download_name", 'arv/dl_credential?name=%s'%name, 'Credential added')
        return 'Credential added'

class DlCredential(SavePage):
    def render_page(self, request):
        #return ("download_file", 'toto.cert', "ca c'est du gros fichier.")
        name = self.get_data_from_request(request=request, arg='name').decode()
        #logger.debug('unsigned_credential in DlCredential: %s'%str(credential.unsigned_credential))
        reqfile_content = get_req_archive(name)
        return ("download_file", name+".tgz", reqfile_content) #credential.unsigned_credential)

class AddCredAuth(SavePage):
    def render_page(self, request):
        credentialauth = self.get_data_from_request(request=request, arg='credentialauth')
        if add_certificate_authorities(certif=credentialauth) is None:
            raise Exception("No CA certificate added")
        return 'Credential auth added'

class AddExtremity(SavePage):
    def render_page(self, request):
        pub_ip = request.args[b'pub_ip'][0].decode()
        priv_ip = request.args[b'priv_ip'][0].decode()
        if priv_ip == "":
            priv_ip = None
        node = self.get_data_from_request(request=request, arg='id', object_type='node')
        node.add_extremity(pub_ip=pub_ip, priv_ip=priv_ip)
        return 'Extremity added'

# ____________________________________________________________
# mod pages

class ModNode(SavePage):
    @trace()
    def render_page(self, request):
        node = self.get_data_from_request(request=request, arg='node', object_type='node')
        id_zephir = self.get_data_from_request(request=request, arg='id_zephir').decode()
        if id_zephir != '':
            node.id_zephir = int(id_zephir)
        node.name = self.get_data_from_request(request=request, arg='name')
        node.uai = self.get_data_from_request(request=request, arg='uai')
        node.mimetype = self.get_data_from_request(request=request, arg='mimetype')
        vertices = self.get_data_from_request(request=request, arg='vertices', load_json=True)
        node_vertices = {}
        for vertex in node.vertices:
            if vertex.tmpl_vertex:
                node_vertices[vertex.tmpl_vertex.id] = vertex
        mod_node = []
        for tvid, ip in vertices.items():
            ip1 = ip[0]
            ip2 = ip[1]
            if ip2 == "":
                ip2 = None
            if not ip1 in ["", None]:
                tvid = int(tvid)
                if not tvid in node_vertices:
                    tmpl_vertex = get_object_by_id(tvid, 'tmpl_vertex')
                    tmpl_vertex.add_vertex(ip1=ip1, ip2=ip2, node=node)
                else:
                    node_vertices[tvid].set_ips(ip1, ip2)
                    mod_node.append(tvid)
            #if ip1 is empty, do nothing
        for tvid in list(set(node_vertices.keys()) - set(mod_node)):
            logger.debug('#suppression de tvid: %s' % tvid)
            del_vertex(node_vertices[tvid])
        return 'Node modified'

class ModTmplEdge(SavePage):
    def render_page(self, request):
        tmpl_edge = self.get_data_from_request(request=request, arg='id', object_type='tmpl_edge')
        name = self.get_data_from_request(request=request, arg='name')
        tmpl_vertex1 = self.get_data_from_request(request=request, arg='tmplvertex1', object_type='tmpl_vertex')
        tmpl_vertex2 = self.get_data_from_request(request=request, arg='tmplvertex2', object_type='tmpl_vertex')

        tmpl_edge.mod_name(name)
        tmpl_edge.mod_tmpl_vertex1(tmpl_vertex1)
        tmpl_edge.mod_tmpl_vertex2(tmpl_vertex2)
        return 'TmplEdge modified'

class ModTmplVertex(SavePage):
    def render_page(self, request):
        tmpl_vertex = self.get_data_from_request(request=request, arg='tmpl_vertex_id', object_type='tmpl_vertex')
        name = self.get_data_from_request(request=request, arg='name')
        tmpl_node = self.get_data_from_request(request=request, arg='id', object_type='tmpl_node')
        mimetype = self.get_data_from_request(request=request, arg='mimetype')
        zephir_module = self.get_data_from_request(request=request, arg='moduleid')
        zephir_var_ip1 = self.get_data_from_request(request=request, arg='ip1')
        zephir_var_ip2 = self.get_data_from_request(request=request, arg='ip2', required = False)

        tmpl_vertex.mod_name(name)
        tmpl_vertex.mod_mimetype(mimetype)
        tmpl_vertex.mod_zephir(zephir_module, zephir_var_ip1, zephir_var_ip2)

        return 'TmplVertex modified'

class ModConnect(SavePage):
    @trace()
    def render_page(self, request):
        connect = self.get_data_from_request(request=request, arg='connect_id', object_type='connect')
        tail_node = self.get_data_from_request(request=request, arg='node1', object_type='node')
        head_node = self.get_data_from_request(request=request, arg='node2', object_type='node')
        tail_cred = self.get_data_from_request(request=request, arg='cred1', object_type='credential')
        head_cred = self.get_data_from_request(request=request, arg='cred2', object_type='credential')
        leftsendcert = self.get_data_from_request(request=request, arg='leftsendcert')
        fragmentation = self.get_data_from_request(request=request, arg='fragmentation')
        if tail_node.tmpl_node.mimetype == 'roadwarrior':
            tail_extr = None
        else:
            tail_extr = self.get_data_from_request(request=request, arg='extr1', object_type='extremity')
        if head_node.tmpl_node.mimetype == 'roadwarrior':
            head_extr = None
        else:
            head_extr = self.get_data_from_request(request=request, arg='extr2', object_type='extremity')
        if tail_node.tmpl_node.mimetype == 'roadwarrior' or head_node.tmpl_node.mimetype == 'roadwarrior':
            rw_dns = self.get_data_from_request(request=request, arg='rw_dns')
        else:
            rw_dns = None
        edges = self.get_data_from_request(request=request, arg='edges', load_json=True)


        if tail_node.tmpl_node.mimetype == 'roadwarrior':
            tail_extr = None
        else:
            tail_extr = self.get_data_from_request(request=request, arg='extr1', object_type='extremity')
        if head_node.tmpl_node.mimetype == 'roadwarrior':
            head_extr = None
        else:
            head_extr = self.get_data_from_request(request=request, arg='extr2', object_type='extremity')
        if tail_node.tmpl_node.mimetype == 'roadwarrior' or head_node.tmpl_node.mimetype == 'roadwarrior':
            rw_dns = self.get_data_from_request(request=request, arg='rw_dns')
        else:
            rw_dns = None

        if connect.tail_node == tail_node:
            connect.mod_tail_extr(tail_extr)
            connect.mod_head_extr(head_extr)
            connect.mod_tail_cred(tail_cred)
            connect.mod_head_cred(head_cred)
        else:
            connect.mod_tail_extr(head_extr)
            connect.mod_head_extr(tail_extr)
            connect.mod_tail_cred(head_cred)
            connect.mod_head_cred(tail_cred)
        connect.leftsendcert = leftsendcert
        connect.fragmentation = fragmentation
        connect.rw_dns = rw_dns

        current_edges = {}
        for edge in connect.edges:
            current_edges[edge.tmpl_edge.id] = edge
        current_tmpledges_id = list(current_edges.keys())
        for tmpledgeid, activated in edges.items():
            if activated:
                #if activated and not in current connect, add it
                if tmpledgeid not in current_tmpledges_id:
                    tmpl_edge = get_object_by_id(tmpledgeid, 'tmpl_edge')
                    tmpl_edge.add_edge(connect)
            else:
                #if not activated and in current connect, remove it
                if tmpledgeid in current_tmpledges_id:
                    connect.edges.pop(current_edges[tmpledgeid])
        #remove edges in current connect not in new connect
        for extra_id in list(set(current_tmpledges_id) - set(edges.keys())):
            connect.edges.remove(current_edges[extra_id])
            current_edges[extra_id].delete()

        return 'Connect modified'

class ModKeys(SavePage):
    @trace()
    def render_page(self, request):
        cred = self.get_data_from_request(request=request, arg='cred_id',
                object_type='credential')
        private_key = self.get_data_from_request(request=request,
                arg='private_key', required=False)
        public_key = self.get_data_from_request(request=request,
                arg='public_key')
        password = self.get_data_from_request(request=request,
                arg='password')
        cred.mod_keys(public_key, password, private_key)

class ModKeysPKCS12(SavePage):
    def render_page(self, request):
        cred = self.get_data_from_request(request=request, arg='cred_id',
                object_type='credential')
        pkcs12_certificate = self.get_data_from_request(request=request, arg='pkcs12_file')
        pkcs12_password = self.get_data_from_request(request=request, arg='pkcs12_password', required=True)
        key_passphrase = self.get_data_from_request(request=request, arg='key_passphrase', required=True)
        private_key, pkcs7_certificate = split_pkcs12(pkcs12_certificate, pkcs12_password, key_passphrase)
        ca, new_cert = split_pkcs7(pkcs7_certificate)
        cred.mod_keys(new_cert, key_passphrase, private_key)

class ModCA(SavePage):
    @trace()
    def render_page(self, request):
        cred = self.get_data_from_request(request=request, arg='cred_id',
                object_type='credential')
        credential = self.get_data_from_request(request=request,
                arg='credential')
        cred.mod_ca(credential)
# ____________________________________________________________
# del pages

class DelTmplConnect(SavePage):
    def render_page(self, request):
        tmpl_connect = self.get_data_from_request(request=request,
                arg='deleteid', object_type='tmpl_connect')
        del_tmpl_connect(tmpl_connect)

        return ''

class DelTmplNode(SavePage):
    def render_page(self, request):
        tmpl_node = self.get_data_from_request(request=request, arg='deleteid',
                object_type='tmpl_node')
        del_tmpl_node(tmpl_node)

        return ''

class DelTmplEdge(SavePage):
    def render_page(self, request):
        tmpl_edge = self.get_data_from_request(request=request, arg='deleteid',
                object_type='tmpl_edge')
        del_tmpl_edge(tmpl_edge)

        return ''

class DelTmplVertex(SavePage):
    def render_page(self, request):
        tmpl_vertex = self.get_data_from_request(request=request, arg='deleteid', object_type='tmpl_vertex')
        del_tmpl_vertex(tmpl_vertex)

        return ''

class DelNode(SavePage):
    def render_page(self, request):
        node = self.get_data_from_request(request=request, arg='deleteid', object_type='node')
        del_node(node)
        return 'Node deleted'

class DelEdge(SavePage):
    def render_page(self, request):
        obj = self.get_data_from_request(request=request, arg='deleteid', object_type='edge')
        connect = obj.connect
        del_conn = False
        if connect.edges == [obj]:
            del_conn = True
        del_edge(obj)
        if del_conn:
            del_connect(connect)
            return 'Edge and connect deleted'
        return 'Edge deleted'

class DelConnect(SavePage):
    def render_page(self, request):
        connect = self.get_data_from_request(request=request, arg='deleteid', object_type='connect')
        for edge in connect.edges:
            del_edge(edge)
        del_connect(connect)
        return 'Connect deleted'

class DelCred(SavePage):
    def render_page(self, request):
        obj = self.get_data_from_request(request=request, arg='deleteid', object_type='credential')
        del_cred(obj)
        return 'Credential deleted'

class DelExtrIP(SavePage):
    def render_page(self, request):
        obj = self.get_data_from_request(request=request, arg='deleteid', object_type='extremity')
        del_extremity(obj)
        return 'Extremity deleted'

class ModExtrIP(SavePage):
    def render_page(self, request):
        extremity = self.get_data_from_request(request=request, arg='id', object_type='extremity')
        pub_ip = request.args[b'pub_ip'][0].decode()
        priv_ip = request.args[b'priv_ip'][0].decode()
        pub_ip = valid(pub_ip, 'ip')
        if priv_ip == "":
            priv_ip = None
        else:
            priv_ip = valid(priv_ip, 'ip')
        extremity.pub_ip = pub_ip
        extremity.priv_ip = priv_ip
        return 'Extremity modified'

# ____________________________________________________________
# get pages
class GetNodes(Page):
    @trace()
    def render_page(self, request):
        ret = []
        connected = self.get_data_from_request(request=request, arg='connected', required=False)
        if connected == b'true':
            rvp_node1 = self.get_data_from_request(request=request, arg='id', object_type='node')
            nodes = get_connected_nodes(rvp_node1)
        else:
            rvp_node1 = self.get_data_from_request(request=request, arg='id', object_type='node', required=False)
            nodes = get_nodes(rvp_node1)
        for node in nodes:
            ret.append({'uai': node.uai, 'node': node.name, 'id': node.id, 'mimetype': node.tmpl_node.mimetype})
        return ret

class GetNodesState(Page):
    @trace()
    def render_page(self, request):
        ret = []
        nodes = get_nodes()
        if isfile('/tmp/tunnels_status.txt'):
            try:
                tunnels_status = open('/tmp/tunnels_status.txt', "r")
                tunnels = tunnels_status.readline()
                tunnels = ast.literal_eval(str(tunnels))
                total = int(tunnels_status.readline())
                up = int(tunnels_status.readline())
                down = int(tunnels_status.readline())
            except:
                tunnels = []
                total = 0
                up = 0
                down = 0
        else:
            tunnels = []
            total = 0
            up = 0
            down = 0

        tmpl_nodes = get_tmpl_nodes('sphynx')
        current_node = [] if tmpl_nodes[0].nodes == [] else tmpl_nodes[0].nodes[0]
        for node in nodes:
            if node == current_node:
                state = ""
                ret.append({
                    'node': node.name,
                    'id': node.id,
                    'id_zephir': node.id_zephir,
                    'eole_version':node.eole_version,
                    'mimetype': node.tmpl_node.mimetype,
                    'state': state,
                    'uai': node.uai
                })
                continue
            state = 'Pb de tunnels ou non configuré'
            node_name = node.name.decode() if isinstance(node.name, bytes) else node.name
            for tunnel in tunnels:
                if tunnel['child_name'] == '':
                    bad_child = 0
                    ip_dst = tunnel['dst'].split('-')[0].strip()
                    ip_src = tunnel['src'].split('-')[0].strip()
                    ip_in_extrimities = False
                    if ip_dst == "%any" or \
                       ip_src == "%any":
                        ip_in_extrimities = True
                    else:
                        for extremity in node.extremities:
                            if valid(ip_dst, 'ip') == extremity.pub_ip or \
                               valid(ip_dst, 'ip') == extremity.priv_ip:
                                ip_in_extrimities = True
                                break
                            elif valid(ip_src, 'ip') == extremity.pub_ip or \
                                 valid(ip_dst, 'ip') == extremity.priv_ip:
                                ip_in_extrimities = True
                                break
                    if node_name in tunnel['peer_name'] and ip_in_extrimities:
                        if tunnel['status'] == 'On':
                            state = 'Connexion OK'
                        else:
                            state = 'Problème de connexion'
                if node_name in tunnel['peer_name'] and tunnel['child_name'] != '':
                    if tunnel['status'] == 'Off' and bad_child == 0:
                        state += ' - Problème de tunnel(s)'
                        bad_child +=1

            ret.append({
                'node': node.name,
                'id': node.id,
                'id_zephir': node.id_zephir,
                'eole_version':node.eole_version,
                'mimetype': node.tmpl_node.mimetype,
                'state': state,
                'uai': node.uai
            })
        return ret

class GetEdges(Page):
    def render_page(self, request):
        ret = []
        rvp_node1 = self.get_data_from_request(request=request, arg='nodea', object_type='node')
        rvp_node2 = self.get_data_from_request(request=request, arg='nodeb', object_type='node')
        logger.debug("Column 1 node : {0}".format(str(rvp_node1.name)))
        logger.debug("Column 2 node : {0}".format(str(rvp_node2.name)))
        for connect in get_connects(rvp_node1, rvp_node2):
            if connect.edges == []:
                ret.append({'connect': connect.tmpl_connect.name})
            else:
                # Flag for the ordering network view into a tunnel
                reverse_view = False
                connect_infos = connect.tmpl_connect.name
                if connect.head_extr is not None:
                    if connect.head_extr.node == rvp_node1:
                        # Selected head node in column 1
                        logger.debug("Ordered view, head node : {0}".format(str(rvp_node1.name)))
                        head_extr = connect.head_extr
                        reverse_view = False
                    elif connect.head_extr.node == rvp_node2:
                        # Selected head node in column 2
                        logger.debug("Reverse view, head node : {0}".format(str(rvp_node2.name)))
                        tail_extr = connect.head_extr
                        reverse_view = True
                else:
                    # Roadwarrior extr
                    if rvp_node1.tmpl_node.mimetype == "roadwarrior":
                        tail_extr = connect.tail_extr
                        head_extr = connect.head_extr
                        reverse_view = False
                    elif rvp_node2.tmpl_node.mimetype == "roadwarrior":
                        tail_extr = connect.head_extr
                        head_extr = connect.tail_extr
                        reverse_view = True
                if connect.tail_extr is not None:
                    if connect.tail_extr.node == rvp_node1:
                        # Selected tail node in column 1
                        logger.debug("Reverse view, tail node : {0}".format(str(rvp_node1.name)))
                        head_extr = connect.tail_extr
                        reverse_view = True
                    elif connect.tail_extr.node == rvp_node2:
                        # Selected tail node in column 2
                        logger.debug("Ordered view, tail node : {0}".format(str(rvp_node2.name)))
                        tail_extr = connect.tail_extr
                        reverse_view = False
                    else:
                        raise Exception("One node doesn't have any extremity")
                else:
                    # Roadwarrior extr
                    if rvp_node1.tmpl_node.mimetype == "roadwarrior":
                        tail_extr = connect.head_extr
                        head_extr = connect.tail_extr
                        reverse_view = True
                    elif rvp_node2.tmpl_node.mimetype == "roadwarrior":
                        tail_extr = connect.tail_extr
                        head_extr = connect.head_extr
                        reverse_view = False
                    else:
                        raise Exception("One node doesn't have any extremity")
                # Mapping to the connect info treeview
                if head_extr == None:
                    connect_infos += " - any"
                elif head_extr.pub_ip == head_extr.priv_ip:
                    connect_infos += " - {0}".format(str(head_extr.pub_ip))
                else:
                    connect_infos += " - {0} --> {1}".format(str(head_extr.pub_ip), str(head_extr.priv_ip))
                if tail_extr == None:
                    connect_infos += " ... any"
                elif tail_extr.pub_ip == tail_extr.priv_ip:
                    connect_infos += " ... {0}".format(str(tail_extr.pub_ip))
                else:
                    connect_infos += " ... {0} <-- {1}".format(str(tail_extr.priv_ip), str(tail_extr.pub_ip))
                leftsendcert = connect.leftsendcert.decode().upper() if isinstance(connect.leftsendcert, bytes) else connect.leftsendcert.upper()
                fragmentation= connect.fragmentation.decode() if isinstance(connect.fragmentation, bytes) else connect.fragmentation
                connect_infos += " / " + " certificate send : " + leftsendcert + " via ipsec protocol"
                connect_infos += " / " + " IKE fragmentation : " + fragmentation
                # extracts edges for the connect
                for edge in connect.edges:
                    logger.debug("Edge : {0}".format(edge.tmpl_edge.name))
                    if connect.head_node.tmpl_node == connect.tail_node.tmpl_node:
                        if not reverse_view:
                            # Ordering the vertices into columns to be displayed
                            column1_vertex = edge.tmpl_edge.tmpl_vertex_a
                            column2_vertex = edge.tmpl_edge.tmpl_vertex_b
                        else:
                            column1_vertex = edge.tmpl_edge.tmpl_vertex_b
                            column2_vertex = edge.tmpl_edge.tmpl_vertex_a
                    else:
                        if edge.tmpl_edge.tmpl_vertex_a.tmpl_node == rvp_node1.tmpl_node:
                            column1_vertex = edge.tmpl_edge.tmpl_vertex_a
                            column2_vertex = edge.tmpl_edge.tmpl_vertex_b
                        else:
                            column1_vertex = edge.tmpl_edge.tmpl_vertex_b
                            column2_vertex = edge.tmpl_edge.tmpl_vertex_a

                    column1_vertex_infos = column1_vertex.name
                    column2_vertex_infos = column2_vertex.name
                    logger.debug("Column 1 tmplvertex : {0}".format(str(column1_vertex_infos)))
                    logger.debug("Column 2 tmplvertex : {0}".format(str(column2_vertex_infos)))
                    # extracts vertices for column 1
                    for vertex in column1_vertex.vertices:
                        logger.debug("Column 1 vertex loop : {0}".format(str(vertex.tmpl_vertex.name)))
                        if vertex.node == rvp_node1:
                            logger.debug("Match to column 1 node")
                            if vertex.tmpl_vertex.mimetype == 'network':
                                sep = " / "
                            elif vertex.tmpl_vertex.mimetype == 'ip':
                                sep = ""
                            elif vertex.tmpl_vertex.mimetype == 'range':
                                sep = " ... "
                            column1_vertex_infos += " : {0}{1}{2}".format(vertex.ip1, sep, '' if vertex.ip2 is None else vertex.ip2)
                    # extracts vertices for column 2
                    for vertex in column2_vertex.vertices:
                        logger.debug("Column 2 vertex loop : {0}".format(str(vertex.tmpl_vertex.name)))
                        if vertex.node == rvp_node2:
                            logger.debug("Match to column 2 node")
                            if vertex.tmpl_vertex.mimetype == 'network':
                                sep = " / "
                            elif vertex.tmpl_vertex.mimetype == 'ip':
                                sep = ""
                            elif vertex.tmpl_vertex.mimetype == 'range':
                                sep = " ... "
                            column2_vertex_infos += " : {0}{1}{2}".format(vertex.ip1, sep, '' if vertex.ip2 is None else vertex.ip2)
                    ret.append({'edge': edge.tmpl_edge.name, 'id': edge.id,
                            'connect': connect_infos,
                            'vertexa': column1_vertex_infos , 'vertexb': column2_vertex_infos,
                            'activate': False})
        return ret

class GetConnects(Page):
    def render_page(self, request):
        ret = []
        rvp_node1 = self.get_data_from_request(request=request, arg='nodea', object_type='node')
        rvp_node2 = self.get_data_from_request(request=request, arg='nodeb', object_type='node')
        for connect in get_connects(rvp_node1, rvp_node2):
            ret.append({'id': connect.id, 'connect': connect.tmpl_connect.name,
                        'rw_dns': connect.rw_dns,
                        'leftsendcert': connect.leftsendcert,
                        'fragmentation': connect.fragmentation})
        return ret

class GetTmplNodes(Page):
    def render_page(self, request):
        ret = []
        exclude = self.get_data_from_request(request=request, arg='exclude', object_type='tmpl_node', required=False)
        mimetype = self.get_data_from_request(request=request, arg='mimetype', required=False)
        for tmplnode in get_tmpl_nodes(mimetype=mimetype):
            if tmplnode != exclude:
                ret.append({'tmplnode': tmplnode.name, 'id': tmplnode.id, 'mimetype': tmplnode.mimetype})
        return ret

class GetTmplConnects(Page):
    def render_page(self, request):
        ret = []
        node_a = self.get_data_from_request(request=request, arg='node_a_id', object_type='node', required=False)
        if node_a != None:
            node_b = self.get_data_from_request(request=request, arg='node_b_id', object_type='node')
            tmpl_connects = []
            for connect in get_connects(node_a, node_b):
                tmpl_connects.append(connect.tmpl_connect)
            tmpl_node_a = node_a.tmpl_node
            tmpl_node_b = node_b.tmpl_node
        else:
            tmpl_node_a= None
            tmpl_node_b = None
            tmpl_connects = []
        for tmpl_connect in get_tmpl_connects(tmpl_node_a, tmpl_node_b):
            if tmpl_connect not in tmpl_connects:
                ret.append({'tmplconnect': tmpl_connect.name,
                        'id': tmpl_connect.id,
                        'ca_cert': tmpl_connect.cred_auth.name,
                        'tmplnodea': tmpl_connect.tmpl_node_a.name,
                        'tmplnodeaid': tmpl_connect.tmpl_node_a.id,
                        'tmplnodeb': tmpl_connect.tmpl_node_b.name,
                        'tmplnodebid': tmpl_connect.tmpl_node_b.id,
                        'leftsendcert': tmpl_connect.leftsendcert,
                        'fragmentation': tmpl_connect.fragmentation})
        return ret

class GetTmplEdges(Page):
    def render_page(self, request):
        ret = []
        tmpl_connect = self.get_data_from_request(request=request, arg='id', object_type='tmpl_connect', required=False)
        connect = self.get_data_from_request(request=request, arg='connect_id', object_type='connect', required=False)
        tmpl_edges = []
        if connect != None:
            for edge in connect.edges:
               tmpl_edges.append(edge.tmpl_edge)
            if tmpl_connect == None:
                tmpl_connect = connect.tmpl_connect
        for tmpledge in get_tmpl_edges(tmpl_connect):
            rettedge = {'id': tmpledge.id,
                'tmplvertexname': tmpledge.name,
                'tmplvertex1': tmpledge.tmpl_vertex_a.name,
                'tmplvertex1id': tmpledge.tmpl_vertex_a.id,
                'tmplvertex2': tmpledge.tmpl_vertex_b.name,
                'tmplvertex2id': tmpledge.tmpl_vertex_b.id,
            }
            if tmpledge in tmpl_edges:
                rettedge['activate'] = True
            ret.append(rettedge)
        return ret

class GetTmplVertices(Page):
    @trace()
    def render_page(self, request):
        ret = []
        tmpl_node = self.get_data_from_request(request=request, arg='tmplnodeid', object_type='tmpl_node', required=False)
        node = self.get_data_from_request(request=request, arg='nodeid', object_type='node', required=False)
        uai = self.get_data_from_request(request=request, arg='uai', required=False)
        if isinstance(uai, bytes):
            uai = uai.decode()
        name = self.get_data_from_request(request=request, arg='name', required=False)
        if isinstance(name, bytes):
            name = name.decode()
        id_zephir = self.get_data_from_request(request=request, arg='id_zephir', required=False)
        if isinstance(id_zephir, bytes):
            id_zephir = id_zephir.decode()
        if id_zephir == '':
            id_zephir = None
        force_zephir = self.get_data_from_request(request=request, arg='force_zephir', required=False)
        modtmplvertex = self.get_data_from_request(request=request, arg='modtmplvertex', required=False)
        #if None not in [tmpl_node, node] or tmpl_node == node:
        #    raise Exception('Must specified tmpl_node or node')
        if node != None:
            tmpl_node = node.tmpl_node
            tmpl_vertex = {}
            for vertex in node.vertices:
                tmpl_vertex[vertex.tmpl_vertex] = (vertex.ip1, vertex.ip2)
            if id_zephir is None:
                id_zephir = node.id_zephir
        if tmpl_node != None:
            for tmplvertex in get_tmpl_vertices(tmpl_node):
                ip1 = ''
                ip2 = ''
                module = ''
                if isinstance(force_zephir, bytes):
                    force_zephir = force_zephir.decode()
                if node != None and force_zephir != 'true':
                    # Charge les valeurs des vertex d'un node
                    ip1, ip2 = tmpl_vertex.get(tmplvertex, ('', ''))
                else:
                    if uai != None:
                        # Recharge les infos Zéphir et tmplvertex
                        prefs = request.getSession(IPreferences)
                        if prefs.zephir != None:
                            # Si connecté avec user Zéphir
                            if tmplvertex.zephir_module:
                                # Recharge les valeur depuis Zéphir
                                ip1 = prefs.zephir.get_var(
                                        uai=uai,
                                        name=name,
                                        id_zephir=id_zephir,
                                        module=tmplvertex.zephir_module,
                                        var=tmplvertex.zephir_var_ip1
                                )
                                if tmplvertex.mimetype != 'ip':
                                    ip2 = prefs.zephir.get_var(
                                            uai=uai,
                                            name=name,
                                            id_zephir=id_zephir,
                                            module=tmplvertex.zephir_module,
                                            var=tmplvertex.zephir_var_ip2)
                            else:
                                # Recharge les valeur depuis tmplvertex
                                ip1 = tmplvertex.zephir_var_ip1
                                ip2 = tmplvertex.zephir_var_ip2
                        else:
                            # Si connecté avec user system
                            if not tmplvertex.zephir_module:
                                ip1 = tmplvertex.zephir_var_ip1
                                ip2 = tmplvertex.zephir_var_ip2
                    else:
                        #if search tmplVertex attribute
                        module = tmplvertex.zephir_module
                        if modtmplvertex == 'true' or not module:
                            # Si modif tmplvertex
                            # ou si ajout manuel serveur
                            ip1 = tmplvertex.zephir_var_ip1
                            ip2 = tmplvertex.zephir_var_ip2

                    if (ip1, ip2) in [('', ''), (None, None)] and \
                            force_zephir == 'true':
                        #if force_zephir is set and no value from Zéphir
                        ip1, ip2 = tmpl_vertex.get(tmplvertex, ('', ''))

                ret.append({'tmplvertex': tmplvertex.name,
                    'id': tmplvertex.id,
                    'mimetype': tmplvertex.mimetype,
                    'module': module,
                    'ip1': ip1,
                    'ip2': ip2
                })
        else:
            for tmplvertex in get_tmpl_vertices():
                ret.append({'tmplvertexname': tmplvertex.name,
                    'id': tmplvertex.id,
                    'tmplvertexmimetype': tmplvertex.mimetype,
                    'tmplnode': tmplvertex.tmpl_node.name,
                    'tmplnodeid': tmplvertex.tmpl_node.id,
                    'tmplvertexmodule': tmplvertex.zephir_module,
                    'tmplvertexip1': tmplvertex.zephir_var_ip1,
                    'tmplvertexip2': tmplvertex.zephir_var_ip2,
                })

        return ret

class GetCred(Page):
    def render_page(self, request):
        ret = []
        node = self.get_data_from_request(request=request, arg='node', object_type='node')
        connect = self.get_data_from_request(request=request, arg='connect_id', object_type='connect', required=False)
        tmpl_connect = self.get_data_from_request(request=request, arg='tmplconnect_id', object_type='tmpl_connect', required=False)
        if None not in [connect, tmpl_connect]:
            raise Exception('Must specified tmpl_connect or connect')
        connect_cred = None
        cred_auth = None
        if connect != None:
            if node == connect.tail_node:
                connect_cred = connect.tail_cred.id
            elif node == connect.head_node:
                connect_cred = connect.head_cred.id
            else:
                raise Exception('Node is not in connect')
            cred_auth = connect.tmpl_connect.cred_auth
        if tmpl_connect != None:
            cred_auth = tmpl_connect.cred_auth

        for cred in node.get_credentials(cred_auth):
            retcred = {'id':cred.id, 'cred':cred.name}
            if retcred['id'] == connect_cred:
                retcred['selected'] = True
            ret.append(retcred)
        return ret

class GetCredAuth(Page):
    def render_page(self, request):
        ret = []
        for credauth in get_credentials_auth():
            ret.append({'id':credauth.id, 'credauth':credauth.name})
        return ret

class GetAllCred(Page):
    def render_page(self, request):
        ret = []
        for cred in get_all_credentials():
            today = datetime.now()
            expiration_date = datetime.strptime(cred.expiration_date, '%Y/%m/%d')
            delta = expiration_date - today
            delta = delta.days
            if nearly_expired_cred > delta:
                is_nearly_expired = True
            else:
                is_nearly_expired = False
            if 0 > delta:
                is_expired = True
            else:
                is_expired = False
            related_node_name = ""
            related_node = cred.node
            if related_node:
                uai = related_node.uai if isinstance(related_node.uai, str) else ""
                name = related_node.name if isinstance(related_node.name, str) else ""
                related_node_name = uai + " - " + name
            elif not cred.ca:
                related_node_name = "PAS DE SERVEUR RVP ASSOCIÉ !!!"
            issuer = cert.get_issuer_subject(cred.credential)[1]
            ret.append({'id':cred.id, 'name': cred.name,
                'ca': cred.ca, 'expiration_date': cred.expiration_date,
                'delta': delta, 'is_expired': is_expired,
                'is_nearly_expired': is_nearly_expired,
                'node': related_node_name,
                'issuer': issuer})
        sorted(ret, key=lambda key: key['delta'])
        return ret

class GetExtr(Page):
    def render_page(self, request):
        ret = []
        node = self.get_data_from_request(request=request, arg='node',
                object_type='node', required=False)
        connect = self.get_data_from_request(request=request, arg='connect_id',
                object_type='connect', required=False)
        extrip = self.get_data_from_request(request=request, arg='extrip',
                object_type="extremity", required=False)
        new = self.get_data_from_request(request=request, arg='new',
                required=False)
        if not None in [node, extrip] or node == extrip == None:
            raise Exception('il faut obligatoirement un node ou une extremity mais jamais les deux')
        if extrip:
            return {'id': extrip.id, 'pub_ip': extrip.pub_ip, 'priv_ip': extrip.priv_ip}
        else:
            if new == b'true':
                ret = {'pub_ip': '', 'priv_ip': ''}
                if usezephir == True:
                    prefs = request.getSession(IPreferences)
                    if prefs.zephir != None:
                        try:
                            haute_dispo = prefs.zephir.get_var(
                                    uai=node.uai,
                                    name=node.name,
                                    id_zephir=node.id_zephir,
                                    var='activer_haute_dispo')
                            if haute_dispo == "maitre":
                                vips_name = prefs.zephir.get_var(
                                    uai=node.uai,
                                    name=node.name,
                                    id_zephir=node.id_zephir,
                                    var="vip_resource_name").split('| ')
                                vips_adresseip = prefs.zephir.get_var(
                                    uai=node.uai,
                                    name=node.name,
                                    id_zephir=node.id_zephir,
                                    var="vip_resource_adresseip").split('| ')
                                try:
                                    index = vips_name.index('VIP_externe')
                                    ip = vips_adresseip[index]
                                except:
                                    logger.debug("VIP_externe resource name does not exist")
                                    raise Exception("VIP_externe resource name does not exist")
                            elif haute_dispo == "non":
                                logger.debug("Pas de haute dispo")
                                ip = prefs.zephir.get_var(
                                    uai=node.uai,
                                    name=node.name,
                                    id_zephir=node.id_zephir,
                                    var='adresse_ip_eth0')
                            else:
                                logger.debug("Pas de variable haute_dispo")
                                ip = prefs.zephir.get_var(
                                    uai=node.uai,
                                    name=node.name,
                                    id_zephir=node.id_zephir,
                                    var='adresse_ip_eth0')
                            logger.debug("Adresse IP : " + ip)
                        except:
                            ip = None
                            logger.debug("No value found from Zéphir")
                        if ip != None:
                            iptype = IP(ip).iptype()
                        else:
                            iptype = None
                        if iptype == 'PRIVATE':
                            ret['priv_ip'] = ip
                        elif iptype == 'PUBLIC':
                            ret['pub_ip'] = ip
            else:
                connect_extr = None
                if connect != None:
                    if node.tmpl_node.mimetype != "roadwarrior":
                        if node == connect.tail_node:
                                connect_extr = connect.tail_extr.id
                        elif node == connect.head_node:
                            connect_extr = connect.head_extr.id
                        else:
                            raise Exception('Node is not in connect')
                for extr in node.get_extremities():
                    retextr = {'id': extr.id, 'extr': extr.pub_ip}
                    if connect_extr != None:
                        if retextr['id'] == connect_extr:
                            retextr['selected'] = True
                    ret.append(retextr)
            return ret

class GetZephirEtabs(Page):
    @trace()
    def render_page(self, request):
        ret = []
        if usezephir == True:
            prefs = request.getSession(IPreferences)
            if prefs.zephir != None:
                # locals Amon and Sphynx
                aetab = prefs.zephir.get_amons()
                aetab.extend(prefs.zephir.get_sphynxs())
                logger.debug("#GetZephirEtabs: {0}".format(aetab))
                # All ID Zéphir
                zid_zephir = [(id_zephir) for libelle, uai, id_zephir, eole_version, mimetype in aetab]
                # All ID Zéphir manage locally
                lid_zephir = [(id_zephir) for libelle, uai, id_zephir, eole_version, mimetyoe in get_etabs()]
                # All ID Zéphir not manage locally
                search_ids = list(set(zid_zephir) - set(lid_zephir))

                keyword = ('libelle', 'uai', 'id_zephir', 'eole_version', 'mimetype')
                #return only id_zephir not already exists
                for etab in aetab:
                    if etab[2] in search_ids:
                        ret.append(dict(list(zip(keyword, etab))))
        return ret

class GetZephirModules(Page):
    def render_page(self, request):
        ret = []
        if usezephir == True:
            prefs = request.getSession(IPreferences)
            if prefs.zephir != None:
                 ret = prefs.zephir.get_modules()
        #Insert empty field
        ret.insert(0, {'name': None, 'id': None})
        return ret

class GetZephirVariables(Page):
    def render_page(self, request):
        module = self.get_data_from_request(request=request, arg='module')
        if module == '':
            return []
        module = int(module)
        ret = []
        if usezephir == True:
            prefs = request.getSession(IPreferences)
            if prefs.zephir != None:
                ret = prefs.zephir.get_variables(module)
        return ret

class SynchroARVZephir(SavePage):
    def render_page(self, request):
        ret = []
        if usezephir == True:
            node = self.get_data_from_request(request=request, arg='node',
                    object_type='node')
            prefs = request.getSession(IPreferences)
            if prefs.zephir != None:
                uai = node.uai
                name = node.name
                id_zephir = node.id_zephir
                server = prefs.zephir.get_etab_server(uai, name, id_zephir)
                logger.debug(str(server))
                if server:
                    if id_zephir is not None:
                        logger.debug("Update uai and name from Zéphir")
                        libelle = server['libelle']
                        module_eole_version = prefs.zephir.dict_eole_version(amon_module_list + sphynx_module_list)
                        node.eole_version = module_eole_version[server['module_actuel']]
                        node.uai = server['rne']
                        node.name = libelle
                    else:
                        logger.debug("Fill id_zephir and eole_version")
                        node.id_zephir = int(server['id'])
                        module_eole_version = prefs.zephir.dict_eole_version(amon_module_list + sphynx_module_list)
                        node.eole_version = module_eole_version[server['module_actuel']]
                else:
                    logger.debug("Node does not exist in Zéphir")
        else:
            logger.debug("No Zéphir connection")
        return "Node modified"

class SendDb(Page):
    def render_page(self, request):
        node = self.get_data_from_request(request=request, arg='node',
                object_type='node')
        if usezephir == True:
            prefs = request.getSession(IPreferences)
            if prefs.zephir != None:
                uai = node.uai
                name = node.name
                id_zephir = node.id_zephir
                amonpath, archivename = gen_archive_name(uai, name)
                archive = join(amonpath, archivename)
                prefs.zephir.send_db(archive, uai, name, id_zephir)
                return "Resended"

        return Exception('Not loggin to Zephir')

