/*
 *
 *
 */

Ext.namespace("ARV");

ARV.addnode2 = (function() {
    /*
     * Public
     */
    var connectstore = new Ext.data.Store({
        reader: new Ext.data.JsonReader({
            root :'data',
            successProperty: 'success',
        },[
            {name : 'connect'},
            {name : 'id'},
            {name : 'leftsendcert'},
            {name : 'fragmentation'},
            {name : 'rw_dns'},
        ]),
        url: 'arv/get_connects',
    });
    var connect_grid = new ARV.GridPanel({
        store: connectstore,
        columns: [
            {header: Ext.i18n.connect_window, sortable: true, dataIndex: 'connect'},
            {header: 'ID', sortable: true, dataIndex: 'id', hidden: true},
            {header: 'leftsendcert', sortable: true, dataIndex: 'leftsendcert', hidden: true},
            {header: 'fragmentation', sortable: true, dataIndex: 'fragmentation', hidden: true},
            {header: 'rw_dns', sortable: true, dataIndex: 'rw_dns', hidden: true}
        ],
        deleteUrl: 'arv/del_connect',
        btnAddEvent: 'addmodconnect',
        btnModEvent: 'modifconnect',
        btnDelEvent: 'changemodconnect'
    });

    var connectwin = new ARV.PopupWindow({
        title: Ext.i18n.connect_window,
        items: [connect_grid],
        bbar: ['->', {
            text: Ext.i18n.exit,
            handler: function(){
                ARV.observable.fireEvent('treenode1changed');
                connectwin.hide()
            }
        }]
    });

    return {
        openWindow: function(node_a_id, node_a_name, node_a_mimetype, node_b_id, node_b_name, node_b_mimetype, connect_id, leftsendcert, fragmentation, rw_dns){
            var create_extrwindow = function(id) {
                form = {
                    xtype: 'form',
                    id: 'extremity_form',
                    bbar: [{
                        text: Ext.i18n.save,
                        handler: function(btn, ev) {
                            Ext.getCmp('extremity_form').getForm().submit({
                                url: 'arv/add_extremity',
                                params: {id: id},
                                //waitMsg: Ext.i18n.dialog_submit,
                                success: function(){
                                    winaddextremity.destroy();
                                }
                            });
                        },
                        scope: this
                    }, '-', {
                        text: Ext.i18n.cancel,
                        handler: function(btn, ev) {
                            winaddextremity.destroy();
                        },
                        scope: this
                    }],
                    items: [{
                        xtype: "textfield",
                        fieldLabel: Ext.i18n.addextremity_pub_ip,
                        width: 150,
                        name: 'pub_ip',
                        allowBlank:false
                    },{
                        xtype: "textfield",
                        fieldLabel: Ext.i18n.addextremity_priv_ip,
                        width: 150,
                        name: 'priv_ip',
                    }],
                };
                var winaddextremity = new ARV.PopupWindow({
                    title: Ext.i18n.addnode2_title,
                    items: [form]
                }).show();
            };

            var nodes_store = new Ext.data.Store({
                reader: new Ext.data.JsonReader({
                    root: 'data',
                    successProperty: 'success',
                },[
                    {name : 'id'},
                    {name : 'uai'},
                    {name : 'node'},
                    {name : 'mimetype'}
                ]),
                url: 'arv/get_nodes'
            });

            var edges_store = new Ext.data.Store({
                reader: new Ext.data.JsonReader({
                    root: 'data',
                    successProperty: 'success',
                },[
                    {name : 'id'},
                    {name : 'tmplvertex1'},
                    {name : 'tmplvertex2'},
                    {name : 'activate'},
                ]),
                url: 'arv/get_tmpl_edges'
            });

            Ext.apply(Ext.form.VTypes, {
                IPAddress:  function(v) {
                    return /^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/.test(v);
                },
                IPAddressText: 'Must be a numeric IP address',
                IPAddressMask: /[\d\.]/i
            });

            var ipeditor = new Ext.grid.GridEditor(
                new Ext.form.TextField({vtype: 'IPAddress'}), {}
            );

            var activate_edges_column = new Ext.grid.CheckboxColumn({
                header: '<div class="x-grid3-hd-checker">&#160;</div>',
                dataIndex: 'activate',
                width:40
            });

            var leftsendcert_choice = new Ext.data.ArrayStore({
                fields: ['id', 'leftsendcertval'],
                data: [['always', Ext.i18n.leftsendcert_always2], ['never', Ext.i18n.leftsendcert_never2]]
            });

            var fragmentation_choice = new Ext.data.ArrayStore({
                fields: ['idfrag', 'fragmentationval'],
                data: [['no', Ext.i18n.no_msg], ['yes', Ext.i18n.yes_msg]]
            });

            var filter_grid = new Ext.ux.grid.GridFilters({
                // encode and local configuration options defined previously for easier reuse
                // encode: encode, // json encode the filter query
                local: true,   // defaults to false (remote filtering)
                filters: [{
                    type: 'string',
                    dataIndex: 'uai',
                }, {
                    type: 'string',
                    dataIndex: 'node',
                }]
            });

            var cardcontent = [{
                // Choisir un serveur RVP
                id: 'card-0',
                xtype: 'grid',
                border: true,
                layout: 'fit',
                plugins: filter_grid,
                store: nodes_store,
                colModel: new Ext.grid.ColumnModel({
                    columns: [
                        {header: 'id', sortable: true, dataIndex: 'id', hidden: true},
                        {id: 'uai', header: Ext.i18n.uai, sortable: true, dataIndex: 'uai', width: '100px'},
                        {id: 'node', header: Ext.i18n.node, sortable: true, dataIndex: 'node', width: '300px'},
                        {id: 'mimetype', sortable: true, dataIndex: 'mimetype', hidden: true},
                    ],
                    defaults: {
                        sortable: true,
                    },
                    plugins: filter_grid
                }),
                //singleSelect
                sm: new Ext.grid.RowSelectionModel({
                    singleSelect:true,
                }),
                enableColumnHide: false,
            },{
                // Choisir un modèle de lien sécurisé
                id: 'card-1',
                xtype: 'form',
                items: [{
                    xtype: "arvcombo",
                    id: 'tmplconnect',
                    fieldLabel: Ext.i18n.addnode2_tmplconnect,
                    record: [
                        {name : 'tmplconnect'},
                        {name : 'id'},
                        {name : 'leftsendcert'},
                        {name : 'fragmentation'},
                        {name : 'rw_dns'},
                    ],
                    url: 'arv/get_tmpl_connects',
                    autoLoad: false,
                    displayField: 'tmplconnect',
                    listen: {
                        'load': function(store, records, option){
                            if (records.length != 0) {
                                Ext.getCmp('tmplconnect').setValue(records[0].get('id'));
                            }
                        }
                    }
                }]
             }, {
                // Renseignement certificats et IP externes
                id: 'card-2',
                border: false,
                xtype: 'form',
                flex: 1,
                items: [{
                    xtype: 'label',
                    html: '<b>'+node_a_name+'</b>',
                },{
                    layout: 'column',
                    border: false,
                    items:[{
                        columnWidth: .9,
                        layout: 'form',
                        border: false,
                        items: [{
                            xtype: "arvcombo",
                            id: 'cred1',
                            fieldLabel: Ext.i18n.addnode2_cred,
                            record: [
                                {name : 'id'},
                                {name : 'cred'},
                                {name : 'selected'}
                            ],
                            url: 'arv/get_cred',
                            autoLoad: false,
                            displayField: 'cred',
                            listen: {
                                'load': function(store, records, option){
                                    if (records.length != 0) {
                                        id_value = 0;
                                        for (var i = 0; i < records.length; i++) {
                                            if (records[i].get('selected') == true) {
                                                id_value = i;
                                            }
                                        };
                                        Ext.getCmp('cred1').setValue(records[id_value].get('id'));
                                    } else {
                                        Ext.getCmp('cred1').setValue('');
                                    };
                                }
                            },
                            anchor: '95%'
                        }]
                    }, {
                        columnWidth: .1,
                        layout: 'form',
                        items: [{
                            xtype: 'button',
                            text: Ext.i18n.addnode2_choice_button,
                            anchor:'95%',
                            handler: function () {
                                ARV.modcred.openCredWindow(node_a_id, Ext.getCmp('cred1').store, Ext.getCmp('tmplconnect').getValue());
                            }
                        }]
                    }]
                }, {
                    layout:'column',
                    border: false,
                    items:[{
                        columnWidth:.9,
                        border: false,
                        layout: 'form',
                        items: [{
                            xtype: "arvcombo",
                            id: 'extr1',
                            fieldLabel: Ext.i18n.addnode2_extr,
                            record: [
                                {name : 'id'},
                                {name : 'extr'},
                                {name : 'selected'}
                            ],
                            url: 'arv/get_extr',
                            autoLoad: false,
                            displayField: 'extr',
                            listen: {
                                'load': function(store, records, option){
                                    if (records.length != 0) {
                                        id_value = 0;
                                        for (var i = 0; i < records.length; i++) {
                                            if (records[i].get('selected') == true) {
                                                id_value = i;
                                            }
                                        };
                                        Ext.getCmp('extr1').setValue(records[id_value].get('id'));
                                    }
                                }
                            },
                            anchor: '95%'
                        }]
                    }, {
                        columnWidth:.1,
                        border: false,
                        layout: 'form',
                        items: [{
                            xtype: 'button',
                            id: 'add_extr1',
                            text: Ext.i18n.addnode2_choice_button,
                            anchor:'95%',
                            handler: function () {
                                ARV.modextip.openIPWindow(
                                    node_a_id,
                                    'extrip_node2_changed'
                                );
                            }
                        }]
                    }]
                }, {
                    xtype: 'label',
                    border: false,
                    id: 'node2_label'
                },{
                    layout:'column',
                    border: false,
                    items:[{
                        columnWidth:.9,
                        border: false,
                        layout: 'form',
                        items: [{
                            xtype: "arvcombo",
                            id: 'cred2',
                            fieldLabel: Ext.i18n.addnode2_cred,
                            record: [
                                {name : 'id'},
                                {name : 'cred'},
                                {name : 'selected'}
                            ],
                            url: 'arv/get_cred',
                            autoLoad: false,
                            displayField: 'cred',
                            listen: {
                                'load': function(store, records, option){
                                    if (records.length != 0) {
                                        id_value = 0;
                                        for (var i = 0; i < records.length; i++) {
                                            if (records[i].get('selected') == true) {
                                                id_value = i;
                                            }
                                        };
                                        Ext.getCmp('cred2').setValue(records[id_value].get('id'));
                                    } else {
                                        Ext.getCmp('cred2').setValue('');
                                    };
                                }
                            },
                            anchor: '95%'
                        }]
                    }, {
                        columnWidth: .1,
                        border: false,
                        layout: 'form',
                        items: [{
                            xtype: 'button',
                            text: Ext.i18n.addnode2_choice_button,
                            anchor:'95%',
                            handler: function () {
                                ARV.modcred.openCredWindow(node2id, Ext.getCmp('cred2').store, Ext.getCmp('tmplconnect').getValue());
                            }
                        }]
                    }]
                }, {
                    layout:'column',
                    border: false,
                    items:[{
                        columnWidth:.9,
                        border: false,
                        layout: 'form',
                        items: [{
                            xtype: "arvcombo",
                            id: 'extr2',
                            fieldLabel: Ext.i18n.addnode2_extr,
                            record: [
                                {name : 'id'},
                                {name : 'extr'},
                                {name : 'selected'}
                            ],
                            url: 'arv/get_extr',
                            autoLoad: false,
                            displayField: 'extr',
                            listen: {
                                'load': function(store, records, option){
                                    if (records.length != 0) {
                                        id_value = 0;
                                        for (var i = 0; i < records.length; i++) {
                                            if (records[i].get('selected') == true) {
                                                id_value = i;
                                            }
                                        };
                                        Ext.getCmp('extr2').setValue(records[id_value].get('id'));
                                    }
                                }
                            },
                            anchor: '95%'
                        }]
                    }, {
                        columnWidth:.1,
                        border: false,
                        layout: 'form',
                        items: [{
                            xtype: 'button',
                            id: 'add_extr2',
                            text: Ext.i18n.addnode2_choice_button,
                            anchor:'95%',
                            handler: function () {
                                if (node_b_id == null) {
                                    node2 = Ext.getCmp('card-0');
                                    node2id = node2.getSelectionModel().getSelected().get('id');
                                    node2mimetype = node2.getSelectionModel().getSelected().get('mimetype');
                                } else {
                                    node2id = node_b_id;
                                    node2mimetype = node_b_mimetype;
                                }
                                ARV.modextip.openIPWindow(
                                    node2id,
                                    'extrip_node2_changed'
                                );
                            }
                        }]
                    }]
                }, {
                    border: false,
                    layout: 'form',
                    items: [{
                        xtype: 'combo',
                        name: 'leftsendcert',
                        id: 'leftsendcert_combo_connect',
                        fieldLabel: Ext.i18n.leftsendcert,
                        store: leftsendcert_choice,
                        displayField: 'leftsendcertval',
                        width: 226,
                        editable: false,
                        mode: 'local',
                        value: leftsendcert,
                        hiddenName:'id',
                        valueField: 'id',
                        allowBlank: false,
                        typeAhead: true,
                        selectOnFocus: true,
                        forceSelection: true,
                        triggerAction: 'all',
                    }, {
                        xtype: 'combo',
                        name: 'fragmentation',
                        id: 'fragmentation_combo_connect',
                        fieldLabel: Ext.i18n.fragmentation,
                        store: fragmentation_choice,
                        displayField: 'fragmentationval',
                        width: 226,
                        editable: false,
                        mode: 'local',
                        value: fragmentation,
                        hiddenName:'idfrag',
                        valueField: 'idfrag',
                        allowBlank: false,
                        typeAhead: true,
                        selectOnFocus: true,
                        forceSelection: true,
                        triggerAction: 'all',
                    }]
                }, {
                    border: false,
                    xtype: "textfield",
                    vtype: 'IPAddress',
                    id: "rw_dns",
                    fieldLabel: Ext.i18n.rw_dns,
                    width: 150,
                    name: 'rw_dns',
                    allowBlank: false
                }]
            }, {
                id: 'card-3',
                xtype: 'grid',
                border: true,
                layout: 'fit',
                plugins: activate_edges_column,
                store: edges_store,
                colModel: new Ext.grid.ColumnModel({
                    columns: [
                        {header: 'id', sortable: true, dataIndex: 'id', hidden: true},
                        activate_edges_column,
                        {id: 'tmplvertex1', header: Ext.i18n.tmplvertex1, sortable: true, dataIndex: 'tmplvertex1', width: '200px'},
                        {id: 'tmplvertex2', header: Ext.i18n.tmplvertex2, sortable: true, dataIndex: 'tmplvertex2', width: '200px'},
                    ],
                    defaults: {
                        sortable: true,
                    },
                }),
                //singleSelect
                sm: new Ext.grid.RowSelectionModel({
                    singleSelect:true,
                }),
                enableColumnHide: false,

            }];

            var nbcard = 0;
            var navHandler = function(incr){
                var l = Ext.getCmp('addnode2-wizard-panel').getLayout();
                var i = l.activeItem.id.split('card-')[1];
                console.log('CARD : ' + i);
                console.log('NODE_A MIMETYPE : ' + node_a_mimetype);
                if (i == 0) {
                    node2 = Ext.getCmp('card-0');
                    if (! node2.getSelectionModel().hasSelection()) {
                        error_msg(Ext.i18n.error_select_node)
                        return;
                    };
                    node2id = node2.getSelectionModel().getSelected().get('id');
                    node2mimetype = node2.getSelectionModel().getSelected().get('mimetype');
                    console.log('NODE_B MIMETYPE : ' + node2mimetype);
                };
                var next = parseInt(i) + incr;
                console.log('NEXT : ' + next);
                switch (next) {
                    case 0:
                        //choisir un serveur RVP
                        console.log('CASE 0');
                        Ext.getCmp('button-addnode2').disable();
                    break;
                    case 1:
                        //choisir un modèle de lien sécurisé
                        console.log('CASE 1');
                        Ext.getCmp('button-addnode2').disable();
                        tmplconnect_store = Ext.getCmp('tmplconnect').store;
                        tmplconnect_store.removeAll();
                        tmplconnect_store.baseParams={
                            node_a_id: node_a_id,
                            node_b_id: node2id
                        };
                        tmplconnect_store.load();
                    break;
                    case 2:
                        //Certificats + IPs
                        console.log('CASE 2');
                        Ext.getCmp('button-addnode2').disable();
                        if (connect_id == null) {
                            idtmplconnect = Ext.getCmp('tmplconnect').getValue();
                            console.log('TMPLCONNECT : ' + idtmplconnect);
                            if (idtmplconnect == '') {
                                error_msg(Ext.i18n.field_empty);
                                return;
                            };
                        } else {
                            idtmplconnect = null;
                        };
                        if (node_b_id == null) {
                            node2 = Ext.getCmp('card-0');
                            node2_name = node2.getSelectionModel().getSelected().get('node');
                            node2id = node2.getSelectionModel().getSelected().get('id');
                        } else {
                            node2id = node_b_id;
                            node2_name = node_b_name;
                        }
                        Ext.getCmp('node2_label').setText('<b>'+node2_name+'</b>', false);
                        extr1_store = Ext.getCmp('extr1').store;
                        extr1_store.removeAll();
                        if (connect_id == null) {
                            extr1_store.baseParams={node: node_a_id};
                        } else {
                            extr1_store.baseParams={node: node_a_id, connect_id: connect_id};
                        };
                        extr1_store.load();
                        extr2_store = Ext.getCmp('extr2').store;
                        extr2_store.removeAll();
                        if (connect_id == null) {
                            extr2_store.baseParams={node: node2id};
                        } else {
                            extr2_store.baseParams={node: node_b_id, connect_id: connect_id};
                        }
                        extr2_store.load();
                        //load credential with connect (if modification) or
                        //tmpl_connect (if new connect)
                        cred1_store = Ext.getCmp('cred1').store;
                        cred1_store.removeAll();
                        if (connect_id == null) {
                            cred1_store.baseParams={
                                node: node_a_id,
                                tmplconnect_id: idtmplconnect
                            }
                        } else {
                            cred1_store.baseParams={
                                node: node_a_id,
                                connect_id: connect_id
                            }
                        };
                        cred1_store.load();
                        cred2_store = Ext.getCmp('cred2').store;
                        cred2_store.removeAll();
                        if (connect_id == null) {
                            cred2_store.baseParams={
                                node: node2id,
                                tmplconnect_id: idtmplconnect
                            }
                        } else {
                            cred2_store.baseParams={
                                node: node2id,
                                connect_id: connect_id
                            }
                        };
                        cred2_store.load();
                        if ((node_a_mimetype == 'roadwarrior') || (node2mimetype == 'roadwarrior')) {
                            Ext.getCmp('rw_dns').show();
                            Ext.getCmp('rw_dns').getEl().up('.x-form-item').setDisplayed(true);
                        } else {
                            Ext.getCmp('rw_dns').hide();
                            Ext.getCmp('rw_dns').getEl().up('.x-form-item').setDisplayed(false);
                        };
                        if (node_a_mimetype == 'roadwarrior') {
                            Ext.getCmp('extr1').hide();
                            Ext.getCmp('extr1').getEl().up('.x-form-item').setDisplayed(false);
                            Ext.getCmp('add_extr1').hide();
                        } else {
                            Ext.getCmp('extr1').show();
                            Ext.getCmp('extr1').getEl().up('.x-form-item').setDisplayed(true);
                            Ext.getCmp('add_extr1').show();
                        }
                        if (node2mimetype == 'roadwarrior') {
                            Ext.getCmp('extr2').hide();
                            Ext.getCmp('extr2').getEl().up('.x-form-item').setDisplayed(false);
                            Ext.getCmp('add_extr2').hide();
                        } else {
                            Ext.getCmp('extr2').show();
                            Ext.getCmp('extr2').getEl().up('.x-form-item').setDisplayed(true);
                            Ext.getCmp('add_extr2').show();
                        };
                        if (connect_id == null) {
                            tmplconnect_store = Ext.getCmp('tmplconnect').store;
                            tmplconnect_id = Ext.getCmp('tmplconnect').getValue();
                            tmplconnect_store.each(
                                function (record){
                                    if (record.get('id') == tmplconnect_id) {
                                        leftsendcert = record.get('leftsendcert');
                                        fragmentation = record.get('fragmentation');
                                        if ((node_a_mimetype == 'roadwarrior') || (node2mimetype == 'roadwarrior')) {
                                                rw_dns = record.get('rw_dns');
                                        } else {
                                            rw_dns = null;
                                        };
                                    };
                                }
                            );
                        };
                        Ext.getCmp('leftsendcert_combo_connect').setValue(leftsendcert);
                        Ext.getCmp('fragmentation_combo_connect').setValue(fragmentation);
                        Ext.getCmp('rw_dns').setValue(rw_dns);
                    break;
                    case 3:
                        //modèle de réseau -> modèle de réseau
                        console.log('CASE 3');
                        extr1 = Ext.getCmp('extr1').getValue();
                        extr2 = Ext.getCmp('extr2').getValue();
                        cred1 = Ext.getCmp('cred1').getValue();
                        cred2 = Ext.getCmp('cred2').getValue();
                        if ((cred1 == '') || (cred2 == '')) {
                            //error_msg(Ext.i18n.field_empty);
                            error_msg("cred1 ou cred2 vide");
                            return;
                        };
                        if ((node_a_mimetype != "roadwarrior") && (extr1 == '')) {
                            //error_msg(Ext.i18n.field_empty);
                            error_msg("extr1 vide");
                            return;
                        }
                        if ((node2mimetype != "roadwarrior") && (extr2 == '')) {
                            //error_msg(Ext.i18n.field_empty);
                            error_msg("extr2 vide");
                            return;
                        }
                        if ((node2mimetype == "roadwarrior") || (node_a_mimetype == "roadwarrior")) {
                            rw_dns = Ext.getCmp('rw_dns').getValue();
                            if (rw_dns == '') {
                                //error_msg(Ext.i18n.field_empty);
                                error_msg("DNS pour roadwarrior vide");
                                return;
                            };
                        }
                        Ext.getCmp('button-addnode2').enable();
                        edges_store.removeAll();
                        edges_store.baseParams={}
                        if (idtmplconnect != null) {
                            edges_store.baseParams['id'] = idtmplconnect;
                        };
                        if (connect_id != null) {
                            edges_store.baseParams['connect_id'] = connect_id;
                        };
                        edges_store.load();
                    break;
                };
                l.setActiveItem(next);
                nbcard = next;
                if (node_b_id == null) {
                    // désactive "Précédent" si card-0
                    Ext.getCmp('card-prev').setDisabled((next==0) || (nbcard==0));
                } else {
                    // désactive "Précédent" en cas de modif d'un connect existant
                    Ext.getCmp('card-prev').setDisabled((next==2) && (nbcard==2));
                };
                Ext.getCmp('card-next').setDisabled(next==3);
            };

            if (connect_id == null) {
                //if new connect
                nbcard = 0;
                var wizard_ok_button = {
                    id: 'button-addnode2',
                    text: Ext.i18n.save,
                    disabled: true,
                    handler: function() {
                        if (node_b_id == null) {
                            node2 = Ext.getCmp('card-0');
                            node2id = node2.getSelectionModel().getSelected().get('id');
                        } else {
                            node2id = node_b_id;
                        }
                        var records = {};
                        edges_store.each(
                            function (record){
                                records[record.get('id')] = record.get('activate');
                            }
                        );
                        Ext.getCmp('card-1').getForm().submit({
                            url: 'arv/add_connect',
                            //waitMsg: Ext.i18n.dialog_submit,
                            params: {
                                node1: node_a_id,
                                node2: node2id,
                                tmpl_connect: Ext.getCmp('tmplconnect').getValue(),
                                edges: Ext.util.JSON.encode(records),
                                extr1: Ext.getCmp('extr1').getValue(),
                                extr2: Ext.getCmp('extr2').getValue(),
                                cred1: Ext.getCmp('cred1').getValue(),
                                cred2: Ext.getCmp('cred2').getValue(),
                                leftsendcert: Ext.getCmp('leftsendcert_combo_connect').getValue(),
                                fragmentation: Ext.getCmp('fragmentation_combo_connect').getValue(),
                                rw_dns: Ext.getCmp('rw_dns').getValue(),
                            },
                            success: response_success,
                        })
                    }
                }
            } else {
                //if modify connect
                nbcard = 2;
                //FIXME
                var wizard_ok_button = {
                    id: 'button-addnode2',
                    text: Ext.i18n.modify,
                    disabled: true,
                    handler: function() {
                        if (node_b_id == null) {
                            error_msg(Ext.i18n.field_empty);
                            return;
                        } else {
                            node2id = node_b_id;
                        }
                        var records = {};
                        edges_store.each(
                            function (record){
                                records[record.get('id')] = record.get('activate');
                            }
                        );
                        Ext.getCmp('card-1').getForm().submit({
                            url: 'arv/mod_connect',
                            //waitMsg: Ext.i18n.dialog_submit,
                            params: {
                                node1: node_a_id,
                                node2: node2id,
                                connect_id: connect_id,
                                edges: Ext.util.JSON.encode(records),
                                extr1: Ext.getCmp('extr1').getValue(),
                                extr2: Ext.getCmp('extr2').getValue(),
                                cred1: Ext.getCmp('cred1').getValue(),
                                cred2: Ext.getCmp('cred2').getValue(),
                                leftsendcert: Ext.getCmp('leftsendcert_combo_connect').getValue(),
                                fragmentation: Ext.getCmp('fragmentation_combo_connect').getValue(),
                                rw_dns: Ext.getCmp('rw_dns').getValue(),
                            },
                            success: response_success,
                        })
                    }
                }
            }
            var wizard = {
                id:'addnode2-wizard-panel',
                xtype: 'panel',
                layout:'card',
                border: false,
                activeItem: nbcard,
                bbar: ['->', {
                    id: 'card-prev',
                    text: '&laquo; '+ Ext.i18n.previous,
                    handler: navHandler.createDelegate(this, [-1]),
                    disabled: true,
                },{
                    id: 'card-next',
                    text: Ext.i18n.next+' &raquo;',
                    handler: navHandler.createDelegate(this, [1]),

                }],
                items: cardcontent,
                buttons: [{
                    text: Ext.i18n.cancel,
                    handler: function(){
                        winaddnode2.destroy();
                    }
                }, wizard_ok_button
                ]
            };

            var response_success = function(response, options){
                if (node_b_id == null) {
                    ARV.observable.fireEvent("treenode2changed");
                } else {
                    ARV.observable.fireEvent("changemodconnect");
                }
                winaddnode2.destroy();
            };

            var winaddnode2 = new ARV.PopupWindow({
                title: Ext.i18n.addnode2_title,
                width: 400,
                items: [wizard],
            }).show();

            if (node_b_id != null) {
                Ext.getCmp('tmplconnect').setValue(connect_id);
                Ext.getCmp('tmplconnect').setRawValue(connect_id);
                navHandler(0);
            } else {
                nodes_store.load();
            }
        },
        openConnectWindow: function(nodea, nodeb){
            connectstore.removeAll();
            connectstore.baseParams={nodea: nodea, nodeb: nodeb};
            connectstore.load();
            connectwin.show();
        },
        load: function(nodea, nodeb) {
            connectstore.removeAll();
            if (nodea != null && nodeb != null) {
                connectstore.baseParams={nodea: nodea, nodeb: nodeb};
                connectstore.load();
            };
        },
        loadIP: function() {
            Ext.getCmp('extr1').store.load();
            Ext.getCmp('extr2').store.load();
        },
        getSelectedId: function() {
            if (connect_grid.getSelectionModel().hasSelection()) {
                return connect_grid.getSelectionModel().getSelected().get('id');
            } else {
                return null
            }
        },
        getSelectedLeftSendCert: function() {
            if (connect_grid.getSelectionModel().hasSelection()) {
                return connect_grid.getSelectionModel().getSelected().get('leftsendcert');
            } else {
                return null
            }
        },
        getSelectedFragmentation: function() {
            if (connect_grid.getSelectionModel().hasSelection()) {
                return connect_grid.getSelectionModel().getSelected().get('fragmentation');
            } else {
                return null
            }
        },
        getSelectedRWDns: function() {
            if (connect_grid.getSelectionModel().hasSelection()) {
                return connect_grid.getSelectionModel().getSelected().get('rw_dns');
            } else {
                return null
            }
        },
    };
})();


// vim: ts=4 sw=4 expandtab
