/*
 *
 *
 */

Ext.namespace("ARV");

ARV.modcred = (function() {
    /*
     * Public
     */

    var credstore = new Ext.data.Store({
        reader: new Ext.data.JsonReader({
            root :'data',
            successProperty: 'success',
        },[
            {name : 'cred'},
            {name : 'id'},
        ]),
        url: 'arv/get_cred',
    });
    columns = [
        {header: Ext.i18n.cred_header, sortable: true, dataIndex: 'cred'},
        {header: 'ID', sortable: true, dataIndex: 'id', hidden: true}
    ];

    var credgrid = new ARV.GridPanel({
        store: credstore,
        columns: columns,
        deleteUrl: 'arv/del_cred',
        btnAddEvent: 'credadd',
        btnModEvent: 'credmod',
        btnDelEvent: 'credchanged'
    });
    return {
        load: function(node) {
            credstore.removeAll();
            credstore.baseParams={node: node};
            credstore.load();
        },
        getSelectedId: function() {
            if (credgrid.getSelectionModel().hasSelection()) {
                return credgrid.getSelectionModel().getSelected().get('id');
            } else {
                return null
            }
        },
        openWindow: function(node){
            credstore.baseParams={node: node};
            credstore.load();
            var wincred = new ARV.PopupWindow({
                title: Ext.i18n.cred_title,
                items: [credgrid],
                bbar: ['->', {
                    text: Ext.i18n.exit,
                    handler: function(){
                        ARV.observable.fireEvent('closemodifycred');
                        wincred.hide()
                    }
                }]
            }).show();
        },
        openCredWindow: function(node, reload_store, connect_id){
            var cardcontent = [{
                id: 'cardmc-0',
                xtype: 'form',
                border: false,
                items: [{
                    xtype : "radio",
                    checked: true,
                    fieldLabel : Ext.i18n.imported_old_cred,
                    name : "cred_type",
                    inputValue: 'old_cred'
                },{
                    xtype : "radio",
                    fieldLabel : Ext.i18n.imported_pkcs12_cred,
                    name : "cred_type",
                    inputValue: 'pkcs12_cred'
                },{
                    xtype : "radio",
                    fieldLabel : Ext.i18n.generated_new_cred,
                    name : "cred_type",
                    inputValue: 'new_cred'
                }],
            },{
                id: 'cardmc-1-old',
                xtype: 'form',
                fileUpload: true,
                border: false,
                items: [{
                    xtype: 'fileuploadfield',
                    id: 'private_key',
                    buttonText: Ext.i18n.add,
                    buttonOnly: true,
                    fieldLabel : Ext.i18n.addcred_private_key,
                    width: 40,
                    listeners: {
                        'fileselected': function(fb, v){
                            Ext.getCmp('private_key').disable() ;
                            if ( Ext.getCmp('public_key').disabled == true ) {
                                Ext.getCmp('save-button').enable();
                            }
                        }
                    }
                }, {
                    xtype: 'fileuploadfield',
                    id: 'public_key',
                    buttonText: Ext.i18n.add,
                    buttonOnly: true,
                    fieldLabel : Ext.i18n.addcred_public_key,
                    width: 40,
                    listeners: {
                        'fileselected': function(fb, v){
                            Ext.getCmp('public_key').disable()
                            if ( Ext.getCmp('private_key').disabled == true ) {
                                Ext.getCmp('save-button').enable();
                            }
                        }
                    }
                }, {
                    xtype: 'textfield',
                    id: 'password',
                    fieldLabel : Ext.i18n.addcred_passwd,
                    inputType: 'password',
                    allowBlank:false
                }]
            },{
                id: 'cardmc-1-pkcs12',
                xtype: 'form',
                fileUpload: true,
                border: false,
                items: [{
                    xtype: 'fileuploadfield',
                    id: 'pkcs12_file',
                    buttonText: Ext.i18n.add,
                    buttonOnly: true,
                    fieldLabel : Ext.i18n.addcred_pkcs12,
                    width: 40,
                    listeners: {
                        'fileselected': function(fb, v){
                            Ext.getCmp('pkcs12_file').disable() ;
                            if ( Ext.getCmp('pkcs12_file').disabled == true ) {
                                Ext.getCmp('save-button').enable();
                            }
                        }
                    }
                }, {
                    xtype: 'textfield',
                    id: 'pkcs12_password',
                    fieldLabel : Ext.i18n.addcred_pkcs12_passwd,
                    inputType: 'password',
                    allowBlank:false
                }, {
                    xtype: "textfield",
                    id: 'key_passphrase',
                    fieldLabel: Ext.i18n.passwd,
                    name: 'key_passphrase',
                    inputType: 'password',
                    allowBlank: false
                }, {
                    xtype: "textfield",
                    id: 'key_passphrase2',
                    fieldLabel: Ext.i18n.passwd2,
                    name: 'key_passphrase2',
                    inputType: 'password',
                    allowBlank: false
                }]
            },{
                id: 'cardmc-1-new',
                xtype: 'form',
                border: false,
                items: [{
                    xtype: "textfield",
                    fieldLabel: Ext.i18n.addcred_name,
                    width: 150,
                    id: 'credname',
                    name: 'name',
                    allowBlank:false
                },{
                    xtype: "textfield",
                    fieldLabel: Ext.i18n.passwd,
                    width: 150,
                    id: 'passwd',
                    name: 'passwd',
                    inputType: 'password',
                    allowBlank: false
                },{
                    xtype: "textfield",
                    fieldLabel: Ext.i18n.passwd2,
                    width: 150,
                    id: 'passwd2',
                    name: 'passwd2',
                    inputType: 'password',
                    allowBlank: false
                },{
                    xtype : "radio",
                    checked: true,
                    fieldLabel : Ext.i18n.autosign_cred,
                    name : "cred_priv_type",
                    inputValue: 'autosigned'
                },{
                    xtype : "radio",
                    fieldLabel : Ext.i18n.cred_request,
                    name : "cred_priv_type",
                    inputValue: 'cred_request'
                }],
            }];

            var nbcard = 0;
            var navHandler = function(incr){
                var l = Ext.getCmp('addcred-wizard-panel').getLayout();
                var i = l.activeItem.id.split('cardmc-')[1];
                var next = parseInt(i) + incr;
                switch (next) {
                    case 0:  Ext.getCmp('save-button').disable();
                    break;
                    case 1:
                            var include_type = Ext.getCmp('cardmc-0').getForm().getValues()['cred_type'];
                            if (include_type == 'pkcs12_cred') {
                                next = 2;
                                Ext.getCmp('pkcs12_file').enable() ;
                            } else if (include_type == 'new_cred') {
                                next = 3;
                                Ext.getCmp('save-button').enable();
                            };
                    break;
                };
                l.setActiveItem(next);
                nbcard = next;
                Ext.getCmp('cardmc-prev').setDisabled(next==0);
                Ext.getCmp('cardmc-next').setDisabled(next>0);

            };

            var wizard = {
                id:'addcred-wizard-panel',
                xtype: 'panel',
                layout:'card',
                border: false,
                activeItem: nbcard,
                bbar: ['->', {
                    id: 'cardmc-prev',
                    text: '&laquo; '+ Ext.i18n.previous,
                    handler: navHandler.createDelegate(this, [-1]),
                    disabled: true,

                },{
                    id: 'cardmc-next',
                    text: Ext.i18n.next+' &raquo;',
                    handler: navHandler.createDelegate(this, [1]),

                }],
                items: cardcontent,
                buttons: [{
                    text: Ext.i18n.cancel,
                    handler: function(){
                        wincred2.destroy();
                    }
                },{
                    id: 'save-button',
                    text: Ext.i18n.save,
                    disabled: true,
                    handler: function() {
                        if (nbcard==1) {
                            fb = Ext.getCmp('cardmc-1-old').getForm();
                            if (fb.isValid){
                                Ext.getCmp('public_key').enable();
                                Ext.getCmp('private_key').enable();
                                fb.submit({
                                    url: 'arv/add_imported_cred',
                                    params: {node: node, tmplconnect_id: connect_id},
                                    success: response_success,
                                });
                            };
                        } else if (nbcard==2) {
                            fb = Ext.getCmp('cardmc-1-pkcs12').getForm();
                            Ext.getCmp('pkcs12_file').enable();
                            if (fb.isValid){
                                values = fb.getValues();
                                console.log(values['key_passphrase'])
                                if (values['key_passphrase'] != values['key_passphrase2']) {
                                    error_msg(Ext.i18n.unmatched_passwd)
                                } else {
                                    fb.submit({
                                        url: 'arv/add_imported_pkcs12',
                                        params: {node: node, tmplconnect_id: connect_id},
                                        success: response_success,
                                    });
                                };
                            };
                        } else {
                            fb = Ext.getCmp('cardmc-1-new').getForm();
                            if (fb.isValid){
                                values = fb.getValues();
                                if (values['name'].match(/ /) != null) {
                                    error_msg(Ext.i18n.nospace_certname)
                                } else {
                                    if (values['passwd'].length < 4) {
                                        error_msg(Ext.i18n.tooshort_passwd)
                                    } else {
                                        if (values['passwd'] != values['passwd2']) {
                                            error_msg(Ext.i18n.unmatched_passwd)
                                        } else {
                                            fb.submit({
                                                url: 'arv/add_generated_cred',
                                                params: {node: node},
                                                success: response_success
                                            })
                                        }
                                    }
                                }
                            }
                        }
                    }
                }]
            };
            var response_success = function(response, options){
                wincred2.destroy();
                if (reload_store == null) {
                    ARV.observable.fireEvent("credchanged");
                } else {
                    reload_store.load()
                }
            };
            var wincred2 = new ARV.PopupWindow({
                title: Ext.i18n.addcred_title,
                items: [wizard]
            }).show();
        },

        modCredWindow: function(cred_id, reload_store){
            var cardcontent = [{
                id: 'cardmc-0-mod',
                xtype: 'form',
                border: false,
                items: [{
                    xtype : "radio",
                    checked: true,
                    fieldLabel : Ext.i18n.imported_old_cred,
                    name : "cred_type",
                    inputValue: 'old_cred'
                },{
                    xtype : "radio",
                    fieldLabel : Ext.i18n.imported_pkcs12_cred,
                    name : "cred_type",
                    inputValue: 'pkcs12_cred'
                }],
            },{
                id: 'cardmc-1-mod',
                xtype: 'form',
                fileUpload: true,
                border: false,
                items: [{
                    xtype: 'fileuploadfield',
                    id: 'private_key',
                    buttonText: Ext.i18n.add,
                    buttonOnly: true,
                    fieldLabel : Ext.i18n.addcred_private_key,
                    width: 40,
                    listeners: {
                        'fileselected': function(fb, v){
                            Ext.getCmp('private_key').disable() ;
                        }
                    }
                }, {
                    xtype: 'fileuploadfield',
                    id: 'public_key',
                    buttonText: Ext.i18n.add,
                    buttonOnly: true,
                    fieldLabel : Ext.i18n.addcred_public_key,
                    width: 40,
                    listeners: {
                        'fileselected': function(fb, v){
                            Ext.getCmp('public_key').disable()
                            Ext.getCmp('save-button').enable();
                        }
                    }
                }, {
                    xtype: 'textfield',
                    id: 'password',
                    fieldLabel : Ext.i18n.addcred_passwd,
                    inputType: 'password',
                    allowBlank:false
                }]
            },{
                id: 'cardmc-1-pkcs12-mod',
                xtype: 'form',
                fileUpload: true,
                border: false,
                items: [{
                    xtype: 'fileuploadfield',
                    id: 'pkcs12_file',
                    buttonText: Ext.i18n.add,
                    buttonOnly: true,
                    fieldLabel : Ext.i18n.addcred_pkcs12,
                    width: 40,
                    listeners: {
                        'fileselected': function(fb, v){
                            Ext.getCmp('pkcs12_file').disable() ;
                            if ( Ext.getCmp('pkcs12_file').disabled == true ) {
                                Ext.getCmp('save-button').enable();
                            }
                        }
                    }
                }, {
                    xtype: 'textfield',
                    id: 'pkcs12_password',
                    fieldLabel : Ext.i18n.addcred_pkcs12_passwd,
                    inputType: 'password',
                    allowBlank:false
                }, {
                    xtype: "textfield",
                    id: 'key_passphrase',
                    fieldLabel: Ext.i18n.passwd,
                    name: 'key_passphrase',
                    inputType: 'password',
                    allowBlank: false
                }, {
                    xtype: "textfield",
                    id: 'key_passphrase2',
                    fieldLabel: Ext.i18n.passwd2,
                    name: 'key_passphrase2',
                    inputType: 'password',
                    allowBlank: false
                }]
            }];

            var nbcard = 0;
            var navHandler = function(incr){
                var l = Ext.getCmp('modcred-wizard-panel').getLayout();
                var i = l.activeItem.id.split('cardmc-')[1];
                var next = parseInt(i) + incr;
                switch (next) {
                    case 0:  Ext.getCmp('save-button').disable();
                    break;
                    case 1:
                            var include_type = Ext.getCmp('cardmc-0-mod').getForm().getValues()['cred_type'];
                            if (include_type == 'pkcs12_cred') {
                                next = 2;
                                Ext.getCmp('pkcs12_file').enable() ;
                            } else if (include_type == 'new_cred') {
                                next = 3;
                                Ext.getCmp('save-button').enable();
                            };
                    break;
                };
                l.setActiveItem(next);
                nbcard = next;
                Ext.getCmp('cardmc-prev').setDisabled(next==0);
                Ext.getCmp('cardmc-next').setDisabled(next>0);

            };

            var wizard = {
                id:'modcred-wizard-panel',
                xtype: 'panel',
                layout:'card',
                border: false,
                activeItem: nbcard,
                bbar: ['->', {
                    id: 'cardmc-prev',
                    text: '&laquo; '+ Ext.i18n.previous,
                    handler: navHandler.createDelegate(this, [-1]),
                    disabled: true,

                },{
                    id: 'cardmc-next',
                    text: Ext.i18n.next+' &raquo;',
                    handler: navHandler.createDelegate(this, [1]),

                }],
                items: cardcontent,
                buttons: [{
                    text: Ext.i18n.cancel,
                    handler: function(){
                        winmodcred.destroy();
                    }
                },{
                    id: 'save-button',
                    text: Ext.i18n.save,
                    disabled: true,
                    handler: function() {
                        if (nbcard==1) {
                            fb = Ext.getCmp('cardmc-1-mod').getForm();
                            if (fb.isValid){
                                Ext.getCmp('public_key').enable();
                                Ext.getCmp('private_key').enable();
                                fb.submit({
                                    url: 'arv/mod_keys',
                                    params: {cred_id: cred_id},
                                    success: response_success,
                                });
                            };
                        } else {
                            fb = Ext.getCmp('cardmc-1-pkcs12-mod').getForm();
                            Ext.getCmp('pkcs12_file').enable();
                            if (fb.isValid){
                                values = fb.getValues();
                                console.log(values['key_passphrase'])
                                if (values['key_passphrase'] != values['key_passphrase2']) {
                                    error_msg(Ext.i18n.unmatched_passwd)
                                } else {
                                    fb.submit({
                                        url: 'arv/mod_keys_pkcs12',
                                        params: {cred_id: cred_id},
                                        success: response_success,
                                    });
                                };
                            };
                        }
                    }
                }]
            };

            var response_success = function(response, options){
                winmodcred.destroy();
                if (reload_store == null) {
                    ARV.observable.fireEvent("credchanged");
                } else {
                    reload_store.load()
                }
            };
            var winmodcred = new ARV.PopupWindow({
                title: Ext.i18n.modcred_title,
                items: [wizard]
            }).show();
        }
    };
})();

// vim: ts=4 sw=4 expandtab
