/*
 *
 *
 */

Ext.namespace("ARV");

ARV.treenode1 = (function() {
    /*
     * Private
     */
    var selid = null;
    var tnode1grid = new ARV.GridNode({
        region: 'west',
        title: Ext.i18n.node1,
    });
    tnode1grid.getSelectionModel().on('rowselect', function() {ARV.observable.fireEvent('treenode2changed')}, this);
    this_store = tnode1grid.getStore();
    this_store.on('load', function() {
        if (selid != null) {
            index = this_store.findExact('id', selid);
            if (index != -1) {
                tnode1grid.getSelectionModel().selectRow(index)
            }
        };
        selid = null
    }, this);

    /*
     * Public
     */

    return {

        get: function() {
            return tnode1grid;
        },
        load: function() {
            selid = ARV.treenode1.getSelectedId();
            ARV.treenode2.storeSelId();
            store=tnode1grid.getStore();
            store.removeAll();
            store.load();
            ARV.observable.fireEvent('treenode2changed');
        },

        getSelectedUai: function() {
            if (tnode1grid.getSelectionModel().hasSelection()) {
                return tnode1grid.getSelectionModel().getSelected().get('uai');
            } else {
                return null
            }
        },

        getSelectedId: function() {
            if (tnode1grid.getSelectionModel().hasSelection()) {
                return tnode1grid.getSelectionModel().getSelected().get('id');
            } else {
                return null
            }
        },

        getSelectedName: function() {
            if (tnode1grid.getSelectionModel().hasSelection()) {
                return tnode1grid.getSelectionModel().getSelected().get('node');
            } else {
                return null
            }
        },

        getSelectedIdZephir: function() {
            if (tnode1grid.getSelectionModel().hasSelection()) {
                return tnode1grid.getSelectionModel().getSelected().get('id_zephir');
            } else {
                return null
            }
        },

        getSelectedMimetype: function() {
            if (tnode1grid.getSelectionModel().hasSelection()) {
                return tnode1grid.getSelectionModel().getSelected().get('mimetype');
            } else {
                return null
            }
        }
    };
})();
