# -*- coding: UTF-8 -*-
"""website server
"""
from arv.lib.logger import logger
from sys import exit
# ____________________________________________________________
from twisted.application import internet, service
from twisted.web import server, resource, static
from twisted.internet import reactor, ssl
from twisted.web.error import UnexposedMethodError
# ____________________________________________________________
# ____________________________________________________________
from arv.db.initialize import initialize_database, commit_database
# ____________________________________________________________
from arv.web.page import *
from arv.web.childpage import *
from arv.db.edge import get_edges
# ____________________________________________________________

class RootPage(resource.Resource):
    def getChild(self, name, request):
        pages = {b'login': Login,
                 b'logout': Close,
                 b'apply': Apply,

                 b'get_nodes': GetNodes,
                 b'get_nodes_state': GetNodesState,
                 b'get_edges': GetEdges,
                 b'get_cred': GetCred,
                 b'get_credauth': GetCredAuth,
                 b'get_all_cred': GetAllCred,
                 b'get_extr': GetExtr,
                 b'get_connects': GetConnects,
                 b'get_tmpl_nodes': GetTmplNodes,
                 b'get_tmpl_connects': GetTmplConnects,
                 b'get_tmpl_edges': GetTmplEdges,
                 b'get_tmpl_vertices': GetTmplVertices,
                 b'get_zephir_etabs': GetZephirEtabs,
                 b'get_zephir_modules': GetZephirModules,
                 b'get_zephir_variables': GetZephirVariables,

                 b'add_tmpl_connect': AddTmplConnect,
                 b'add_tmpl_node': AddTmplNode,
                 b'add_tmpl_edge': AddTmplEdge,
                 b'add_node': AddNode,
                 b'add_connect': AddConnect,
#                b 'add_cred': AddCred,
                 b'add_credauth': AddCredAuth,
                 b'add_extremity': AddExtremity,
                 b'mod_extremity': ModExtrIP,
                 b'add_imported_cred': AddImportedCred,
                 b'add_imported_pkcs12': AddImportedPKCS12,
                 b'add_generated_cred': AddGeneratedCred,
                 b'add_tmpl_vertex': AddTmplVertex,

                 b'mod_node': ModNode,
                 b'mod_tmpl_edge': ModTmplEdge,
                 b'mod_tmpl_vertex': ModTmplVertex,
                 b'mod_connect': ModConnect,
                 b'mod_keys': ModKeys,
                 b'mod_keys_pkcs12': ModKeysPKCS12,
                 b'mod_ca': ModCA,
                 b'sync_zephir': SynchroARVZephir,

                 b'del_tmpl_connect': DelTmplConnect,
                 b'del_tmpl_node': DelTmplNode,
                 b'del_tmpl_edge': DelTmplEdge,
                 b'del_tmpl_vertex': DelTmplVertex,
                 b'del_node': DelNode,
                 b'del_edge': DelEdge,
                 b'del_connect': DelConnect,
                 b'del_cred': DelCred,
                 b'del_extip': DelExtrIP,

                 b'dl_credential': DlCredential,
                 b'send_db': SendDb
            }

        if static.isDangerous(name):
            return static.dangerousPathError
        if name in pages.keys():
            return pages[name]()
        # unauthorized request
        return UnexposedMethodError()

#    def render(self, request):
#        return b"well, you are not expected to be here 1"

root = static.File(arv_static_path)
root.putChild(b"arv", RootPage())
site = server.Site(root)

initialize_database()
# delete records in edge table not deleted before fix #4680
#FIXME
#for edge in get_edges():
#    if not edge.connect:
#        edge.delete()
commit_database()
# end fix #4680
application = service.Application("ARV")

if arv_ssl == "disabled":
    arvservice = internet.TCPServer(arv_port, site)
else:
    sslContext = ssl.DefaultOpenSSLContextFactory(
        arv_key,
        arv_crt,
    )
    arvservice = internet.SSLServer(arv_port, site, contextFactory = sslContext)

arvservice.setServiceParent(application)
