from lxml import etree
from os.path import isfile, join, isdir
from pytest import fixture, raises
from os import listdir, mkdir
from json import dump, load, dumps, loads

#from creole.xmlreflector import CreoleObjSpace, CreoleDictConsistencyError
#from creole import xmlreflector
from creole import objspace, annotator, loader
from creole.xml_compare import xml_compare
from creole.error import CreoleDictConsistencyError


dtdfile = 'data/creole.dtd'
if isfile(dtdfile):
    relative = True
else:
    relative = False
    dtdfile = '/usr/share/creole/creole.dtd'
    if not isfile(dtdfile):
        raise Exception('unable to find dtdfile')

destfile = '/tmp/test.xml'
if relative:
    dico_dirs = 'tests/flattener_dicos'
else:
    dico_dirs = '/usr/share/creole/tests/flattener_dicos'


test_ok = set()

for test in listdir(dico_dirs):
    if isdir(join(dico_dirs, test)):
        if isdir(join(dico_dirs, test, 'result')):
            test_ok.add(test)

excludes = set([])
excludes = set([])
test_ok -= excludes
#test_ok = ['70container_files', '70container_files_symlink_multi']


test_ok = list(test_ok)
test_ok.sort()
ori_dirs = loader.eoledirs
ori_extradico = loader.eoleextradico


@fixture(scope="module", params=test_ok)
def test_dir(request):
    return request.param


def launch_flattener(test_dir):
    dirs = [test_dir]
    subfolder = join(test_dir, 'subfolder')
    if isdir(subfolder):
        dirs.append(subfolder)
    extra = list()
    subfolder = join(test_dir, 'extra_dirs')
    load_extra = False
    if isdir(subfolder):
        load_extra = True
        loader.eoleextradico = subfolder
        #FIXME cannot redefine from now ... :/
        #return None, None
    force_dirs = dirs

    loader.eoledirs = dirs
    config = loader.creole_loader(load_values=False, load_extra=False, force_flattened=destfile)
    makedict_dir = join(test_dir, 'makedict')
    makedict_file = join(makedict_dir, 'base.json')
    if not isfile(makedict_file):
        if not isdir(makedict_dir):
            mkdir(makedict_dir)
        with open(makedict_file, 'w') as fh:
            dump(config.make_dict(), fh)
    with open(makedict_file, 'r') as fh:
        assert load(fh) == loads(dumps(config.make_dict()))


def fake_traduc(txt):
    return txt


def setup_module(module):
    module.traduc_ori = objspace._
    objspace._ = fake_traduc
    annotator._ = fake_traduc
    objspace.ContainerAnnotator = getattr(annotator, 'ContainerAnnotator')


def teardown_module(module):
    objspace._ = module.traduc_ori
    annotator._ = module.traduc_ori
    loader.eoledirs = ori_dirs
    loader.eoleextradico = ori_extradico


def test_dictionary(test_dir):
    test_dir = join(dico_dirs, test_dir)
    launch_flattener(test_dir)
