#!/usr/bin/env python
# _*_ coding: UTF8 _*_

import json
import os

from gaspacho import initialize_database, get_category, load, \
        rollback_database, commit_database, apply_choices, \
        add_group, add_user
from gaspacho.config import database

dico = {}
execfile('/etc/gaspacho/eole.conf', {}, dico)

initialize_database(create=True)
def _set_choice(category, tag, rule, state, value=None):
    try:
        tcat = get_category(category, 'fr')
        ttag = tcat.get_tag(tag, 'fr')
        trule = ttag.get_rule(rule, 'fr')
        trule.set_choice(default, state=state, value=value)
    except:
        pass

for fname in dico['import_files']:
    print "Import file: %s"%fname
    fh = file(fname, 'r')
    config = json.load(fh, encoding='utf-8')
    fh.close()
    try:
        load(config)
    except Exception, e:
        #import traceback
        #print traceback.print_exc()
        rollback_database()
        print("  error: "+ str(e))
    commit_database()

#ajout du groupe default
default = add_group('default')
default.add_computer('*', 'dns')
user1 = add_user('eleves', u'usergroup')
user2 = add_user('professeurs', u'usergroup')
user3 = add_user('administratifs', u'usergroup')
user4 = add_user('DomainAdmins', u'usergroup')
default.add_user(user1)
default.add_user(user2)
default.add_user(user3)
default.add_user(user4)

#Specifique à Eclair
_set_choice('Barre des tâches', 'Panel', 'Horloge (applet)', 'on')
_set_choice('Barre des tâches', 'Panel',
        "Changement rapide de l'utilisateur (applet)", 'off')
_set_choice('Barre des tâches', 'Panel', "Zone de notification (applet)",
        'off')
_set_choice('Barre des tâches', 'Panel', "Indication (applet)",
        'off')
_set_choice('Système', 'Général', "Affichage des partages Scribe dans le navigateur de fichier",
        'on')
_set_choice('Général', 'Configuration général', "Faire apparaitre les fenêtres de premier lancement d'application",
        'off')
_set_choice('Général', 'Configuration général', "Langue par défaut",
        'on', 'fr')
_set_choice('Navigateur web', 'Vie privée', 'Activer le bilan de santé de Firefox', 'on')
_set_choice('Navigateur web', 'Sécurité', 'Activer les recherches automatiques de mises à jour du navigateur', 'off')


#Configuration du proxy
if dico.get('activer_proxy_client', 'non') == 'oui':
    _set_choice('Réseau', 'Configuration du proxy',
            "Configuration du serveur proxy manuelle", 'on',
            [dico['proxy_client_adresse'], dico['proxy_client_port']])
    _set_choice('Réseau', 'Configuration du proxy',
            "Ne pas utiliser le proxy pour les adresses spécifiées", 'on',
            dico['proxy_client_bypass'].split())
else:
    _set_choice('Réseau', 'Configuration du proxy',
            "Configuration du serveur proxy manuelle", 'off', ['', '3128'])

#Mail
if dico['activer_courier'] != 'non':
    _set_choice('Messagerie', 'Lecteur de courriel',
            "Configuration d'un compte de messagerie",
            "on", "Scribe")
    _set_choice('Messagerie', 'Lecteur de courriel', "Nom d'utilisateur",
            "on", "$USER")
    _set_choice('Messagerie', 'Lecteur de courriel',
            "Adresse courriel de l'utilisateur", "on",
            "$USER@%s" % dico['domaine_messagerie_etab'])
    if dico['activer_courier'] == 'pop':
        courier_type = 'pop'
    else:
        courier_type = 'imap'
    _set_choice('Messagerie', 'Lecteur de courriel',
            "Type de serveur de courriel", "on", courier_type)
    _set_choice('Messagerie', 'Lecteur de courriel', 'Adresse du serveur SMTP',
            "on", dico['adresse_ip'])
    _set_choice('Messagerie', 'Lecteur de courriel', 'Adresse du serveur de courriel',
            "on", dico['adresse_ip'])
    _set_choice('Messagerie', "Carnet d'adresses",
            'Description du serveur LDAP', 'on', 'Scribe')
    _set_choice('Messagerie', "Carnet d'adresses",
            "Annuaire LDAP pour le carnet d'adresses", 'on',
            'ldap://%s:389/o=gouv,c=fr??sub?(mail=*)' % dico['adresse_ip'])

#Jabber
if dico['activer_ejabberd'] == 'oui':
    _set_choice("Messagerie", "Messagerie instantanée Jabber",
            "Configurer le client de messagerie instantanée", 'on')
    _set_choice("Messagerie", "Messagerie instantanée Jabber",
            "Nom d'utilisateur", 'on', "$USER")
    _set_choice("Messagerie", "Messagerie instantanée Jabber",
            "Nom du serveur", 'on', dico['domain_jabber_etab'])
    _set_choice("Messagerie", "Messagerie instantanée Jabber",
            "Forcer le nom de domaine du serveur", 'on', dico['adresse_ip'])

commit_database()
apply_choices()
# vim: ts=4 sw=4 expandtab
