import sys
from configobj import ConfigObj
from formencode.validators import StringBoolean
from os.path import isfile

if isfile("gaspacho.conf"):
    conffile = "gaspacho.conf"
else:
    conffile = "/etc/gaspacho/gaspacho.conf"
    if not isfile(conffile):
        raise Exception("Unable to find configuration file")
try:
    config = ConfigObj(conffile)
except Exception, e:
    print "ERROR: --- unable to load configuration file ---"
    sys.exit(1)

def string_to_bool(value):
    return StringBoolean().to_python(value)

### internale database
database = config.get('database', 'sqlite:////var/lib/gaspacho/gaspacho.sqlite')

default_serv_lang = config.get('default_serv_lang', 'fr')

### Language order if not translate in selected language
ordered_lang = config.get('ordered_lang', ['en', 'fr'])

### Directories
store_dir_apply = config.get('store_dir_apply', '/var/lib/gaspacho/apply')
serv_static_path = config.get('serv_static_path', '/usr/local/share/gaspacho/')

serv_port = int(config.get('serv_port', '8080'))
serv_tls = config.get('serv_tls', 'disabled')
serv_crt = config.get('serv_crt', '')
serv_key = config.get('serv_key', '')
multi_site = string_to_bool(config.get('multi_site', False))
force_resolve_dns_name = string_to_bool(config.get('force_resolve_dns_name',
            True))


admin_pam_user = config.get('admin_pam_user', ['root', 'gaspacho'])

auth_type = config.get('auth_type', 'internal')

gaspacho_login = config.get('gaspacho_login', 'admin')
gaspacho_password = config.get('gaspacho_password', 'admin')

#loglevel must be in 'critical', 'error', 'warning', 'info' or 'debug'
log_level = config.get('log_level', 'error')
log_file = config.get('log_file', '/var/log/gaspacho/error.log')

database_version = u'0.91'

default_separator = '-'

# vim: ts=4 sw=4 expandtab
