# Copyright (C) 2010-2012 Team Gaspacho (see README for all contributors)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

from os import makedirs, unlink
from os.path import abspath, dirname, isdir, isfile, join
from py.test import raises
from sys import exit

here = dirname(abspath(__file__))

dir_name = join(here, 'datas')
file_name = join(dir_name, 'platform.sqlite')
database = 'sqlite:///%s' % file_name

if not isdir(dir_name):
    makedirs(dir_name)

if isfile(file_name):
    unlink(file_name)

from gaspacho import *
from gaspacho.platform import add_os, add_software, add_path, add_platform
from gaspacho.category import add_category
from gaspacho.conflevel import get_confcomputer, get_confuser
from gaspacho.apply import get_plugins_apply, apply_choices
initialize_database(create=True, database=database)

##############################################################################
#                                                                            #
##############################################################################

try:
    os1 = add_os('os1')
    osversion1 = os1.add_version('osversion11')
    osversion2 = os1.add_version('osversion12')
    os2 = add_os('os2')
    software1 = add_software('software1')
    software2 = add_software('software2')
    softwareversion1 = software1.add_version('softwareversion1')
    softwareversion2 = software2.add_version('softwareversion2')
    path1 = add_path('path1', 'moz')
    path2 = add_path('path2', 'moz', 'info')
    platform1 = add_platform(path1, osversion1, softwareversion1, [{'name': 'application'}])
    platform2 = add_platform(path1, osversion2, softwareversion2, [{'name': 'application2'}])
except:
    import traceback
    traceback.print_exc()
    print "unable to create a platform"
    exit(1)

try:
    user1 = add_user('user1')
except:
    print "unable to create an user"
    exit(1)

try:
    tmpl1 = add_template('tmpl1')
    grp1 = add_group('grp1')
    grp1.add_user(user1)
    grp1.add_computer('*', u'dns')
    grp2 = add_group('grp2', parent=grp1)
    grp2.add_user(user1)
    grp2.add_computer('a*', u'dns')
    grp2.add_computer('192.168.1.*', 'ip')
    grp3 = add_group('grp3')
    grp3.add_user(user1)
    grp3.add_computer('b*', 'dns')
    grp3.add_template(tmpl1)
    grp4 = add_group('grp4')
    grp5 = add_group('grp5')
    grp5.add_computer('c*', 'dns')
    grp5.add_software(software1)
except:
    import traceback
    traceback.print_exc()
    print "unable to create a group"
    exit(1)

try:
    confuser = get_confuser()
    confcomputer = get_confcomputer()
    #rules
    category1 = add_category()
    category1.add_translation(lang='en', name='category1')
    tag1 = category1.add_tag()
    tag1.add_translation(lang='en', name='tag1')
    #boolean
    rule1 = tag1.add_rule(type='boolean')
    rule2 = tag1.add_rule(type='boolean')
    variable1 = rule1.add_variable('variable_confuser', type='unicode',
                        value_on='yes', value_off='no', conflevel=confuser)
    variable1.add_platform(platform1)
    variable2 = rule2.add_variable('variable_confcomputer', type=u'boolean',
                        value_on='yes', value_off='no', conflevel=confcomputer)
    variable2.add_platform(platform1)
    variable2.add_platform(platform2)
except:
    import traceback
    traceback.print_exc()
    print "unable to add rule"
    exit(1)

empty = {'plugins': {}}

def add_choice_1():
    if (None, None) == rule1.get_choice(grp1):
        rule1.set_choice(grp1, 'on')

def add_choice_2():
    if (None, None) == rule2.get_choice(grp1):
        rule2.set_choice(grp1, 'on')

def add_tmpl_1():
    if (None, None) == rule1.get_choice(tmpl1):
        rule1.set_choice(tmpl1, 'off')

def test_apply_empty():
    assert get_plugins_apply(grp1, None, platform1, conflevel=confuser) == \
                                empty
    assert get_plugins_apply(grp1, None, platform2, conflevel=confuser) == \
                                empty
    assert get_plugins_apply(grp1, user1, platform1, conflevel=confuser) == \
                                empty
    assert get_plugins_apply(grp1, user1, platform2, conflevel=confuser) == \
                                empty
    assert get_plugins_apply(grp2, None, platform1, conflevel=confuser) == \
                                empty
    assert get_plugins_apply(grp2, None, platform2, conflevel=confuser) == \
                                empty
    assert get_plugins_apply(grp2, user1, platform1, conflevel=confuser) == \
                                empty
    assert get_plugins_apply(grp2, user1, platform2, conflevel=confuser) == \
                                empty
    assert get_plugins_apply(grp3, None, platform1, conflevel=confuser) == \
                                empty
    assert get_plugins_apply(grp3, None, platform2, conflevel=confuser) == \
                                empty
    assert get_plugins_apply(grp3, user1, platform1, conflevel=confuser) == \
                                empty
    assert get_plugins_apply(grp3, user1, platform2, conflevel=confuser) == \
                                empty
    assert get_plugins_apply(grp4, None, platform1, conflevel=confuser) == \
                                empty
    assert get_plugins_apply(grp4, None, platform2, conflevel=confuser) == \
                                empty
    assert get_plugins_apply(grp5, None, platform1, conflevel=confuser) == \
                                empty
    assert get_plugins_apply(grp5, None, platform2, conflevel=confuser) == \
                                empty
    
def test_gen_apply_choices():
    group5 = {'path': {'computer': {u'os1_osversion11': u'apply/grp5/os1/osversion11/computer.gasp'}, 'user': {'all': {u'os1_osversion11': u'apply/grp5/os1/osversion11/user/ALL.gasp'}}, 'context': {'all': {u'os1_osversion11': u'apply/grp5/os1/osversion11/context/ALL.gasp'}}}, 'group': [(u'c*', u'dns')]}
    group3 = {'path': {'computer': {u'os1_osversion11': u'apply/grp3/os1/osversion11/computer.gasp', u'os1_osversion12': u'apply/grp3/os1/osversion12/computer.gasp'}, 'user': {'all': {u'os1_osversion11': u'apply/grp3/os1/osversion11/user/ALL.gasp', u'os1_osversion12': u'apply/grp3/os1/osversion12/user/ALL.gasp'}, u'user': {u'user1': {u'os1_osversion11': u'apply/grp3/os1/osversion11/user/user/user1.gasp', u'os1_osversion12': u'apply/grp3/os1/osversion12/user/user/user1.gasp'}}}, 'context': {'all': {u'os1_osversion11': u'apply/grp3/os1/osversion11/context/ALL.gasp', u'os1_osversion12': u'apply/grp3/os1/osversion12/context/ALL.gasp'}, u'user': {u'user1': {u'os1_osversion11': u'apply/grp3/os1/osversion11/user/context/user1.gasp', u'os1_osversion12': u'apply/grp3/os1/osversion12/user/context/user1.gasp'}}}}, 'group': [(u'b*', u'dns')]}
    group2 = {'path': {'computer': {u'os1_osversion11': u'apply/grp2/os1/osversion11/computer.gasp', u'os1_osversion12': u'apply/grp2/os1/osversion12/computer.gasp'}, 'user': {'all': {u'os1_osversion11': u'apply/grp2/os1/osversion11/user/ALL.gasp', u'os1_osversion12': u'apply/grp2/os1/osversion12/user/ALL.gasp'}, u'user': {u'user1': {u'os1_osversion11': u'apply/grp2/os1/osversion11/user/user/user1.gasp', u'os1_osversion12': u'apply/grp2/os1/osversion12/user/user/user1.gasp'}}}, 'context': {'all': {u'os1_osversion11': u'apply/grp2/os1/osversion11/context/ALL.gasp', u'os1_osversion12': u'apply/grp2/os1/osversion12/context/ALL.gasp'}, u'user': {u'user1': {u'os1_osversion11': u'apply/grp2/os1/osversion11/user/context/user1.gasp', u'os1_osversion12': u'apply/grp2/os1/osversion12/user/context/user1.gasp'}}}}, 'group': [(u'a*', u'dns'), (u'192.168.1.*', u'ip')]}
    group1 = {'path': {'computer': {u'os1_osversion11': u'apply/grp1/os1/osversion11/computer.gasp', u'os1_osversion12': u'apply/grp1/os1/osversion12/computer.gasp'}, 'user': {'all': {u'os1_osversion11': u'apply/grp1/os1/osversion11/user/ALL.gasp', u'os1_osversion12': u'apply/grp1/os1/osversion12/user/ALL.gasp'}, u'user': {u'user1': {u'os1_osversion11': u'apply/grp1/os1/osversion11/user/user/user1.gasp', u'os1_osversion12': u'apply/grp1/os1/osversion12/user/user/user1.gasp'}}}, 'context': {'all': {u'os1_osversion11': u'apply/grp1/os1/osversion11/context/ALL.gasp', u'os1_osversion12': u'apply/grp1/os1/osversion12/context/ALL.gasp'}, u'user': {u'user1': {u'os1_osversion11': u'apply/grp1/os1/osversion11/user/context/user1.gasp', u'os1_osversion12': u'apply/grp1/os1/osversion12/user/context/user1.gasp'}}}}, 'group': [(u'*', u'dns')]}
    tapply = [group5, group3, group2, group1]
    assert apply_choices(create_file=False) == tapply

def test_apply_user_choice1():
    add_choice_1()
    choices = {'plugins': {u'moz': [{'variables': {'type': u'unicode', 'value': u'yes', 'key': u'variable_confuser'}, 'path': u'path1'}]}}
    assert get_plugins_apply(grp1, None, platform1, conflevel=confuser) == \
                                choices
    assert get_plugins_apply(grp1, None, platform2, conflevel=confuser) == \
                                empty
    assert get_plugins_apply(grp1, user1, platform1, conflevel=confuser) == \
                                choices
    assert get_plugins_apply(grp1, user1, platform2, conflevel=confuser) == \
                                empty
    assert get_plugins_apply(grp2, None, platform1, conflevel=confuser) == \
                                choices
    assert get_plugins_apply(grp2, None, platform2, conflevel=confuser) == \
                                empty
    assert get_plugins_apply(grp2, user1, platform1, conflevel=confuser) == \
                                choices
    assert get_plugins_apply(grp2, user1, platform2, conflevel=confuser) == \
                                empty
    assert get_plugins_apply(grp3, None, platform1, conflevel=confuser) == \
                                empty
    assert get_plugins_apply(grp3, None, platform2, conflevel=confuser) == \
                                empty
    assert get_plugins_apply(grp3, user1, platform1, conflevel=confuser) == \
                                empty
    assert get_plugins_apply(grp3, user1, platform2, conflevel=confuser) == \
                                empty
    assert get_plugins_apply(grp4, None, platform1, conflevel=confuser) == \
                                empty
    assert get_plugins_apply(grp4, None, platform2, conflevel=confuser) == \
                                empty
    assert get_plugins_apply(grp5, None, platform1, conflevel=confuser) == \
                                empty
    assert get_plugins_apply(grp5, None, platform2, conflevel=confuser) == \
                                empty

def test_apply_computer_choice1():
    add_choice_1()
    assert get_plugins_apply(grp1, None, platform1,
                        conflevel=confcomputer) == empty
    assert get_plugins_apply(grp1, None, platform2,
                        conflevel=confcomputer) == empty
    assert get_plugins_apply(grp2, None, platform1,
                        conflevel=confcomputer) == empty
    assert get_plugins_apply(grp2, None, platform2,
                        conflevel=confcomputer) == empty
    assert get_plugins_apply(grp3, None, platform1,
                        conflevel=confcomputer) == empty
    assert get_plugins_apply(grp3, None, platform2,
                        conflevel=confcomputer) == empty
    assert get_plugins_apply(grp4, None, platform1,
                        conflevel=confcomputer) == empty
    assert get_plugins_apply(grp4, None, platform2,
                        conflevel=confcomputer) == empty
    assert get_plugins_apply(grp5, None, platform1,
                        conflevel=confcomputer) == empty
    assert get_plugins_apply(grp5, None, platform2,
                        conflevel=confcomputer) == empty

def test_apply_user_choice2():
    add_choice_1()
    add_choice_2()
    choices = {'plugins': {u'moz': [{'variables': {'type': u'unicode', 'value': u'yes', 'key': u'variable_confuser'}, 'path': u'path1'}]}}
    assert get_plugins_apply(grp1, None, platform1, conflevel=confuser) == \
                                    choices
    assert get_plugins_apply(grp1, None, platform2, conflevel=confuser) == \
                                    empty
    assert get_plugins_apply(grp1, user1, platform1, conflevel=confuser) == \
                                    choices
    assert get_plugins_apply(grp1, user1, platform2, conflevel=confuser) == \
                                    empty
    assert get_plugins_apply(grp2, None, platform1, conflevel=confuser) == \
                                    choices
    assert get_plugins_apply(grp2, None, platform2, conflevel=confuser) == \
                                    empty
    assert get_plugins_apply(grp2, user1, platform1, conflevel=confuser) == \
                                    choices
    assert get_plugins_apply(grp2, user1, platform2, conflevel=confuser) == \
                                    empty
    assert get_plugins_apply(grp3, None, platform1, conflevel=confuser) == \
                                    empty
    assert get_plugins_apply(grp3, None, platform2, conflevel=confuser) == \
                                    empty
    assert get_plugins_apply(grp3, user1, platform1, conflevel=confuser) == \
                                    empty
    assert get_plugins_apply(grp3, user1, platform2, conflevel=confuser) == \
                                    empty
    assert get_plugins_apply(grp4, None, platform1, conflevel=confuser) == \
                                    empty
    assert get_plugins_apply(grp4, None, platform2, conflevel=confuser) == \
                                    empty
    assert get_plugins_apply(grp5, None, platform1, conflevel=confuser) == \
                                    empty
    assert get_plugins_apply(grp5, None, platform2, conflevel=confuser) == \
                                    empty

def test_apply_computer_choice2():
    add_choice_1()
    add_choice_2()
    choices = {'plugins': {u'moz': [{'variables': {'type': u'boolean', 'value': u'yes', 'key': u'variable_confcomputer'}, 'path': u'path1'}]}}
    assert get_plugins_apply(grp1, None, platform1,
                conflevel=confcomputer) == choices
    assert get_plugins_apply(grp1, None, platform2,
                conflevel=confcomputer) == choices
    assert get_plugins_apply(grp2, None, platform1,
                conflevel=confcomputer) == choices
    assert get_plugins_apply(grp2, None, platform2,
                conflevel=confcomputer) == choices
    assert get_plugins_apply(grp3, None, platform1,
                conflevel=confcomputer) == empty
    assert get_plugins_apply(grp3, None, platform2,
                conflevel=confcomputer) == empty
    assert get_plugins_apply(grp4, None, platform1,
                conflevel=confcomputer) == empty
    assert get_plugins_apply(grp4, None, platform2,
                conflevel=confcomputer) == empty
    assert get_plugins_apply(grp5, None, platform1,
                conflevel=confcomputer) == empty
    assert get_plugins_apply(grp5, None, platform2,
                conflevel=confcomputer) == empty

def test_apply_tmpl_user_choice2():
    add_choice_1()
    add_choice_2()
    add_tmpl_1()
    choices = {'plugins': {u'moz': [{'variables': {'type': u'unicode', 'value': u'yes', 'key': u'variable_confuser'}, 'path': u'path1'}]}}
    choicestp = {'plugins': {u'moz': [{'variables': {'type': u'unicode', 'value': u'no', 'key': u'variable_confuser'}, 'path': u'path1'}]}}
    assert get_plugins_apply(grp1, None, platform1, conflevel=confuser) == \
                                choices
    assert get_plugins_apply(grp1, None, platform2, conflevel=confuser) == \
                                    empty
    assert get_plugins_apply(grp1, user1, platform1, conflevel=confuser) == \
                                choices
    assert get_plugins_apply(grp1, user1, platform2, conflevel=confuser) == \
                                    empty
    assert get_plugins_apply(grp2, None, platform1, conflevel=confuser) == \
                                choices
    assert get_plugins_apply(grp2, None, platform2, conflevel=confuser) == \
                                    empty
    assert get_plugins_apply(grp2, user1, platform1, conflevel=confuser) == \
                                choices
    assert get_plugins_apply(grp2, user1, platform2, conflevel=confuser) == \
                                    empty
    assert get_plugins_apply(grp3, None, platform1, conflevel=confuser) == \
                                choicestp
    assert get_plugins_apply(grp3, None, platform2, conflevel=confuser) == \
                                    empty
    assert get_plugins_apply(grp3, user1, platform1, conflevel=confuser) == \
                                choicestp
    assert get_plugins_apply(grp3, user1, platform2, conflevel=confuser) == \
                                    empty
    assert get_plugins_apply(grp4, None, platform1, conflevel=confuser) == \
                                    empty
    assert get_plugins_apply(grp4, None, platform2, conflevel=confuser) == \
                                    empty
    assert get_plugins_apply(grp5, None, platform1, conflevel=confuser) == \
                                    empty
    assert get_plugins_apply(grp5, None, platform2, conflevel=confuser) == \
                                    empty

def test_apply_installpkg():
    add_choice_1()
    add_choice_2()
    add_tmpl_1()
    grp5.mod_installpkg(True)
    installpkg = {'packages': ['application'], 'plugins': {}}
    assert get_plugins_apply(grp5, None, platform1, conflevel=confcomputer) == \
                                    installpkg
    grp5.mod_installpkg(False)

def test_close_database():
    commit_database()
    close_database()

# vim: ts=4 sw=4 expandtab
