# Copyright (C) 2009, 2010 Emmanuel Garette <gnunux@gnunux.info>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

from formencode import validators, foreach
from gaspacho.log import trace #, logger

normalize_type = [u'', u'SUPPR', u'SUPPRALL', u'IGNORE']

@trace
def normalize_unicode(string):
    '''
    test input for string or unicode. If another type raise TypeError.
    If string convert to unicode.
    return unicode
    '''
    if not type(string) == unicode:
        if type(string) == str:
            string = unicode(string, "utf-8")
        else:
            raise TypeError("unsupported encoding")
    return string

def valid(value, typ, options=None):
    """
        formencode validation
    """
    if typ in ['unicode', 'type', 'state', 'user', 'computer']:
        validator = validators.String()
    elif typ == 'list' or typ == 'multi':
        if type(value) == list:
            return value
        else:
            raise TypeError('%s should be a list' % typ)
    elif typ == 'boolean':
        validator = validators.StringBoolean()
    elif typ == 'integer':
        if options != None:
            min = options.get('min', None)
            max = options.get('max', None)
        else:
            min=None
            max=None
        validator = validators.Int(min=min, max=max, not_empty=True)
     #FIXME
    elif typ == 'ip':
        validator = validators.IPAddress()
    elif typ == 'enum':
        if type(value) == list:
            try:
                for option in value:
                    assert len(option) == 2
            except:
                raise Exception('Options must be list of list for enum')
            return value
        else:
            raise TypeError('enum should be a list')
    else:
        if type(value) == typ:
            return value
        else:
            raise TypeError('Unknown type (%s) for %s' % (typ, value))
    val = validator.to_python(value)
    # If string or ip, convert to unicode
    if typ in ['unicode', 'ip', 'type', 'user', 'computer', 'state']:
        if val == None:
            val = ''
        val = normalize_unicode(val)
    if typ == 'type':
        if val not in [u'boolean', u'unicode', u'integer', u'ip', u'enum',
                       u'multi', u'list']:
            raise TypeError('%s is an unsupported type' % str(val))
    if typ == 'state':
        if val not in [u'off', u'on', u'free']:
            raise TypeError('%s is an unsupported state' % str(val))
    if typ == 'computer':
        if val not in [ u'ip', u'dns' ]:
            raise TypeError('%s is an unsupported computer type' % str(val))
    if typ == 'user':
        if val not in [ u'user', u'usergroup' ]:
            raise TypeError('%s is an unsupported user type' % str(val))
    return val

# vim: ts=4 sw=4 expandtab
