/**
  * Ext.ux.FlagCombo Extension Class
  *
  * @author  Jozef Sakalos
  * @version 1.0
  * see http://dev.extjs.com/learn/Tutorial:Extending_Ext_Class
  *
  * Modified by GnunuX for Gaspacho
  *
  * @class Ext.ux.FlagCombo
  * @extends Ext.form.ComboBox
  * @constructor
  * @param {Object} config Configuration options
  */
Ext.ns('Ext.ux.form');
 
// extend

Ext.ux.form.FlagCombo = Ext.extend(Ext.form.ComboBox, {
    valueField: 'countryCode',
    displayField: 'countryName',
    iconClsField: 'countryFlag',
    triggerAction: 'all',
    editable: false,
    forceSelection: true,
    typeAhead: true,
    allowBlank: false,
 
    constructor: function(config){
        Ext.apply(this, config);
        Ext.ux.form.FlagCombo.superclass.constructor.call(this);
        this.tpl = config.tpl ||
              '<tpl for="."><div class="x-combo-list-item x-icon-combo-item {' 
            + this.iconClsField 
            + '}">{' 
            + this.displayField 
            + '}</div></tpl>'
        ;
     
        this.on({
            render:{scope:this, fn:function() {
                var wrap = this.el.up('div.x-form-field-wrap');
                this.wrap.applyStyles({position:'relative'});
                this.el.addClass('x-icon-combo-input');
                this.flag = Ext.DomHelper.append(wrap, {
                    tag: 'div', style:'position:absolute'
                });
            }}
        });
    },
    setIconCls: function() {
        var rec = this.store.query(this.valueField, this.getValue()).itemAt(0);
        if(rec) {
            this.flag.className = 'x-icon-combo-icon ' + rec.get(this.iconClsField);
        }
    },
 
    setValue: function(value) {
        Ext.ux.form.FlagCombo.superclass.setValue.call(this, value);
        this.setIconCls();
    }
 
}); // end of extend
 
Ext.reg('flagcombo', Ext.ux.form.FlagCombo);
//backwards compat
Ext.form.FlagCombo = Ext.ux.form.FlagCombo;
