/*!
 * Ext JS Library 3.1.0
 * Copyright(c) 2006-2009 Ext JS, LLC
 * licensing@extjs.com
 * http://www.extjs.com/license
 * Origin CheckColumn.js
 * Modified by Emmanuel Garette <gnunux@gnunux.info>
 */

/**
 * @class Ext.gaspacho.GASPCheckColumn
 * @extends Object
 * GridPanel plugin to add a column with three states (free, on, off)
 * and an herited column.
 */
Ext.ns('Ext.gaspacho.grid');

Ext.gaspacho.GASPCheckColumn = function(config){
    Ext.apply(this, config);
    if(!this.id){
        this.id = Ext.id();
    };
    //row is/is not herited type
    //this type permit to remove not herited data if the line became herited
    if(!this.herited){
        this.herited = false;
    };
    if(this.threeStick != false){
        this.threeStick = true;
    };
    if(!this.heritedCol && this.herited == false) {
        //name of the heritedCol
        this.heritedCol = 'herited';
    }
    this.renderer = this.renderer.createDelegate(this);
};

Ext.gaspacho.GASPCheckColumn.prototype ={
    init : function(grid){
        this.grid = grid;
        this.grid.on('render', function(){
            var view = this.grid.getView();
            //add onMouseDown fonction when clicked on row
            view.mainBody.on('mousedown', this.onMouseDown, this);
            if (this.herited == true) {
                var datacol = this.dataIndex;
                view.getRowClass = function(record, rowIndex, p, ds){
                    //if value of the row is true, disabled the line
                    if (record.get(datacol) == true) {
                        return "x-gaspacho-grid3-disabled x-grid3-row-collapsed";
                    }
		    //add x-grid3-row-collapsed for RowExpander plugins
		    return "x-grid3-row-collapsed";
                };
            }
        }, this);
    },

    onMouseDown : function(e, t){
        if(t.className && t.className.indexOf('x-grid3-cc-'+this.id) != -1){
            e.stopEvent();
            var index = this.grid.getView().findRowIndex(t);
            var record = this.grid.store.getAt(index);
            if (this.herited == true) {
                //if this row is herited type

                //if old value of the row was was not false, do nothing
                //because you need to reset herited col only if this col
                //is herited
                if (record.get(this.dataIndex) != false) {
                    return
                }
                //set true to the row
                var newvalue = true;
                //get herited value
                record.set('state', record.get('hstate'));
                record.set('value', record.get('hvalue'))
            } else {
                if (this.threeStick == true) {
                    //if this is not herited type
                    //change value of this row
                    //true -> false -> null -> true ...
                    if (record.get(this.dataIndex) == true) {
                        var newvalue = false;
                    }else if (record.get(this.dataIndex) == false) {
                        var newvalue = null;
                    }else {
                        var newvalue = true;
                    }
                }else{
                    var newvalue = !record.get(this.dataIndex)
                }
                //unherite this line
                record.set(this.heritedCol, false)
            }
            //set new value
            record.set(this.dataIndex, newvalue);
        }
    },

    renderer : function(v, p, record){
        //set the row property
        p.css += ' x-grid3-check-col-td'; 
        //if need, add -null or -on to x-grid3-check-col class name
        if (this.herited == false && v == null) {
            var classname = '-null';
        }else{
            var classname = (v?'-on':'');
        }
        //if specified, add iconCls
        if (this.iconCls) {
            extracls=' '+this.iconCls+classname;
        }else{
            extracls='';
        };
        return '<div class="x-grid3-check-col'+classname+extracls+' x-grid3-cc-'+this.id+'">&#160;</div>';
    }
};

// register ptype
Ext.preg('checkcolumn', Ext.gaspacho.GASPCheckColumn);

// backwards compat
Ext.grid.GASPCheckColumn = Ext.gaspacho.GASPCheckColumn;
