/* Copyright (C) 2010 Team Gaspacho (see README for all contributors)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * @class Ext.gaspacho.GASPRowDelete
 *
 * Plugin (ptype = 'rowdelete') that adds the ability to have a Column in a grid which add a button
 * to remove the current line in the store.
 */
Ext.ns('Ext.gaspacho.grid');

Ext.gaspacho.GASPRowDelete = function(config){
    Ext.apply(this, config);
    if(!this.id){
        this.id = Ext.id();
    };
    this.renderer = this.renderer.createDelegate(this);
};

Ext.gaspacho.GASPRowDelete.prototype ={
    init : function(grid){
        this.grid = grid;
        this.grid.on('render', function(){
            var view = this.grid.getView();
            //when clicked
            view.mainBody.on('mousedown', this.onMouseDown, this);
        }, this);
    },

    onMouseDown : function(e, t){
        if(t.className && t.className.indexOf('x-grid3-rd-'+this.id) != -1){
            e.stopEvent();
            var store = this.grid.store;
            var index = this.grid.getView().findRowIndex(t);
            var record = store.getAt(index);
            //remove line from the store
            store.remove(record);
	}
    },

    renderer : function(v, p, record){
        //add x-grid3-check-col-td to display the image
        p.css += ' x-grid3-check-col-td'; 
        //add row in renderer
        return '<div class=" x-grid3-rd-'+this.id+' '+this.iconCls+'">&#160;</div>';
    }
};

// register ptype
Ext.preg('rowdelete', Ext.gaspacho.GASPRowDelete);

// backwards compat
Ext.grid.GASPRowDelete = Ext.gaspacho.GASPRowDelete;
