/* Copyright (C) 2010 Team Gaspacho (see README for all contributors)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

Ext.namespace("GASP");

GASP.addcomputer = (function() {
    return {
        open: function(computer_store){

            /*
             * Interface
             */
            c_store = new Ext.data.SimpleStore({
                fields: ['computertype', 'displaytype'],
                data: [
                    ['dns', Ext.i18n.dns],
                    ['ip', Ext.i18n.ip]
                ]
            });

            //main form 
            var computer_form = new Ext.FormPanel({
                //labelWidth: 75, // label settings here cascade unless overridden
                border: false,
                defaultType: 'textfield',
                items: [{
                    fieldLabel: Ext.i18n.addcomputer_name,
                    name: 'name',
                    id: 'computer_name',
                    allowBlank: false
                },{
                    xtype: 'combo',
                    id: 'computer_type',
                    fieldLabel: Ext.i18n.computertype,
                    name: 'computertype',
                    valueField: 'computertype',
                    displayField: 'displaytype',
                    hiddenName: 'computertype',
                    store: c_store,
                    mode: 'local',
                    triggerAction: 'all',
                    editable: false,
                    forceSelection: true,
                    typeAhead: true,
                    allowBlank: false,
                    value: 'dns'
                }]
            });

            //window
            winaddcomputer = new Ext.Window({
                title: Ext.i18n.addcomputer_title,
                height: 200,
                width: 400,
                layout: 'fit',
                closable: false,
                resizable: false,
                modal: true,
                border: true,
                items: computer_form,
                layoutConfig: {
                    align : 'stretch',
                    pack  : 'start',
                },
                buttons: [{
                    text: Ext.i18n.cancel,
                    handler: cancel_computer
                },{
                    text: Ext.i18n.ok,
                    id: 'save-but-computer',
                    formBind: true,
                    handler: save_computer
                }]
            });

            function cancel_computer(){
                winaddcomputer.close()
            };
            function save_computer() {
                computer_store.add(new Ext.data.Record({
                    'computer': Ext.getCmp('computer_name').getValue(),
                    'type': Ext.getCmp('computer_type').getValue()}));
                winaddcomputer.close();
                //computer_basicform = computer_form.getForm();
                //if (computer_basicform.isValid()) {
                //    computer_basicform.submit({
                //        url: 'add/computer',
                //        params: {
                //            groupid: groupid
                //        },
                //        success: response_success
                //    })
                //}
            };

            //when successfully adding
            //function response_success() {
            //    winaddcomputer.close();
            //    computer_store.load();
            //};
            //show this window
            winaddcomputer.show();
        }
    }
})();

// vim: ts=4 sw=4 expandtab
