/* Copyright (C) 2010-2012 Team Gaspacho (see README for all contributors)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

Ext.namespace("GASP");

GASP.addgroup = (function() {
    //store for group user
    var user_store = new Ext.data.Store({
        reader: new Ext.data.JsonReader({
            root: 'data',
            successProperty: 'success',
        },[
            {name : 'id'},
            {name : 'user'},
            {name : 'type'},
            {name : 'activate'}
        ]),
        url: 'get/users',
        pruneModifiedRecords: true
    });
    function get_modified_elt(store){
        var values = {};
        var rec = store.getModifiedRecords();
        for (var i = 0; i < rec.length; i++) {
            //verify modified record is really modified
            //(if active and desactive a value)
            if (rec[i].data.activate != rec[i].modified.activate) {
                values[rec[i].data.id] = rec[i].data.activate;
            }
        };
        return Ext.util.JSON.encode(values)
    };
    return {
        open: function(selectid){
            /* Open a new window for adding or modify a group
             * if add, parent node is specified, else current group is specified
             *
             * This window has two parts:
             * - a form for name, comment, template, ...
             * - a grid for user group
             * - a grid for software
             */

            //store
            user_store.removeAll();
            user_store.baseParams = {groupid: selectid};
            user_store.load();
            //store for software
            var software_store = new Ext.data.Store({
                reader: new Ext.data.JsonReader({
                    root: 'data',
                    successProperty: 'success',
                },[
                    {name : 'id'},
                    {name : 'software'},
                    {name : 'activate'}
                ]),
                baseParams: {groupid: selectid},
                url: 'get/softwares',
                pruneModifiedRecords: true
            });
            software_store.load();
            //store for os
            var os_store = new Ext.data.Store({
                reader: new Ext.data.JsonReader({
                    root: 'data',
                    successProperty: 'success',
                },[
                    {name : 'id'},
                    {name : 'os'},
                    {name : 'activate'}
                ]),
                baseParams: {groupid: selectid},
                pruneModifiedRecords: true,
                url: 'get/oses'
            });
            os_store.load();
            //store for manager
            var manager_store = new Ext.data.Store({
                reader: new Ext.data.JsonReader({
                    root: 'data',
                    successProperty: 'success',
                },[
                    {name : 'id'},
                    {name : 'manager'},
                    {name : 'type'},
                    {name : 'activate'}
                ]),
                baseParams: {groupid: selectid},
                pruneModifiedRecords: true,
                url: 'get/managers'
            });
            manager_store.load();
            //store for template
            var template_store = new Ext.data.Store({
                reader: new Ext.data.JsonReader({
                    root: 'data',
                    successProperty: 'success',
                },[
                    {name : 'id'},
                    {name : 'template'},
                    {name : 'activate'}
                ]),
                baseParams: {groupid: selectid},
                pruneModifiedRecords: true,
                url: 'get/templates'
            });
            template_store.load();
            //store for computer
            var computer_store = new Ext.data.Store({
                reader: new Ext.data.JsonReader({
                    root: 'data',
                    successProperty: 'success',
                },[
                    {name : 'id'},
                    {name : 'computer'},
                    {name : 'type'}
                ]),
                baseParams: {groupid: selectid},
                pruneModifiedRecords: true,
                url: 'get/computers'
            });
            computer_store.load();
            /* 
             * function
             */
            
            function get_elt_from_store(store) {
                var values = [];
                store.each(
                    function (rec){
                        if (rec.get('activate') == true) {
                            values.push(rec.get('id'));
                        }
                    }
                );
                return Ext.util.JSON.encode(values)
            }
            function save_or_modify_group() {
                /* When clicked on save-mod button
                 * Can adding (selectid == null) or modify
                 */

                //when clic on save-mod button

                //create new group
                if (selectid == null) {
                    //get parent
                    nodeid = GASP.group.getSelectedId();
                    //if no selection, set 'src'
                    if (!nodeid) {nodeid = 'src'}

                    //send form + grids
                    group_basicform = group_form.getForm();

                    var computer_elt = [];
                    computer_store.each(
                        function (rec){
                            computer_elt.push({'id': rec.get('id'), 'name': rec.get('computer'), 'type': rec.get('type')})
                        }
                    );
                    if (group_basicform.isValid()) {
                        group_basicform.submit({
                            url: 'add/group',
                            params: {
                                node: nodeid,
                                users: get_elt_from_store(user_store),
                                softwares: get_elt_from_store(software_store),
                                oses: get_elt_from_store(os_store),
                                managers: get_elt_from_store(manager_store),
                                templates: get_elt_from_store(template_store),
                                computers: Ext.util.JSON.encode(computer_elt)
                            },
                            success: response_success
                        });
                    } else {
                        if (Ext.getCmp('groupname').getValue() == '') {
                            GASP.observable.displayError(Ext.i18n.please_set_groupname)
                        } else {
                            GASP.observable.displayError(Ext.i18n.please_set_all_values)
                        }
                    };
                } else {
                    //modified group
                    //if need confirmation to delete usergroup
                    var is_delete = false;

                    //get usergroup grid
                    var users_content = {};
                    var rec = user_store.getModifiedRecords();
                    for (var i = 0; i < rec.length; i++) {
                        var activate = rec[i].data.activate;
                        if (activate != rec[i].modified.activate) {
                            if(activate == false) {
                                is_delete = true
                            };
                            users_content[rec[i].data.id] = activate
                        }
                    };
                    if (is_delete == true) {
                        //display confirmation to delete
                        Ext.MessageBox.show({
                            title: Ext.i18n.confirm_delete_title,
                            msg: Ext.i18n.confirm_delete_usergroup,
                            buttons: Ext.MessageBox.YESNO,
                            fn: function(btn){
                                if (btn == 'yes') {
                                    //send data if choice 'yes'
                                    send_modified_usergroup(users_content)
                                }
                            },
                            animEl: 'mb4',
                            icon: Ext.MessageBox.QUESTION,
                        });
                    } else {
                        //no confirmation needed
                        send_modified_usergroup(users_content)
                    }
                }
            };
            
            function display_hide_softwares(obj, resp){
                if (resp == true){
                    software_grid.setDisabled(false)
                } else {
                    software_grid.setDisabled(true)
                }
            };

            function display_hide_oses(obj, resp){
                if (resp == true){
                    os_grid.setDisabled(false)
                } else {
                    os_grid.setDisabled(true)
                }
            };

            function display_hide_templates(obj, resp){
                if (resp == false){
                    template_grid.setDisabled(false);
                    computer_panel.setDisabled(false);
                    Ext.getCmp('addgroup_installpkg').enable();
                } else {
                    template_grid.setDisabled(true);
                    computer_panel.setDisabled(true);
                    Ext.getCmp('addgroup_installpkg').disable();
                }
            };

            //if cancel, just close this window
            function cancel_group(){
                winaddgroup.close()
            };

            function send_modified_usergroup(users_content){
                /* Send usergroup when modify
                 */

                var computer_elt = [];
                computer_store.each(
                    function (rec){
                        computer_elt.push({'id': rec.get('id'), 'name': rec.get('computer'), 'type': rec.get('type')})
                    }
                );
                group_basicform = group_form.getForm();
                if (group_basicform.isValid()) {
                    group_basicform.submit({
                        url: 'set/group',
                        params: {
                            node: selectid,
                            users: Ext.util.JSON.encode(users_content),
                            softwares: get_modified_elt(software_store),
                            oses: get_modified_elt(os_store),
                            managers: get_modified_elt(manager_store),
                            templates: get_modified_elt(template_store),
                            computers: Ext.util.JSON.encode(computer_elt)
                        },
                        success: response_success
                    });
                } else {
                    if (Ext.getCmp('groupname').getValue() == '') {
                        GASP.observable.displayError(Ext.i18n.please_set_groupname)
                    } else {
                        GASP.observable.displayError(Ext.i18n.please_set_all_values)
                    }
                };
            };
            
            //when successfully adding, modify, ...
            function response_success() {
                winaddgroup.close();
                GASP.observable.fireEvent('reloadGroups');
            };

            /*
             * Interface
             */

            //main form (name, comment, template, ...)
            var group_form = new Ext.FormPanel({
                labelWidth: 250, // label settings here cascade unless overridden
                border: false,
                title: Ext.i18n.addgroup_generaltab,
                defaultType: 'textfield',
                items: [{
                    fieldLabel: Ext.i18n.addgroup_name,
                    id: 'groupname',
                    name: 'name',
                    allowBlank: false
                }, {
                    fieldLabel: Ext.i18n.addgroup_comment,
                    name: 'comment',
                }, {
                    xtype: "checkbox",
                    id: 'addgroup_installpkg',
                    fieldLabel: Ext.i18n.addgroup_installpkg,
                    name: 'installpkg',
                }, {
                    xtype: "checkbox",
                    id: 'addgroup_template',
                    fieldLabel: Ext.i18n.addgroup_template,
                    name: 'template',
                    handler: display_hide_templates
                }, {
                    xtype: "checkbox",
                    id: 'addgroup_softwares',
                    fieldLabel: Ext.i18n.addgroup_only_list_softwares,
                    name: 'software',
                    handler: display_hide_softwares
                }, {
                    xtype: "checkbox",
                    id: 'addgroup_oses',
                    fieldLabel: Ext.i18n.addgroup_only_list_oses,
                    name: 'os',
                    handler: display_hide_oses
                }]
            });

            //add a new user
            function add_new_user() {
                GASP.adduser.open(user_store, manager_store);
            };
            //column for adding user group to a new or modified group
            var user_activate_column = new Ext.grid.GASPCheckColumn({
                header: '', 
                dataIndex: 'activate', 
                width: 24,
                threeStick: false
            });
            function delete_user(del_grid, del_store) {
                //if selected, ask confirmation
                if (del_grid.getSelectionModel().hasSelection()) {
                    Ext.MessageBox.show({
                        title: Ext.i18n.confirm_delete_title,
                        msg: Ext.i18n.confirm_delete_user,
                        buttons: Ext.MessageBox.YESNO,
                        fn: function(btn) {
                            sel_record = del_grid.getSelectionModel().getSelected();
                            confirm_delete_group(btn, sel_record.id, sel_record.data.id)
                        },
                        animEl: 'mb4',
                        icon: Ext.MessageBox.QUESTION,
                    });
                }else{
                    GASP.observable.displayError(Ext.i18n.error_selection)
                }
            };
            function confirm_delete_group(btn, del_id, gasp_id){
                if (btn == 'yes') {
                    record1 = user_store.getById(del_id);
                    record2 = manager_store.getById(del_id);
                    Ext.Ajax.request({
                        url: 'del/user',
                        success: function(response) {
                            jresponse = Ext.util.JSON.decode(response.responseText)
                            if (jresponse.success == true) {
                                user_store.remove(record1);
                                manager_store.remove(record2);
                            }
                        },
                        params: {userid: gasp_id}
                    });
                };
            };
            //
            function delete_computer() {
                //if selected, ask confirmation
                if (computer_grid.getSelectionModel().hasSelection()) {
                    Ext.MessageBox.show({
                        title: Ext.i18n.confirm_delete_title,
                        msg: Ext.i18n.confirm_delete_computer,
                        buttons: Ext.MessageBox.YESNO,
                        fn: confirm_delete_computer,
                        animEl: 'mb4',
                        icon: Ext.MessageBox.QUESTION,
                    });
                }else{
                    GASP.observable.displayError(Ext.i18n.error_selection)
                }
            };
            function confirm_delete_computer(btn, text, opt){
                if (btn == 'yes') {
                    record = computer_grid.getSelectionModel().getSelected();
                    computer_store.remove(record);
                    //Ext.Ajax.request({
                    //    url: 'del/computer',
                    //    success: function() {
                    //        computer_store.remove(record);
                    //    },
                    //    params: {
                    //        computerid: record.get('id'),
                    //        groupid: selectid
                    //    }
                    //});
                };
            };
            //grid for user group
            var user_grid = new Ext.grid.GridPanel({
                border: false,
                title: Ext.i18n.addgroup_usertab,
                plugins: user_activate_column,
                store: user_store,
                colModel: new Ext.grid.ColumnModel({
                    columns: [
                        user_activate_column,
                        {id: 'user', header: Ext.i18n.addgroup_user, sortable: true, dataIndex: 'user'},
                        {id: 'type', header: Ext.i18n.addgroup_user_type, sortable: true, dataIndex: 'type'},
                    ],
                    defaults: {
                        sortable: true,
                    },
                }),
                //singleSelect
                sm: new Ext.grid.RowSelectionModel({
                    singleSelect:true,
                }),
                enableColumnHide: false,
                bbar:[{
                    //add new group
                    id: 'add-but-user',
                    iconCls: 'x-gaspacho-add',
                    text: Ext.i18n.add,
                    handler: add_new_user
                }, {
                    //delete selected group
                    id: 'del-but-user',
                    iconCls: 'x-gaspacho-del',
                    text: Ext.i18n.delete,
                    handler: function() {delete_user(user_grid, user_store)}
                }]
            });

            //column for adding software to a new or modified group
            var software_activate_column = new Ext.grid.GASPCheckColumn({
                header: '', 
                dataIndex: 'activate', 
                width: 24,
                threeStick: false
            });
            //grid for software
            software_grid = new Ext.grid.GridPanel({
                border: false,
                title: Ext.i18n.addgroup_softwaretab,
                disabled: true,
                plugins: software_activate_column,
                store: software_store,
                colModel: new Ext.grid.ColumnModel({
                    columns: [
                        software_activate_column,
                        {id: 'software', header: Ext.i18n.addgroup_software, sortable: true, dataIndex: 'software'}
                    ],
                    defaults: {
                        sortable: true,
                    },
                }),
                //singleSelect
                sm: new Ext.grid.RowSelectionModel({
                    singleSelect:true,
                }),
                enableColumnHide: false
            });

            //column for adding os to a new or modified group
            var os_activate_column = new Ext.grid.GASPCheckColumn({
                header: '', 
                dataIndex: 'activate', 
                width: 24,
                threeStick: false
            });
            //grid for os
            var os_grid = new Ext.grid.GridPanel({
                border: false,
                title: Ext.i18n.addgroup_ostab,
                plugins: os_activate_column,
                disabled: true,
                store: os_store,
                colModel: new Ext.grid.ColumnModel({
                    columns: [
                        os_activate_column,
                        {id: 'os', header: Ext.i18n.addgroup_os, sortable: true, dataIndex: 'os'}
                    ],
                    defaults: {
                        sortable: true,
                    },
                }),
                //singleSelect
                sm: new Ext.grid.RowSelectionModel({
                    singleSelect:true,
                }),
                enableColumnHide: false
            });

            //column for adding manager to a new or modified group
            var manager_activate_column = new Ext.grid.GASPCheckColumn({
                header: '', 
                dataIndex: 'activate', 
                width: 24,
                threeStick: false
            });
            //grid for manager
            var manager_grid = new Ext.grid.GridPanel({
                border: false,
                title: Ext.i18n.addgroup_managertab,
                plugins: manager_activate_column,
                store: manager_store,
                colModel: new Ext.grid.ColumnModel({
                    columns: [
                        manager_activate_column,
                        {id: 'manager', header: Ext.i18n.addgroup_manager, sortable: true, dataIndex: 'manager'},
                        {id: 'type', header: Ext.i18n.addgroup_user_type, sortable: true, dataIndex: 'type'}
                    ],
                    defaults: {
                        sortable: true,
                    },
                }),
                //singleSelect
                sm: new Ext.grid.RowSelectionModel({
                    singleSelect:true,
                }),
                bbar:[{
                    //add new group
                    id: 'add-but-manager',
                    iconCls: 'x-gaspacho-add',
                    text: Ext.i18n.add,
                    handler: add_new_user
                }, {
                    //delete selected group
                    id: 'del-but-manager',
                    iconCls: 'x-gaspacho-del',
                    text: Ext.i18n.delete,
                    handler: function() {delete_user(manager_grid, manager_store)}
                }],
                enableColumnHide: false
            });

            //column for adding template to a new or modified group
            var template_activate_column = new Ext.grid.GASPCheckColumn({
                header: '', 
                dataIndex: 'activate', 
                width: 24,
                threeStick: false
            });
            //grid for template
            var template_grid = new Ext.grid.GridPanel({
                border: false,
                title: Ext.i18n.addgroup_templatetab,
                plugins: template_activate_column,
                store: template_store,
                colModel: new Ext.grid.ColumnModel({
                    columns: [
                        template_activate_column,
                        {id: 'template', header: Ext.i18n.addgroup_template, sortable: true, dataIndex: 'template'},
                    ],
                    defaults: {
                        sortable: true,
                    },
                }),
                //singleSelect
                sm: new Ext.grid.RowSelectionModel({
                    singleSelect:true,
                }),
                enableColumnHide: false
            });

            //grid for computer
            var computer_grid = new Ext.grid.GridPanel({
                border: false,
                flex: 1,
                store: computer_store,
                colModel: new Ext.grid.ColumnModel({
                    columns: [
                        {id: 'computer', header: Ext.i18n.addgroup_computer, sortable: true, dataIndex: 'computer'},
                        {id: 'type', header: Ext.i18n.addgroup_user_type, sortable: true, dataIndex: 'type'},
                    ],
                    defaults: {
                        sortable: true,
                    },
                }),
                //singleSelect
                sm: new Ext.grid.RowSelectionModel({
                    singleSelect:true,
                }),
                bbar:[{
                    //add new group
                    id: 'add-but-computer',
                    iconCls: 'x-gaspacho-add',
                    text: Ext.i18n.add,
                    handler: add_new_computer
                }, {
                    //delete selected group
                    id: 'del-but-computer',
                    iconCls: 'x-gaspacho-del',
                    text: Ext.i18n.delete,
                    handler: delete_computer
                }],
                enableColumnHide: false
            });
            function add_new_computer() {
                GASP.addcomputer.open(computer_store);
            };
            var add_computer_panel = new Ext.FormPanel({
                layout: 'hbox',
                height: 200,
                border: false,
                defaultType: 'textfield',
                items: [{
                    name: 'computer_name',
                    allowBlank: false
                }, {
                    name: 'computer_type',
                    allowBlank: false
                }]
            });
            var computer_panel = new Ext.Panel({
                title: Ext.i18n.addgroup_computertab,
                layout: 'vbox',
                items: [computer_grid]//, add_computer_panel]
            });

            //main tabpanel
            var tp = new Ext.TabPanel({
                activeTab: 0,
                //layout: 'fit',
                items: [group_form, manager_grid, user_grid, computer_panel, software_grid, os_grid, template_grid]
            });

            //window
            winaddgroup = new Ext.Window({
                title: Ext.i18n.addgroup_title,
                height: 300,
                width: 500,
                layout: 'fit',
                closable: false,
                resizable: false,
                modal: true,
                border: true,
                items: tp,
                layoutConfig: {
                    align : 'stretch',
                    pack  : 'start',
                },
                buttons: [{
                    text: Ext.i18n.cancel,
                    handler: cancel_group
                },{
                    id: 'save-mod',
                    formBind: true,
                    handler: save_or_modify_group
                }]
            });

            //set the save-mod button text
            savemod = Ext.getCmp('save-mod');
            if (selectid == null) {
                savemod.text = Ext.i18n.add
            } else {
                savemod.text = Ext.i18n.modify
            };

            if (selectid != null) {
                //if modify, load form
                group_form.getForm().load({
                    url: 'get/property',
                    params: {groupid: selectid}
                });
                //disable addgroup_template
                Ext.getCmp('addgroup_template').disable();
            }

            //show this window
            winaddgroup.show();
        }
    }
})();

// vim: ts=4 sw=4 expandtab
