/* Copyright (C) 2010 Team Gaspacho (see README for all contributors)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

Ext.namespace("GASP");

GASP.adduser = (function() {
    return {
        open: function(store_1, store_2){
            //when successfully adding, modify, ...
            //function response_success() {
            //    win.close();
            //    GASP.observable.fireEvent('reloadGroups');
            //};

            /*
             * Interface
             */
            usertype_store = new Ext.data.SimpleStore({
                fields: ['usertype', 'displaytype'],
                data: [
                    ['user', Ext.i18n.user],
                    ['usergroup', Ext.i18n.usergroup]
                ]
            });

            //main form 
            var user_form = new Ext.FormPanel({
                //labelWidth: 75, // label settings here cascade unless overridden
                border: false,
                defaultType: 'textfield',
                items: [{
                    fieldLabel: Ext.i18n.adduser_name,
                    name: 'name',
                    allowBlank: false
                },{
                    xtype: 'combo',
                    fieldLabel: Ext.i18n.usertype,
                    name: 'usertype',
                    valueField: 'usertype',
                    displayField: 'displaytype',
                    hiddenName: 'usertype',
                    store: usertype_store,
                    mode: 'local',
                    triggerAction: 'all',
                    editable: false,
                    forceSelection: true,
                    typeAhead: true,
                    allowBlank: false,
                    value: 'user'
                }]
            });

            //window
            winadduser = new Ext.Window({
                title: Ext.i18n.adduser_title,
                height: 200,
                width: 400,
                layout: 'fit',
                closable: false,
                resizable: false,
                modal: true,
                border: true,
                items: user_form,
                layoutConfig: {
                    align : 'stretch',
                    pack  : 'start',
                },
                buttons: [{
                    text: Ext.i18n.cancel,
                    handler: cancel_user
                },{
                    text: Ext.i18n.ok,
                    id: 'save-but-user',
                    formBind: true,
                    handler: save_user
                }]
            });

            function cancel_user(){
                winadduser.close()
            };
            function save_user() {
                user_form.getForm().submit({
                    url: 'add/user',
                    success: response_success
                });
            };

            //when successfully adding
            function response_success() {
                winadduser.close();
                store_1.load();
                store_2.load();
                //user_store.load();
                //manager_store.load()
                //store_1.add(new Ext.data.Record({
                //    'computer': Ext.getCmp('computer_name').getValue(),
                //    'type': Ext.getCmp('computer_type').getValue()}));
                //store_2.add(new Ext.data.Record({
                //    'computer': Ext.getCmp('computer_name').getValue(),
                //    'type': Ext.getCmp('computer_type').getValue()}));
            };
            //show this window
            winadduser.show();
        }    }
})();

// vim: ts=4 sw=4 expandtab
