/* Copyright (C) 2010 Team Gaspacho (see README for all contributors)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

Ext.namespace("GASP");

GASP.category = (function() {
    /*
     * Private
     */

    /*
     * FUNCTION
     */
    //this var is use to reselect a category when reload store
    var selid = null;

    function reload_category() {
        //if a category was selected, try to reselect this category
        if (selid != null) {
            index = cat_store.findExact('id', selid);
            if (index != -1) {
                gridcat.getSelectionModel().selectRow(index)
            }
        };
        selid = null
    };

    function select_category(sm, rowIndex, extDataRecord){
        //when a category is selected, reload rules
        GASP.observable.fireEvent('reloadRules');
    }
    /*
     * STORE
     */
    var cat_store = new Ext.data.Store({
        url: 'get/categories',
        reader: new Ext.data.JsonReader({
            root :'data',
            fields: [
                {name : 'text'},
                {name : 'id'}
            ]
        }),
        listeners: {
            'load': reload_category
        }
    });

    /*
     * UI
     */
    var gridcat = new Ext.grid.GridPanel({
        id: 'gridCategory',
        region: 'west',
        layout: 'fit',
        title: Ext.i18n.category_category,
        split: true,
        width: 200,
        autoScroll: true,
        store: cat_store,
        columns: [
            {id: 'text', header: "category", dataIndex: 'text'}
        ],
        viewConfig: {
           forceFit: true,
        },
	    sm: new Ext.grid.RowSelectionModel({
            singleSelect:true,
            listeners: {
                'rowselect': select_category
            }
        }),
        hideHeaders: true,
        enableColumnHide: false,
        stripeRows: true
    });


    /*
     * Public
     */

    return {
        disable: function() {
            gridcat.disable()
        },

        enable: function() {
            gridcat.enable()
        },

        get: function() {
            return gridcat;
        },

        clean: function() {
            cat_store.removeAll();
        },

        reload: function(groupid) {
            if (gridcat.getSelectionModel().hasSelection()) {
                selid = gridcat.getSelectionModel().getSelected().get('id');
            };
            this.clean()
            if (groupid != null) {
                cat_store.baseParams={groupid: groupid}
                cat_store.load();
            };

        },

        getSelectedId: function() {
            if (gridcat.getSelectionModel().hasSelection()) {
                return gridcat.getSelectionModel().getSelected().get('id');
            } else {
                return null
            }
        }
    };
})();

// vim: ts=4 sw=4 expandtab
