/* Copyright (C) 2010 Team Gaspacho (see README for all contributors)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

Ext.namespace("GASP");

GASP.group = (function() {
    /*
     * Private
     */

    /* 
     * Functions
     */
    var treeloader = new Ext.tree.TreeLoader({
            dataUrl:'get/groups'
    });
    //when tree is loading
    function load_tree() {
        this.getRootNode().expand();
        if (Ext.util.Cookies.get('level') != 'manager') {
            Ext.getCmp('add-but').enable()
        };
    };

    //when selection change
    function selection_change() {
        getsel = treegroup.getSelectionModel().getSelectedNode();
        if (getsel) {
            //expand selected Group
            getsel.expand();
        };
        //disabled/enabled del/mod button
        if (Ext.util.Cookies.get('level') != 'manager') {
            if (getsel == null || getsel.attributes.cls == 'usergroup' || getsel.attributes.cls == 'user') {
                Ext.getCmp('del-but').disable();
                Ext.getCmp('mod-but').disable();
            } else {
                Ext.getCmp('del-but').enable();
                Ext.getCmp('mod-but').enable();
            };
        };
        //and reload Category
        if (getsel == null || getsel.attributes.readable == false) {
            GASP.observable.fireEvent('cleanCategories');
        } else {
            if (getsel.attributes.readable == false) {
                GASP.observable.fireEvent('cleanCategories');
                GASP.observable.displayInfo(Ext.i18n.not_allow_for_this_group)
            } else {
                GASP.observable.fireEvent('reloadCategories')
            }
        }
    };

    //when someone has reorder group with drag'n drop
    function reorder_group() {
        GASP.observable.fireEvent('reorderGroup');
    };
    function cancel_reorder_group() {
        GASP.observable.fireEvent('reloadGroups');
    };
    function save_reorder_group() {
        GASP.observable.fireEvent('saveGroup');
    };

    //add a new group
    function add_new_group() {
        GASP.addgroup.open();
    };

    //modify a selected group
    function modify_group() {
        GASP.addgroup.open(GASP.group.getSelectedId())
    };

    //delete a selected group
    function delete_group() {
        //if selected, ask confirmation
        if (treegroup.getSelectionModel().getSelectedNode()) {
            Ext.MessageBox.show({
                title: Ext.i18n.confirm_delete_title,
                msg: Ext.i18n.confirm_delete,
                buttons: Ext.MessageBox.YESNO,
                fn: confirm_delete_group,
                animEl: 'mb4',
                icon: Ext.MessageBox.QUESTION,
            });
        }else{
            GASP.observable.displayError(Ext.i18n.error_selection)
        }
    };
    function confirm_delete_group(btn, text, opt){
        if (btn == 'yes') {
            Ext.Ajax.request({
                url: 'del/group',
                success: function() {
                    GASP.observable.fireEvent('reloadGroups');
                },
                params: {id: treegroup.getSelectionModel().getSelectedNode().id}
            });
        };
    };

    /*
     * UI
     */
    var treegroup = new Ext.tree.TreePanel({
        id: 'treegroups',
        title: Ext.i18n.group_group,
        width: 200,
        split: true,
        region: "west",
        layout: "fit",
        autoScroll: true,
        animate: true,
        enableDD: true,
        loader: treeloader,
        rootVisible: false,
        root: {
            nodeType: 'async',
            text: 'groups',
            draggable: false,
            expanded: true,
            id: 'src'
        },
        listeners: {
            'load': load_tree, 
            'dragdrop': reorder_group

        },
        selModel: new Ext.tree.DefaultSelectionModel({
            listeners: {
                'selectionchange': selection_change
            }
        }),
        bbar:[{
            //cancel reordered Group
            id: 'gcancel-but',
            iconCls: 'x-gaspacho-cancel',
            text: Ext.i18n.cancel,
            handler: cancel_reorder_group
        }, {
            //save reordered Group
            id: 'gsave-but',
            iconCls: 'x-gaspacho-save',
            text: Ext.i18n.save,
            handler: save_reorder_group
        }, {
            //add new group
            id: 'add-but',
            iconCls: 'x-gaspacho-add',
            disabled: true,
            text: Ext.i18n.add,
            handler: add_new_group
        }, {
            //modify a selected group
            id: 'mod-but',
            disabled: true,
            iconCls: 'x-gaspacho-mod',
            text: Ext.i18n.modify,
            handler: modify_group
        }, {
            //delete selected group
            id: 'del-but',
            disabled: true,
            iconCls: 'x-gaspacho-del',
            text: Ext.i18n.delete,
            handler: delete_group
        }]
    });
    //gsave-but and gcancel-but is only use for save order
    //those buttons is only displayed when drag and drop
    Ext.getCmp('gsave-but').hide();
    Ext.getCmp('gcancel-but').hide();
    /*
     * Public
     */

    return {
        disable: function() {
            //disable the tree
            treegroup.disable()
        },

        enable: function() {
            //enable the tree
            treegroup.enable()
        },

        get: function() {
            //get tree
            return treegroup;
        },

        dragdropDisable: function() {
            Ext.getCmp('add-but').hide();
            Ext.getCmp('mod-but').hide();
            Ext.getCmp('del-but').hide();
            Ext.getCmp('gsave-but').show();
            Ext.getCmp('gcancel-but').show();
        },

        dragdropEnable: function() {
            Ext.getCmp('add-but').show();
            Ext.getCmp('mod-but').show();
            Ext.getCmp('del-but').show();
            Ext.getCmp('gsave-but').hide();
            Ext.getCmp('gcancel-but').hide();
        },
        getSelectedId: function() {
            getsel = treegroup.getSelectionModel().getSelectedNode()
            if (getsel != null) {
                return getsel.id
            } else {
                return null
            }
        },
        load: function() {
            //reselect a selected item when reload
            Ext.getCmp('del-but').disable();
            Ext.getCmp('mod-but').disable();
            getsel = treegroup.getSelectionModel().getSelectedNode();
            if (getsel != null) {
                sel = getsel.getPath()
            };
            treegroup.getRootNode().reload(); 
            if (getsel != null) {
                treegroup.selectPath(sel)
            }
        },
        childsnode: function(node) {
            if (node == null) {
                node = treegroup.getRootNode();
            };
            var ret = {};
            var i = 0;
            node.eachChild(
                function(n) {
                    //for group + template
                    //n.leaf == false
                    //but only template
                    if (n.attributes.cls == 'group') {
                        ret[n.id] = {'level': i, 'children': this.childsnode(n)};
                        i++;
                    };
                }, this
            );
            return ret;
        }

    };
})();

// vim: ts=4 sw=4 expandtab
