/* Copyright (C) 2010 Team Gaspacho (see README for all contributors)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

Ext.namespace("GASP");

(function() {

    //translate loading message
    Ext.get('waiter-msg').update(Ext.i18n.loading);
    Ext.onReady(function() {
        GASP.apply_button = new Ext.Button({
            text: Ext.i18n.apply,
            handler: function (){
                GASP.observable.fireEvent('apply');
            }
        });
        var viewport = new Ext.Viewport({
            layout: 'fit',
            items: [{
                xtype: 'panel',
                layout: 'border',
                border: false,
                items: [{
                    region: 'north',
                    layout: 'fit',
                    height: 55,
                    border: false,
                    html: '<div id="x-gaspacho-header" style="width: 100%; height: 100%"> </div>'
                },
                    GASP.group.get(),
                {
                    title: Ext.i18n.main_rules_title,
                    region: 'center',
                    xtype: 'panel',
                    layout: 'border',
                    border: false,
                    items: [
                        GASP.category.get(),
                        GASP.rule.get()
                    ]
                }],
                bbar: new Ext.ux.StatusBar({
                    defaultText: Ext.i18n.ready,
                    //defaultIconCls: 'x-status-valid',
                    id: 'statusbar',
                    busyText: Ext.i18n.loading,
                    items: [GASP.apply_button,
                        '-',
                        {
                            //iconCls: 'x-gaspacho-logout',
                            text: Ext.i18n.about_link,
                            handler: function (){
                                GASP.about.open();
                            }
                        },
                        '-',
                        {
                            iconCls: 'x-gaspacho-logout',
                            handler: function (){
                                GASP.observable.fireEvent('logout');
                            }
                        }
                    ]
                })
            }]
        });
    })
})();

// vim: ts=4 sw=4 expandtab
