/* Copyright (C) 2010 Team Gaspacho (see README for all contributors)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

Ext.namespace("GASP");

GASP.login = (function() {
    /*
     * Public
     */

    var loginwin = '';
    return {
        open: function(){
            if (loginwin != '')
                return;
            GASP.observable.fireEvent('login_open');
            login_store = new Ext.data.SimpleStore({
                fields: ['countryCode', 'countryName', 'countryFlag'],
                data: [
                    ['en', 'English', 'x-flag-en'],
                    ['fr', 'Français', 'x-flag-fr'],
                ]
            });
            //Ext.QuickTips.init();
            locale = Ext.util.Cookies.get('lang');
            if (!locale) { locale = 'fr' };
            var login = new Ext.FormPanel({
                labelWidth: 80,
                url: 'log/in',
                frame: true,
                bodyStyle: 'padding:5px;',
                defaultType: 'textfield',
                monitorValid: true,
                items : [{
                    fieldLabel: Ext.i18n.login_user,
                    id: 'user',
                    name: 'user',
                    width: 180,
                    allowBlank: false
                }, {
                    fieldLabel: Ext.i18n.login_password,
                    name: 'password',
                    inputType: 'password',
                    width: 180,
                    allowBlank: false
                }, {
                    xtype: 'flagcombo',
                    fieldLabel: Ext.i18n.login_language,
                    id: 'lang',
                    name: 'lang',
                    hiddenName: 'countryCode',
                    store: login_store,
                    mode: 'local',
                    width: 180,
                    value: locale
                }],

                buttons: [{
                    text: Ext.i18n.login_login,
                    formBind: true,
                    handler: function() {
                        lang = Ext.getCmp('lang').getValue();
                        login.getForm().submit({
                            success: function(form, action) {
                                if (action && action.result) {
                                    Ext.util.Cookies.set("level", action.result.data.level);
                                    if (lang != Ext.util.Cookies.get('lang')) {
                                    //    window.location.search = Ext.urlEncode({"lang": lang});
                                        window.location.reload()
                                        Ext.util.Cookies.set("lang", lang);
                                    } else {
                                        GASP.login.closeWindow();
                                        GASP.observable.fireEvent('reloadGroups')
                                    }
                                }
                            },
                        });
                    }
                }]
            });
            loginwin = new Ext.Window({
                height: 180,
                width: 300,
                layout: 'fit',
                closable: false,
                modal: true,
                border: false,
                title: Ext.i18n.login_title,
                items: [login],
            }).show();
            Ext.getCmp('user').focus(true, 1000)
        },
        closeWindow: function() {
            if (loginwin.close) {
                loginwin.close();
            };
            loginwin = ''
        }
    }
})();

// vim: ts=4 sw=4 expandtab
