/* Copyright (C) 2010 Team Gaspacho (see README for all contributors)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * Group all common gaspacho Event
 * Verify if ajax request:
 * - if session is valid
 * - if a message must to be display
 * - if an error must be display
 */
Ext.namespace("GASP");
GASP.observable = (function() {
    var observable = new Ext.util.Observable();
    observable.addEvents(
        //reload the Groups column
        'reloadGroups',
        //reload the Categories column
        'reloadCategories',
        //reload Rules column
        'reloadRules',
        //if user change something in rules column
        'ruleChanged',
        //if user save modified rules
        'saveRules'
    );
    var waiter_time = 0;
    var statusbar = Ext.getCmp('statusbar');

    observable.on({
        'reloadGroups': function() {
            GASP.category.enable();
            GASP.rule.enable();
            GASP.apply_button.enable();
            GASP.group.dragdropEnable();
            GASP.group.load();
            GASP.category.clean();
            GASP.rule.clean()
        },
        'reloadCategories': function() {
            GASP.rule.clean();
            GASP.category.reload(GASP.group.getSelectedId())
        },
        'cleanCategories': function() {
            GASP.rule.clean();
            GASP.category.clean()
        },
        'reloadRules': function() {
            GASP.group.enable();
            GASP.category.enable();
            GASP.apply_button.enable();
            GASP.rule.btnDisable();
            GASP.rule.clean();
            GASP.rule.load(GASP.group.getSelectedId(), GASP.category.getSelectedId())
        },
        'ruleChanged': function(options){
            GASP.group.disable();
            GASP.category.disable();
            GASP.apply_button.disable();
            GASP.rule.btnEnable()
        },
        'saveRules': function() {
            GASP.group.enable();
            GASP.category.enable();
            GASP.apply_button.enable();
            GASP.rule.btnDisable();
        },
        'reorderGroup': function() {
            GASP.category.disable();
            GASP.rule.disable();
            GASP.apply_button.disable();
            GASP.group.dragdropDisable();
        },
        'saveGroup': function() {
            GASP.category.enable();
            GASP.rule.enable();
            GASP.apply_button.enable();
            GASP.group.dragdropEnable();
            Ext.Ajax.request({
                url: 'set/levels',
                success: function() { GASP.observable.fireEvent('reloadGroups')},
                params: {groups: Ext.util.JSON.encode(GASP.group.childsnode())}
            });
        },
        'login_open': function() {
            GASP.rule.untoggle()
        },
        'logout': function() {
            Ext.Ajax.request({
                url: 'log/out',
            });
            GASP.observable.fireEvent('reloadGroups');
        },
        'apply': function() {
            Ext.Ajax.request({
                url: 'set/apply',
            });
        },
    });
    //before request, show waiter
    Ext.Ajax.on('beforerequest', function() {
        if (statusbar == null) {
            statusbar = Ext.getCmp('statusbar');
        }
        waiter_time++;
        statusbar.showBusy()
    }, this);
    //if exception in request
    Ext.Ajax.on('requestexception', function(conn, response, options) {
        if (response.status === 0) {
            msg = Ext.i18n.observable_server_unreachable
        } else {
            msg = Ext.i18n.observable_http_error + response.status +' (' + response.statusText + ')'
        };
        GASP.observable.displayError(msg);
    }, this);
    //request complete
    Ext.Ajax.on('requestcomplete', function(conn, response, options) {
        send_clear = true;
        jresponse = Ext.util.JSON.decode(response.responseText)
        if (jresponse.authentification == false) {
            GASP.login.open();
            waiter_time = 0;
        };
        if (jresponse.success == false) {
            message = Ext.i18n.python[jresponse.message];
            if (!message) {
                message = jresponse.message
            };
            GASP.observable.displayError(message);
            send_clear = false
        } else {
            if (jresponse.message) {
                message = Ext.i18n.python[jresponse.message];
                if (!message) {
                    message = jresponse.message
                };
                send_clear = false;
                GASP.observable.displayInfo(message);
            }
        };
        if (send_clear) {
            GASP.observable.displayClear();
        } else {
            waiter_time=waiter_time-1;
        }
    }, this);
    return {
        fireEvent: function(eventname, params) {
            //fireEvent in observable
            //console.log(eventname);
            observable.fireEvent(eventname, params)
        },
        displayError: function(message) {
            statusbar.setStatus({
                text: message,
                iconCls: 'x-status-error'
            });
            Ext.MessageBox.show({
                title: Ext.i18n.observable_error_title, 
                msg: message,
                buttons: Ext.Msg.OK,
                icon: Ext.MessageBox.ERROR
            })
        },
        displayInfo: function(message) {
            statusbar.setStatus({
                text: message,
                iconCls: 'x-status-valid',
                clear: true // auto-clear after a set interval
            })
        }, 
        displayClear: function(message) {
            waiter_time=waiter_time-1;
            if (waiter_time < 1) {
                statusbar.clearStatus({useDefaults:true});
                waiter_time = 0
            } else {
            }
        }
    }
    
})();
// vim: ts=4 sw=4 expandtab
