/* Copyright (C) 2010 Team Gaspacho (see README for all contributors)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

Ext.namespace("GASP");

GASP.rule = (function() {
    /*
     * Private
     */

    /*
     * FUNCTION
     */
    function display_hidden_platforms(btn, pressed) {
        Ext.Ajax.request({
            url: 'set/display_plaforms',
            params: {display: pressed},
            failure: function() {
                //untoggled
                btn.toggle(!pressed, true)
            },
            success: function() {
                GASP.observable.fireEvent('reloadRules')
            }
        });
    };
    Ext.apply(Ext.form.VTypes, {
        no_separator:  function(v,f) {
            if (f.separator != null) {
                alpha = RegExp("^[^"+f.separator+"]+$");
                return alpha.test(v);
            }
            return true;
        },
        no_separatorText: 'separator not allowed in this field'
    });
    function choice_modified(cm, colIndex, action) {
        //if edit a value in rules grid, send event
        if (action == 'edit') {
            GASP.observable.fireEvent('ruleChanged')
        }
    };

    function render_value(val, meta, record) {
        //Display data for column Value
        //if boolean, don't display anything
        //if list or multi, join data

        type = record.get('type');
        //no value for boolean
        if (type != 'boolean' && type != 'integer') {
            //get options column for separator
            options = record.get('options')
            if (type == 'enum') {
                //if type is enum, display text not value
                for (var num = 0, len = options.length; num < len; num++) {
                    if (options[num][0] == val) {
                        val = options[num][1];
                        break;
                    }
                }
            };
            if (type == 'multi' || type == 'list') {
                if (typeof val != 'object') {
                    GASP.observable.displayError(record.get('name')+' '+Ext.i18n.rule_not_an_object);
                };
                //if type is multi or list, display a string not a list
                if (options != null && typeof options['separator'] == 'string'){
                    separator = options['separator']
                }else{
                    separator = '-';
                };
                val = val.join(separator);
            };
            //if value is empty, display a text
            if (val == '') {
                val = Ext.i18n.rule_please_set_a_value;
            };
        };
        //display the value
        return val;
    };

    function choice_cancel_change() {
        storerules.rejectChanges()
        GASP.observable.fireEvent('saveRules')
    };

    function choice_save_change() {
        GASP.rule.sendModifiedRecords()
    };

    /*Fonction for display data if not boolean*/
    function expanded_rule(expander, record){
        //if expanded
        type = record.data.type;
        if (type != 'boolean') {
            //if type is not boolean calc width of the column
            widthelt = Ext.get('gasp-p-0-' + record.data.id).getWidth();
            widthelt = widthelt - Ext.get('gasp-ok-0-' + record.data.id).getWidth();
        }
        if (type == 'list') {
            var options = record.data.options;
            if (options != null && typeof options['separator'] == 'string'){
                separator = options['separator']
            }else{
                separator = '-';
            };
            buildField(record.data.type, record, record.data.options, record.data.value, widthelt, null, separator)
        } else if (type == 'multi') {
            //if multi, add several area
            var options = record.get('options');
            if (options != null && typeof options['separator'] == 'string'){
                separator = options['separator']
            }else{
                separator = '-';
            };
            var opt = options['values'];
            for (var num = 0, len = opt.length; num < len; num++) {
                type = opt[num].type;
                options = opt[num].options;
                value = record.get('value')[num];
                buildField(type, record, options, value, widthelt, num, separator);
            }
        } else if (type != 'boolean') {
            buildField(record.data.type, record, record.data.options, record.data.value, widthelt)
        }
    };

    buildField = function(type, record, options, value, width, num, separator) {
        /* buildField change the input (XTemplate) to a extjs form
         * type: type of the field (for multi set the type of the field)
         * record: grid rows recorder
         * options: column options
         * value: value of the field
         * width of the field (not for integer)
         * num: should be null if not a multi
         * separator:
         */
        if (num == null) {
            tnum = 0
        } else {
            tnum = num
        };
        //get div for list
        div = 'gasp-div-' + tnum + '-' + record.data.id;
        //get input
        input = 'gasp-input-' + tnum + '-' + record.data.id;
        //get buttons
        okbtn = Ext.get('gasp-ok-' + tnum + '-' + record.data.id);
        addbtn = Ext.get('gasp-add-' + tnum + '-' + record.data.id);
        if (type == 'enum') {
            this.buildEnum(record, options, value, width, input, okbtn, num)
        } else if (type == 'integer') {
            this.buildInteger(record, options, value, input, okbtn, num)
        } else if (type == 'list') {
            this.buildList(record, options, value, width, div, input, okbtn, addbtn, num, separator)
        } else if (type != 'boolean') {
            this.buildString(record, value, width, input, okbtn, num, separator)
        };
    };
    buildEnum = function(record, options, value, width, input, okbtn, num) {
        /* builEnum display an enum object
         */
        var enum_store = new Ext.data.ArrayStore({
            fields: ['id', 'name'],
            data: options
        });
        var rowobj=this;
        var combo = new Ext.form.ComboBox({
            store: enum_store,
            displayField: 'name',
            editable: false,
            mode: 'local',
            width: width,
            valueField: 'id',
            value: value,
            allowBlank: false,
            typeAhead: true,
            applyTo: input,
            forceSelection: true,
            triggerAction: 'all',
            //FIXME: can't see field!!
            fieldLabel: Ext.i18n.rule_value + ':',
        });
        okbtn.on('click', function(){
            index = enum_store.find('id', combo.getValue());
            rec = enum_store.getAt(index);
            rowobj.updateRec(record, rec.data.id, num);
        })
     },
     buildInteger = function(record, options, value, input, okbtn, num) {
        /* builInteger display an integer object
         */
        var rowobj=this;
        var spin = new Ext.ux.form.SpinnerField({
            fieldLabel: Ext.i18n.rule_value + ':',
            applyTo: input,
            value: value,
            accelerate: true,
            enableKeyEvents: true,
            listeners:{
                'specialkey': function(obj, e) {
                    if (e.getKey() == e.ENTER) {
                       rowobj.updateRec(record, spin.getValue(), num);
                    }
                },
            }
        });
        if (options != null) {
            if (typeof options.min == 'number') {
                spin.minValue=options.min
            };
            if (typeof options.max == 'number') {
                spin.maxValue=options.max
            }
        };
        okbtn.on('click', function(){
            rowobj.updateRec(record, spin.getValue(), num);
        })
    };
    buildString = function(record, value, width, input, okbtn, num, separator) {
        /* builString display an string object
         */
        var rowobj=this;
        var field = new Ext.form.TextField({
            fieldLabel: Ext.i18n.rule_value + ':',
            value: value,
            applyTo: input,
            enableKeyEvents: true,
            width: width,
            vtype: 'no_separator',
            separator: separator,
            listeners:{
                'specialkey': function(field, e) {
                    if (field.isValid() && e.getKey() == e.ENTER) {
                        rowobj.updateRec(record, field.getValue(), num);
                    }
                }
            }
        });
        okbtn.on('click', function(){
            //test si validateValue()
            rowobj.updateRec(record, field.getValue(), num);
        })
    };

    buildList = function(record, options, value, width, div, input, okbtn, addbtn, num, separator) {
        /* builList display an list object
         */
        width = width - Ext.get(addbtn).getWidth();
        data = []
        if (value != '') {
            for (var tnum = 0, len = value.length; tnum < len; tnum++) {
                data[tnum] = [true, value[tnum]]
            };
        };
        var list_store = new Ext.data.ArrayStore({
            fields: ['delete', 'text'],
            data: data
        });
        var delColumn = new Ext.grid.GASPRowDelete({
            header: "",
            dataIndex: 'delete',
            width: 8,
            iconCls: 'x-gaspacho-check-col',
            resizable: false,
            sortable: false
        });
	    var list_grid = new Ext.grid.GridPanel({
            autoHeight: 'true',
            store: list_store,
            hideHeaders: true,
            columns: [
                {id: 'text', dataIndex: 'text'},
                delColumn
            ],
            plugins: delColumn,
            viewConfig: {
               forceFit: true,
            },
            sm: new Ext.grid.RowSelectionModel({
                singleSelect:true,
                /*listeners: {
                    'rowselect': function(sm, rowIndex, extDataRecord){
                    }
                }*/
            }),
	    });
        list_grid.render(div);
        var field = new Ext.form.TextField({
            fieldLabel: Ext.i18n.rule_value + ':',
            applyTo: input,
            enableKeyEvents: true,
            vtype: 'no_separator',
            separator: separator,
            width: width,
            listeners:{
                'specialkey': function(field, e) {
                    //test si validateValue()
                    if (e.getKey() == e.ENTER) {
                        if (field.isValid() && field.getValue() != '') {
                            var u = new list_store.recordType({text: field.getValue()});
                            list_store.add(u);
                            field.setValue('');
                        }
                    }
                }
            }
        });
        addbtn.on('click', function(){
            //test si validateValue()
            if (field.isValid()) {
                if (field.getValue() != '') {
                    var u = new list_store.recordType({text: field.getValue()});
                    list_store.add(u);
                    field.setValue('');
                }
            }
        });
        var obj = this;
        okbtn.on('click', function(){
            var value = [];
            i=0;
            list_store.each(
                function (rec){
                    value[i] = rec.get('text');
                    i++;
                }
            );
            obj.updateRec(record, value, num);
        })
    };
    updateRec = function(record, value, num) {
        /* updateRec update values in record
         */
        //if multi, change only the num value
        val = value
        if (num != null) {
            origval = record.get('value');
            val = []
            //hack, if a modify directly the object, there is no renderer
            for (var i = 0, len = origval.length; i < len; i++) {
                val[i] = origval[i]
            }
            val[num] = value;
        }
        record.set('value', val);
        //state become true
        record.set('state', true);
        //this rule is no more herited
        record.set('herited', false);
    };
    /*
     * STORE
     */
    var storerules = new Ext.data.GroupingStore({
        url: 'get/rules',
        pruneModifiedRecords: true,
        reader: new Ext.data.JsonReader({
            root :'data',
            fields: [
                {name: 'tagid'},
                {name: 'tag'},
                {name: 'name'},
                {name: 'id'},
                {name: 'options'},
                {name: 'type'},
                {name: 'state'},
                {name: 'value'},
                {name: 'description'},
                {name: 'hstate'},
                {name: 'hvalue'},
                {name: 'herited'},
                {name: 'platforms'},
            ]
        }),
        listeners: {
            'update': choice_modified
        },
        sortInfo: {field: 'tag', direction: "DESC"},
        groupOnSort: true,
        groupField: 'tagid'
    });

    /*
     * UI
     */
    var stateColumn = new Ext.grid.GASPCheckColumn({
        header: "",
        dataIndex: 'state',
        width: 8,
        resizable: false,
        sortable: false
    });

    var heritedColumn = new Ext.grid.GASPCheckColumn({
        header: "",
        dataIndex: 'herited',
        width: 8,
        herited: true,
        iconCls: 'x-gaspacho-check-col',
        resizable: false,
        sortable: false
    });

    var expander = new Ext.ux.grid.RowExpander({
        //construct expand interface
        //display Rule, Platforms and Description (if set)
        //an area is display by value
        //this area has an input and an ok button
        //if type is list, added a div for list box + add button
        //if multi display multiple area
        tpl: new Ext.XTemplate(
            '<p><b>'+Ext.i18n.rule_rule+':</b> {name}</p>',
            '<tpl if="platforms">',
            '<br /><p><b>'+Ext.i18n.rule_platforms+':</b> {platforms}</p>',
            '</tpl>',
            '<tpl if="description">',
            '<br /><p><b>'+Ext.i18n.rule_description+':</b> {description}</p>',
            '</tpl>',
            '<tpl if="type!=\'boolean\'">',
            '<tpl exec="this.index=0"></tpl>',
            '<tpl exec="this.id=id"></tpl>',
            '<tpl exec="this.type=type"></tpl>',
            '<tpl exec="this.type=type"></tpl>',
            '<tpl for="value">',
            '<tpl if="this.type==\'multi\' || this.index < 1">',
            '<br />',
            '<tpl if="this.type==\'list\'">',
            '<div id="gasp-div-{this.index}-{this.id}"></div>',
            '</tpl>',
            '<p id="gasp-p-{this.index}-{this.id}"><input type="text" id="gasp-input-{this.index}-{this.id}"/>',
            '<tpl if="this.type==\'list\'">',
            '<input type="button" id="gasp-add-{this.index}-{this.id}" value="'+Ext.i18n.add+'" />',
            '</tpl>',
            '<input type="button" id="gasp-ok-{this.index}-{this.id}" value="'+Ext.i18n.ok+'" />',
            '</p>',
            '</tpl>',
            '<tpl exec="++this.index"></tpl>',
            '</tpl>',
            '</tpl>'
        ),
        expandOnEnter: false,
        expandOnDblClick: false
    });
    expander.on('expand', expanded_rule);

    var colModel = new Ext.grid.ColumnModel({
        columns: [
            {header: "tag", dataIndex: 'tag', resizable: false, sortable: false},
            expander,
            stateColumn,
            {header: Ext.i18n.rule_rule, id:'name', dataIndex: 'name', sortable: false, resizable: true},
            {header: Ext.i18n.rule_value, id:'value', dataIndex: 'value', width: 30, resizable: false, sortable: false,
                renderer: render_value
            },
            heritedColumn,
        ]
    });

    var gridRules = new Ext.grid.GridPanel({
        id: 'gridRules',
        region: 'center',
        title: Ext.i18n.rule_rule,
        split: true,
        store: storerules,
        colModel: colModel,
        autoScroll: true,
        plugins: [expander, stateColumn, heritedColumn],
        view: new Ext.grid.GroupingView({
            hideGroupedColumn: true,
            forceFit: true,
            showGroupName: false,
            enableNoGroups: false,
            enableGroupingMenu: false,
            //scrollOffset: 0,
            groupTextTpl: '{text} ({[values.rs.length]} '+Ext.i18n.choices+')'
        }),
        hideHeaders: true,
        //expander
        enableColumnHide: false,
        autoExpandColumn: 'name',
        stripeRows: true,
        bbar:[{
            id: 'cancel-but',
            text: Ext.i18n.cancel,
            iconCls: 'x-gaspacho-cancel',
            disabled: true,
            handler: choice_cancel_change
        }, {
            id: 'save-but-choice',
            text: Ext.i18n.save,
            disabled: true,
            iconCls: 'x-gaspacho-save',
            handler: choice_save_change
        }, '->', {
            id: 'platform-but',
            text: Ext.i18n.rule_display_platforms,
            enableToggle: true,
            //tooltip: {title:'Preview Pane',text:'Show or hide the Preview Pane'},
            toggleHandler: display_hidden_platforms
        }],
        sm: new Ext.grid.RowSelectionModel({
            singleSelect:true,
        })
    });

    /*
     * Public
     */
    return {
        btnDisable: function() {
            Ext.getCmp('save-but-choice').disable();
            Ext.getCmp('cancel-but').disable()
        },

        btnEnable: function() {
            Ext.getCmp('save-but-choice').enable();
            Ext.getCmp('cancel-but').enable()
        },

        clean: function() {
            storerules.removeAll();
        },

        disable: function() {
            gridRules.disable();
        },

        enable: function() {
            gridRules.enable();
        },

        load: function(groupid, categoryid) {
            if (categoryid != null) {
                storerules.baseParams={groupid: groupid, categoryid: categoryid};
                storerules.load();
            }
        },
        get: function() {
            return gridRules;
        },
        untoggle: function() {
            Ext.getCmp('platform-but').toggle(false, true);
        },

        sendModifiedRecords: function() {
            var modifiedrules = storerules.getModifiedRecords();
            var returnjson = {};
            for (var i = 0; i < modifiedrules.length; i++) {
                ret = {}
                ret['state'] = modifiedrules[i].data.state;
                ret['value'] = modifiedrules[i].data.value;
                ret['herited'] = modifiedrules[i].data.herited;
                returnjson[modifiedrules[i].id] = ret;
            };
            returnjson = Ext.util.JSON.encode(returnjson);
            Ext.Ajax.request({
                url: 'set/choices',
                params: {groupid: GASP.group.getSelectedId(), modifiedrules: returnjson},
                //callback: function() {
                failure: function() {
                    GASP.observable.fireEvent('reloadRules')
                },
                success: function() {
                    storerules.commitChanges()
                    GASP.observable.fireEvent('saveRules')
                }
            });
        }
    };
})();

// vim: ts=4 sw=4 expandtab
