#!/usr/bin/env python
# _*_ coding: iso-8859-1 _*_

from distutils.core import setup
import py2exe
import os, shutil
import sys
from manifest import manifest
import glob

try:
    # py2exe 0.6.4 introduced a replacement modulefinder.
    # This means we have to add package paths there, not to the built-in
    # one.  If this new modulefinder gets integrated into Python, then
    # we might be able to revert this some day.
    # if this doesn't work, try import modulefinder
    try:
        import py2exe.mf as modulefinder
    except ImportError:
        import modulefinder
    import win32com
    for p in win32com.__path__[1:]:
        modulefinder.AddPackagePath("win32com", p)
    for extra in ["win32com.shell"]: #,"win32com.mapi"
        __import__(extra)
        m = sys.modules[extra]
        for p in m.__path__[1:]:
            modulefinder.AddPackagePath(extra, p)
except ImportError:
    # no build path setup, no worries.
    pass

os.environ['path']='%s;%s'%(os.environ['path'], os.path.join(os.path.abspath('.'), 'dlls'))



# recuperation des chemins contenant les DLLs
dll1 = os.path.join(os.path.abspath('.'), 'Py26dlls.MFC')
dll2 = os.path.join(os.path.abspath('.'), 'Py26dlls.MSV')
# Ajout de ces chemins au %PATH%
os.environ['path']=';'.join([os.environ['path'], dll1, dll2])

# Ajout des DLLS aux 'data_files'
Py26dllsMFC = glob.glob(r"Py26dlls.MFC\*.*")
Py26dllsMSV = glob.glob(r"Py26dlls.MSV\*.*")

if os.path.exists("build"):
    shutil.rmtree("build")

opts = {"py2exe": {
                   "packages":["encodings","lxml","gzip"],
                   "optimize":1,
                   "bundle_files": 1,
                   "compressed":True,
}}

setup(name = 'Integrdom',
      version = '1.2',
      description = 'Utilitaire de jonction au domaine Scribe',
      author = 'cdeze',
      author_email = 'christophedeze@wanadoo.fr',
      options=opts,
      url = '',
      windows = [{'script': 'IntegrDomCLI.py',
                  'other_resources': [(24, 1, manifest%{'prog': 'IntegrDom'})],
                  'icon_resources': [(1, 'eole.ico')]
                }],
      data_files=[('', ['eole.ico']),
	          ('', Py26dllsMSV),
              	  ('', Py26dllsMFC)
      ],
      zipfile = None,

      )
import tarfile
#shutil.move('dist/*', 'windows/eole/tmp/')
tar = tarfile.open("joinscribe.tar", "w")
tar.add("windows")
tar.close()
shutil.move('joinscribe.tar', '../joinscribe.tar')

