#!/usr/bin/env python
# -*- coding: UTF-8 -*-
###########################################################################
#script permettant de faire joindre à un domaine scribe un groupe de machines
#cdeze@ac-nantes.fr
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
##########################################################################
import os, sys, getpass
from threading import Thread
from optparse import OptionParser


def parse_cmdline():
    """ join_scribe.py -d 192.168.1.1 -f 192.168.1.254 """
    parser = OptionParser(usage="%prog -d 192.168.1.1 -f 192.168.1.254")

    parser.add_option("-d", "--ipdebut", dest="ipdebut", default=None, help=u"ip debut")
    parser.add_option("-f", "--ipfin", dest="ipfin", help=u"ipfin")

    (options, args) = parser.parse_args()

    if not options.ipdebut:
        parser.error("il faut au moins une ip : option -d ")
    if not options.ipfin:
        options.ipfin = options.ipdebut
    return options, args


class joinscribe(Thread):
    def __init__ (self, ip, adminlocal, passlocal, smb_netbios_name, adresse_ip_eth0, smb_workgroup, adminpw):
        Thread.__init__(self)
        self.ip = ip
        self.adminlocal = adminlocal
        self.passlocal = passlocal
        self.smb_netbios_name = smb_netbios_name
        self.adresse_ip_eth0 = adresse_ip_eth0
        self.smb_workgroup = smb_workgroup
        self.adminpw = adminpw

    def run(self):
        # This code is what each parallel thread does
        # the 'run' method is triggered when 'start' is called
        import socket
        from time import strftime
        try:
        #on loggue dans logs/1.2.3.4.log
            
            log_f = r'/var/log/joinscribe/' + self.ip + '.log'
            fp = open(log_f,'a')
            fp.write("..........................................\n")
            fp.write(strftime("%d-%m-%Y %H:%M:%S") + '\n')
            journal(fp, self.ip + ' ' + self.adminlocal + ' ' + self.smb_netbios_name + ' ' + self.adresse_ip_eth0 + ' ' + self.smb_workgroup + '\n')
            # on test le 445 du client
            s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)   
            s.settimeout(2)   
            s.connect((self.ip, 445))
            s.close()
            journal(fp, " Success connecting to " + self.ip)
            # on test l'existence des partages \\1.2.3.4\c$ \\1.2.3.4\ipc$ \\1.2.3.4\admin$
            testcdollar = testshare(self.ip, self.adminlocal, self.passlocal)
            if testcdollar != 0:
                journal(fp, " Probleme avec les partages administratifs: c$ ipc$ " + str(testcdollar))
            # on copie le contenu de joinscribe.tar 
            journal(fp, " Copie des fichiers necessaires sur " + self.ip)
            retsmbclient = smb_client(self.ip, self.adminlocal, self.passlocal)
            if retsmbclient != 0:
                journal(fp,"	retour smbclient :" + str(retsmbclient))
            # on execute integrdomcli.exe sur le client
            journal(fp," Integration de poste " + self.ip + " au domaine " + self.smb_workgroup)
            retjoindom = joindom(self.ip, self.adminlocal, self.passlocal, self.smb_netbios_name, self.adresse_ip_eth0, self.smb_workgroup, self.adminpw)          
            if retjoindom != 0:
                journal(fp,"	retour joindom :" + str(retjoindom))
            fp.close()
        except socket.error:
            journal(fp, " Connection impossible vers " + self.ip + ":445 ... le parefeu est activé ?"    )
            s.close()
            fp.close()

def journal(fp, txt):
    """ on loggue dans un fichier et sur la sortie standard """
    fp.write(txt + '\n')
    print txt 

def main():
    options, args = parse_cmdline()
    ipdebut = options.ipdebut
    ipfin = options.ipfin
    lipfin = ipfin.split(".")
    lipdebut = ipdebut.split(".")
    if (lipdebut[0] != lipfin[0]) or (lipdebut[1] != lipfin[1]) or (lipdebut[2] != lipfin[2]) :
        print "L'ip de fin de etre de la forme " + lipdebut[0] + "." + lipdebut[1] + "." + lipdebut[2] + ".x"
        sys.exit()
    # on recupere les variables du dico 
    try:
        from creole import parsedico
        dic = parsedico.parse_dico()   
    except:
        from creole.client import CreoleClient
        dic = CreoleClient().get_creole()
    #on cree le dossier qui va contenir les logs
    os.system(r'mkdir -p /var/log/joinscribe')
    print "****************************************************"
    print "Ce script n'a ete teste que sur des stations XP pro"
    print "le parefeu et le partage simple doivent etre desactives"
    print " le mot de passe de l'administrateur local ne doit pas etre vierge"
    print "****************************************************"
    (adminlocal, passlocal, adminpw) = ask_mdp()
    iplist = []
    for host in range(int(lipdebut[3]), int(lipfin[3]) + 1):
        ip = lipdebut[0] + "." + lipdebut[1] + "." + lipdebut[2] + "." + str(host)
        # create a thread, add it to a thread list
        current = joinscribe(ip, adminlocal, passlocal, dic['smb_netbios_name'], dic['adresse_ip_eth0'], dic['smb_workgroup'], adminpw)
        iplist.append(current)
        # start the thread running
        current.start()
    
    for ipthread in iplist:
        # await the completion of each thread in turn
        ipthread.join()
   

def ask_mdp():
    default_localuser = "administrateur"
    localuser = raw_input("Entrez votre login administrateur local [" + default_localuser + "] : ")
    if localuser == "": localuser = default_localuser 
    localpasswd = getpass.getpass("Mot de passe pour %s : " % localuser)
    adminpw = getpass.getpass("Mot de passe pour l'admin scribe ? : ")
    return localuser, localpasswd, adminpw

def smb_client(ip, user, passwd):
    ret = os.system(r'smbclient //' + ip + r'/c$   -U /' + user + r'%' + passwd +r'  -Tx /home/client_scribe/joinscribe.tar 2>/dev/null ')
    return ret


def joindom(ip, adminlocal, passlocal, smb_netbios_name, adresse_ip_eth0, smb_workgroup, adminpw):
    ret = os.system(r'winexe -U /' + adminlocal + r'%' + passlocal + r' --runas=' + adminlocal + r'%' + passlocal + r' //' + ip + r' "c:\windows\eole\tmp\integrdomCLI.exe ' +  smb_netbios_name + ' ' + adresse_ip_eth0 + ' ' + smb_workgroup + r' admin ' +  adminpw + r'"')
    return ret

def testshare(ip, user, passwd):
    ipc = os.system(r'smbclient //' + ip + r'/ipc$ -U /' + user + r'%' + passwd + r' -c quit 2>/dev/null ')
    admin = os.system(r'smbclient //' + ip + r'/admin$ -U /' + user + r'%' + passwd + r' -c quit 2>/dev/null')
    c = os.system(r'smbclient //' + ip + r'/c$ -U /' + user + r'%' + passwd + r' -c quit 2>/dev/null')
    return ipc + admin + c

if __name__ == '__main__':
    main()

