# -*- coding: UTF-8 -*-
# Copyright (C) 2014 Équipe EOLE.
#
"internationalisation utility"
import gettext

system_locale_dir = "/usr/share/locale"

class i18n(object):
    """callable version of gettext
    """
    def __init__(self, app_name):
        self.t = gettext.translation(app_name, localedir=system_locale_dir, fallback=True)

    def __call__(self, *args):
        # "polymorphism" rather than duck-typing to ease xgettext extraction work (keywordspec format)
        if len(args) == 1:
            return self.t.ugettext(*args)
        else:
            return self.t.ungettext(*args)
