# -*- coding: UTF-8 -*-
from __future__ import print_function
from pyeole.translation.i18n import _
from pyeole.ansiprint import print_color, print_orange, \
                             print_red, print_blue, \
                             print_green, NOTPUT
import sys
from sys import argv
from os import system, getuid
from signal import signal, SIGINT
from itertools import imap, izip
from pyeole.common import get_current_column

reload(sys)
sys.setdefaultencoding('utf-8')


def question_ouinon(question, interactive=True, default='non',
        default_uninteractive=None, level='info'):
    # conversion en str si unicode
    if type(default) == type(u""):
        default = default.encode('ascii','ignore')
    if type(default_uninteractive) == type(u""):
        default_uninteractive = default_uninteractive.encode('ascii', 'ignore')
    if type(question) == type(u""):
        question = question.encode('utf8')
    #attention, il faut synchroniser les modifications avec /usr/lib/eole/ihm.sh
    if default not in ['oui', 'non']:
        raise ValueError(_(u'question_ouinon : default must be "yes" or "no"'))
    if default_uninteractive is None:
        default_uninteractive = default
    if default_uninteractive not in ['oui', 'non']:
        raise ValueError(_(u'question_ouinon : default must be "yes" or "no"'))
    if level not in ['info', 'warn', 'err']:
        raise ValueError(_(u'question_ouinon : level must be "info", "warn" or "err"'))
    #non-interactive
    if not interactive:
        return default_uninteractive
    question += _(u' [yes/no]')
    if level == 'info':
        print(question)
    elif level == 'warn':
        print_orange(question)
    else:
        print_red(question)
    rep = raw_input('[%s] : '%default)
    if default == 'non':
        if rep.lower() in ['o', 'oui', 'y', 'yes']:
            return "oui"
        else:
            return "non"
    else:
        if rep.lower() in ['n', 'non', 'no']:
            return "non"
        else:
            return "oui"

def print_title_rule(cols=None):
    """ print a title rule composed of '-'
    """
    if not cols:
        cols = get_current_column()

    try:
        print_blue('{:-^{col}}'.format('', col=cols))
    except ValueError:
        pass


def print_title(msg, cols=None):
    """ Print a title with this format :
        ###\t{message}\t###
    """
    if not cols:
        cols = get_current_column()

    try:
        output = u"{:^{col}}".format(msg, col=cols)
        print_title_rule()
        print_blue(output)
        print_title_rule()
    except ValueError:
        print(msg)

def print_no_cr(msg, column=None):
    """ print a line align on right without '\n'
    """
    if not column:
        column = get_current_column()

    try:
        fstr = "{:<{col}}".format(msg, col=column)
        sys.stdout.write(fstr)
        sys.stdout.flush()
    except ValueError:
        print(msg)

def print_line(msg, column=None):
    """ print a line align on right with '\n'
    """
    if not column:
        column = get_current_column()

    try:
        fstr = "{:<{col}}\n".format(msg, col=column)
        sys.stdout.write(fstr)
        sys.stdout.flush()
    except ValueError:
        print(msg)

def nice_list_print(string_list, columns=None, silent=False):
    """ Print a python list nicely
    """
    separator = " "
    if not columns:
        columns = get_current_column()

    try:
        nb_col = columns / len(max(string_list))

        "Produce equal-width columns from string_list"
        sublists = []

        # empty_str based on item 0 of string_list
        try:
            empty_str = type(string_list[0])()
        except IndexError: # string_list is empty
            print("")

        # create a sublist for every column
        for col in xrange(nb_col):
            sublists.append(string_list[col::nb_col])

        # find maximum length of a column
        max_sublist_len = max(imap(len, sublists))

        # make all columns same length
        for sublist in sublists:
            if len(sublist) < max_sublist_len:
                sublist.append(empty_str)

        # calculate a format string for the output lines
        format_str = separator.join(
            "%%-%ds" % max(imap(len, sublist))
             for sublist in sublists)

        if silent:
            ret = []
            for line_items in izip(*sublists):
                ret.append(format_str % line_items)
            return ret
        else:
            for line_items in izip(*sublists):
                print(format_str % line_items)

    except ValueError:
        print(string_list)

def clear():
    """ Clear console if suitable
    """
    if not NOTPUT:
        system('clear')

def only_root():
    if getuid() != 0:
        print_red(_(u"{0} can only be launched by root").format(argv[0]))
        sys.exit(1)

def proper_exit(*args):
    """callback par défaut appelé lors d'un ctrl-c"""
    print(_(u"Cancelled by user."))
    sys.exit(1)

def catch_signal(exit_func=None):
    """gestion du ctrl-c"""
    if not exit_func:
        signal(SIGINT, proper_exit)
    else:
        signal(SIGINT, exit_func)
