# -*- coding: utf-8 -*-

#########################################################################
# pyeole.service - manage EOLE services
# Copyright © 2013 Pôle de Compétence EOLE <eole@ac-dijon.fr>
#
# License CeCILL:
#  * in french: http://www.cecill.info/licences/Licence_CeCILL_V2-fr.html
#  * in english http://www.cecill.info/licences/Licence_CeCILL_V2-en.html
#########################################################################

"""EOLE service management errors

"""

class ServiceError(StandardError):
    """An error occurs in service management.

    This is the base class used by all service related exceptions.

    """
    pass


class ConfigureError(ServiceError):
    """An error occurs when configuring a service in system boot process.

    """
    pass


class DisabledError(ServiceError):
    """Service is disabled.

    """
    pass


class UnknownServiceError(ServiceError):
    """Service is unknown to creoled or the system.

    """
    pass


class StartError(ServiceError):
    """Unable to start a service or missing start configuration files.

    """
    pass


class StopError(ServiceError):
    """Unable to stop a service or missing stop configuration files.

    """
    pass
