#!/usr/bin/env python
# -*- coding: utf-8 -*-

# fichier d'installation
# pour le paquet python-pyeole

from distutils.core import setup
from os.path import dirname, abspath, normpath, join, splitext, basename
from os import walk
from glob import glob
from subprocess import call

trad_root = "share/locale"
trad_dir = "LC_MESSAGES"
here = dirname(abspath(__file__))

def build_translation():
   po_path = join(here, "translation")
   result = []

   for top, dirs, files in walk(po_path):
       for directory in dirs:
           tr_dir = join(top, directory)
           # Search for .po file for a traduction
           trad_files = []
           for pot_file in glob(join(tr_dir, "*.po")):
               mo_file = splitext(pot_file)[0] + ".mo"
               lang = basename(tr_dir) 
               cmd = ["msgfmt", pot_file, "-o", mo_file]
               dest = join(trad_root, lang, trad_dir)
               trad_files.append(join("translation", lang, basename(mo_file)))
               call(cmd)
           result.append((dest, trad_files))

   return result

translations = build_translation()

setup(
    author='Équipe Eole',
    author_email='eole@ac-dijon.fr',
    name='python-pyeole',
    version='2.5.2',
    description='Librairie commune Eole',
    url='http://www.eole.orion.education.fr',
    packages=['pyeole', 
              'pyeole.dict4ini', 
              'pyeole.service', 
              'pyeole.diagnose', 
              'pyeole.service.module',
              'pyeole.translation'],
    scripts = ['bin/tcpcheck'],
    data_files = translations
)

