#-*-coding:utf-8*-*
"""
Tests unitaires sur le module pyeole.encode
"""
from py.test import raises
from pyeole.encode import normalize

string = "é"
uni = u"é"

def test_type():
    """
    Tests des types retournés par la fonction normalize
    """
    assert type(normalize(string)) is unicode
    assert type(normalize(uni)) is unicode

def test_format():
    """
    Tests sur la fonction normalize
    """
    raises(UnicodeEncodeError, "'{0}t{1}'.format(string, uni)")
    raises(UnicodeEncodeError, "'{0}t{1}'.format(normalize(string), normalize(uni))")
    raises(UnicodeDecodeError, "u'{0}t{1}'.format(string, uni)")
    u'{0}t{1}'.format(normalize(string), normalize(uni))
