# -*- coding: utf-8 -*-

from os.path import join, isdir
from os import makedirs, unlink

import autopath
from pyeole import log

import logging

DATA = join(autopath.HERE, "data")
TEST_FORMAT = "%(asctime)s - %(name)s - %(levelname)s - TESTTEST '%(funcName)s' %(message)s"
log.DEFAULT_LOG_FILE = join(DATA, 'eole-default.log')

def setup_module(module):

    if not isdir(DATA):
        makedirs(DATA)

    module.logfile  = join(DATA, "eole-log.log")
    module.errfile   = join(DATA, "eole-critical.log")
    module.debugfile = join(DATA, "eole-debug.log")

    module.logfilesplit  = join(DATA, "eole-split-log.log")
    module.errfilesplit   = join(DATA, "eole-split-critical.log")
    module.debugfilesplit = join(DATA, "eole-split-debug.log")

    module.logfileformat  = join(DATA, "eole-format-log.log")
    module.errfileformat   = join(DATA, "eole-format-critical.log")
    module.debugfileformat = join(DATA, "eole-format-debug.log")

    module.eolelog = log.make_logger("testpackage", logfile, errfile=errfile, debugfile=debugfile, loglevel="DEBUG", splitlog=False)
    module.eolesplitlog = log.make_logger("testpackagesplit", logfilesplit, errfile=errfilesplit, debugfile=debugfilesplit, loglevel="DEBUG", splitlog=True)
    module.eoleformatlog = log.make_logger("testpackageformat", logfileformat, errfileformat, debugfileformat, "DEBUG", False, TEST_FORMAT)

def test_format_logger():
    eoleformatlog.critical("test critical message")
    assert "TESTTEST" in file(debugfileformat).read().splitlines()[-1]
    assert "TESTTEST" in file(logfileformat).read().splitlines()[-1]
    assert "TESTTEST" in file(errfileformat).read().splitlines()[-1]

    eoleformatlog.error("test error message")
    assert "TESTTEST" in file(debugfileformat).read().splitlines()[-1]
    assert "TESTTEST" in file(logfileformat).read().splitlines()[-1]
    assert "TESTTEST" in file(errfileformat).read().splitlines()[-1]

    eoleformatlog.warning("test warning message")
    assert "TESTTEST" in file(debugfileformat).read().splitlines()[-1]
    assert "TESTTEST" in file(logfileformat).read().splitlines()[-1]
    assert "TESTTEST" in file(errfileformat).read().splitlines()[-1]

    eoleformatlog.info("test info message")
    assert "TESTTEST" in file(debugfileformat).read().splitlines()[-1]
    assert "TESTTEST" in file(logfileformat).read().splitlines()[-1]
    assert "TESTTEST" in file(errfileformat).read().splitlines()[-1]

    eoleformatlog.debug("test debug message")
    assert "TESTTEST" in file(debugfileformat).read().splitlines()[-1]
    assert "TESTTEST" in file(logfileformat).read().splitlines()[-1]
    assert "TESTTEST" in file(errfileformat).read().splitlines()[-1]

def test_split_logger():
    eolesplitlog.critical("test critical message")
    assert "critical" not in file(debugfilesplit).read()
    assert "critical" not in file(logfilesplit).read()
    assert "critical" in file(errfilesplit).read()

    eolesplitlog.error("test error message")
    assert "error" not in file(debugfilesplit).read()
    assert "error" not in file(logfilesplit).read()
    assert "error" in file(errfilesplit).read()

    eolesplitlog.warning("test warning message")
    assert "warning" not in file(debugfilesplit).read()
    assert "warning" not in file(logfilesplit).read()
    assert "warning" in file(errfilesplit).read()

    eolesplitlog.info("test info message")
    assert "info" not in file(debugfilesplit).read()
    assert "info" in file(logfilesplit).read()
    assert "info" not in file(errfilesplit).read()

    eolesplitlog.debug("test debug message")
    assert "debug" in file(debugfilesplit).read()
    assert "debug" not in file(logfilesplit).read()
    assert "debug" not in file(errfilesplit).read()

def test_logger():
    eolelog.critical("test critical message")
    assert "critical" in file(logfile).read()
    assert "critical" in file(errfile).read()
    assert "critical" in file(debugfile).read()

    eolelog.error("test error message")
    assert "error" in file(errfile).read()
    assert "error" in file(logfile).read()
    assert "error" in file(debugfile).read()

    eolelog.warning("test warning message")
    assert "warning" in file(errfile).read()
    assert "warning" in file(logfile).read()
    assert "warning" in file(debugfile).read()

    eolelog.info("test info message")
    assert "info" not in file(errfile).read()
    assert "info" in file(logfile).read()
    assert "info" in file(debugfile).read()

    eolelog.debug("test debug message")
    assert "debug" not in file(errfile).read()
    assert "debug" not in file(logfile).read()
    assert "debug" in file(debugfile).read()

def teardown_module(module):
   # return
    unlink(module.logfile)
    unlink(module.errfile)
    unlink(module.debugfile)
    unlink(module.logfilesplit)
    unlink(module.errfilesplit)
    unlink(module.debugfilesplit)
    unlink(module.logfileformat)
    unlink(module.errfileformat)
    unlink(module.debugfileformat)

